/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

class UTF16Decoder
extends IBMCharsetDecoder {
    protected static final char BYTE_ORDER_MARK = '\ufeff';
    protected static final char REVERSED_MARK = '\ufffe';
    protected static final int NONE = 0;
    protected static final int BIG = 2;
    protected static final int LITTLE = 1;
    private final int expectedByteOrder;
    private int currentByteOrder;
    private final Surrogate.Generator sgg = new Surrogate.Generator();

    public UTF16Decoder(Charset charset, int n) {
        super(charset, 1.0f, 1.0f);
        this.expectedByteOrder = this.currentByteOrder = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        try {
            while (byteBuffer.remaining() > 1) {
                char c;
                int n2 = byteBuffer.get() & 0xFF;
                int n3 = byteBuffer.get() & 0xFF;
                if (this.currentByteOrder == 0) {
                    c = (char)(n2 << 8 | n3);
                    if (c == '\ufeff') {
                        this.currentByteOrder = 2;
                        n += 2;
                        continue;
                    }
                    if (c == '\ufffe') {
                        this.currentByteOrder = 1;
                        n += 2;
                        continue;
                    }
                    this.currentByteOrder = 2;
                }
                if ((c = this.currentByteOrder == 2 ? (char)(n2 << 8 | n3) : (char)(n3 << 8 | n2)) == '\ufffe') {
                    CoderResult coderResult = CoderResult.malformedForLength(2);
                    return coderResult;
                }
                if (Surrogate.is(c)) {
                    if (Surrogate.isLow(c)) {
                        CoderResult coderResult = CoderResult.malformedForLength(2);
                        return coderResult;
                    }
                    if (byteBuffer.remaining() < 2) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    int n4 = byteBuffer.get() & 0xFF;
                    int n5 = byteBuffer.get() & 0xFF;
                    char c2 = this.currentByteOrder == 2 ? (char)(n4 << 8 | n5) : (char)(n5 << 8 | n4);
                    if (!Surrogate.isLow(c2)) {
                        CoderResult coderResult = CoderResult.malformedForLength(2);
                        return coderResult;
                    }
                    if (charBuffer.remaining() < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    charBuffer.put(c);
                    charBuffer.put(c2);
                    n += 4;
                    continue;
                }
                if (!charBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                charBuffer.put(c);
                n += 2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected void implReset() {
        this.currentByteOrder = this.expectedByteOrder;
    }
}

