/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

class GB18030Encoder
extends IBMCharsetEncoder {
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    protected static final int LINEAR_FOUR_BASE = 24067;
    protected static final int LINEAR_BIG = 189000;
    private final char[] index;
    private final char[] ranges;
    private final char[] values;
    private final byte[] outBytes;
    private final int convType;

    protected GB18030Encoder(Charset charset, char[] cArray, char[] cArray2, char[] cArray3, String string) {
        super(charset, 2.0f, 3.0f);
        this.index = cArray;
        this.ranges = cArray2;
        this.values = cArray3;
        if (string != null && string.length() > 0) {
            this.convType = string.charAt(0) - 48;
            if (this.convType == 2) {
                this.replaceWith(new byte[]{-95, -95});
            }
        } else {
            this.convType = 0;
        }
        this.outBytes = new byte[4];
    }

    public boolean isLegalReplacement(byte[] byArray) {
        if (byArray[0] >= 0) {
            return true;
        }
        return super.isLegalReplacement(byArray);
    }

    public boolean canEncode(char c) {
        return !Surrogate.is(c);
    }

    private int getBytes(int n, byte[] byArray) {
        if (n <= 65535) {
            int n2 = this.index[n >> 9] << 2;
            while (n >= this.ranges[n2]) {
                if (n <= this.ranges[n2 + 1]) {
                    int n3;
                    switch (this.ranges[n2 + 2]) {
                        default: {
                            byArray[0] = (byte)(this.ranges[n2 + 3] + (n - this.ranges[n2]));
                            return 1;
                        }
                        case '\u0001': {
                            n3 = this.values[this.ranges[n2 + 3] + (n - this.ranges[n2])];
                            break;
                        }
                        case '\u0002': {
                            n3 = this.ranges[n2 + 3] + (n - this.ranges[n2]);
                        }
                    }
                    if (n3 < 24067) {
                        byArray[1] = (byte)(64 + --n3 % 191);
                        byArray[0] = (byte)(129 + (n3 /= 191));
                        return 2;
                    }
                    byArray[3] = (byte)(48 + (n3 -= 24067) % 10);
                    byArray[2] = (byte)(129 + (n3 /= 10) % 126);
                    byArray[1] = (byte)(48 + (n3 /= 126) % 10);
                    byArray[0] = (byte)(129 + (n3 /= 10));
                    return 4;
                }
                n2 += 4;
            }
        } else if (n >= 65536 && n <= 0x10FFFF) {
            int n4 = 189000 + (n - 65536);
            byArray[3] = (byte)(48 + n4 % 10);
            byArray[2] = (byte)(129 + (n4 /= 10) % 126);
            byArray[1] = (byte)(48 + (n4 /= 126) % 10);
            byArray[0] = (byte)(129 + (n4 /= 10));
            return 4;
        }
        return 0;
    }

    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        int n2;
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n5 = byteBuffer.arrayOffset() + byteBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n3; n += n2) {
            int n6 = cArray[n];
            n2 = 1;
            if (Surrogate.is((char)n6)) {
                if ((n6 = this.sgp.parse((char)n6, cArray, n, n3)) < 0) {
                    coderResult = this.sgp.error();
                    break;
                }
                n2 = this.sgp.increment();
            }
            int n7 = this.getBytes(n6, this.outBytes);
            if (this.convType != 0 && (n7 > 2 || this.convType == 2 && n7 != 2)) {
                coderResult = CoderResult.unmappableForLength(n2);
                break;
            }
            if (n5 - n4 < n7) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            for (int i = 0; i < n7; ++i) {
                byArray[n4++] = this.outBytes[i];
            }
        }
        charBuffer.position(n - charBuffer.arrayOffset());
        byteBuffer.position(n4 - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                int n2 = charBuffer.get();
                int n3 = 1;
                if (Surrogate.is((char)n2)) {
                    if ((n2 = this.sgp.parse((char)n2, charBuffer)) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    n3 = this.sgp.increment();
                }
                int n4 = this.getBytes(n2, this.outBytes);
                if (this.convType != 0 && (n4 > 2 || this.convType == 2 && n4 != 2)) {
                    CoderResult coderResult = CoderResult.unmappableForLength(n3);
                    return coderResult;
                }
                if (byteBuffer.remaining() < n4) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                for (int i = 0; i < n4; ++i) {
                    byteBuffer.put(this.outBytes[i]);
                }
                n += n3;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray() && !UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

