/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private String detailMessage;
    private transient Object walkback;
    private Throwable cause = this;
    private StackTraceElement[] stackTrace = null;

    public Throwable() {
        this.fillInStackTrace();
    }

    public Throwable(String string) {
        this();
        this.detailMessage = string;
    }

    public Throwable(String string, Throwable throwable) {
        this();
        this.detailMessage = string;
        this.cause = throwable;
    }

    public Throwable(Throwable throwable) {
        this();
        this.detailMessage = throwable == null ? null : throwable.toString();
        this.cause = throwable;
    }

    public native Throwable fillInStackTrace();

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    private native StackTraceElement[] getStackTraceImpl();

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getInternalStackTrace().clone();
    }

    public void setStackTrace(StackTraceElement[] stackTraceElementArray) {
        StackTraceElement[] stackTraceElementArray2 = (StackTraceElement[])stackTraceElementArray.clone();
        for (int i = 0; i < stackTraceElementArray2.length; ++i) {
            if (stackTraceElementArray2[i] != null) continue;
            throw new NullPointerException();
        }
        this.stackTrace = stackTraceElementArray2;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    private static int countDuplicates(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
        StackTraceElement stackTraceElement;
        int n = 0;
        int n2 = stackTraceElementArray2.length;
        int n3 = stackTraceElementArray.length;
        while (--n3 >= 0 && --n2 >= 0 && (stackTraceElement = stackTraceElementArray2[n2]).equals(stackTraceElementArray[n3])) {
            ++n;
        }
        return n;
    }

    private StackTraceElement[] getInternalStackTrace() {
        if (this.stackTrace == null) {
            this.stackTrace = this.getStackTraceImpl();
        }
        return this.stackTrace;
    }

    public void printStackTrace(PrintStream printStream) {
        printStream.println(this.toString());
        StackTraceElement[] stackTraceElementArray = this.getInternalStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            printStream.println("\tat " + stackTraceElementArray[i]);
        }
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
        for (Throwable throwable = this.getCause(); throwable != null; throwable = throwable.getCause()) {
            printStream.print("Caused by: ");
            printStream.println(throwable);
            StackTraceElement[] stackTraceElementArray3 = throwable.getInternalStackTrace();
            int n = Throwable.countDuplicates(stackTraceElementArray3, stackTraceElementArray2);
            for (int i = 0; i < stackTraceElementArray3.length - n; ++i) {
                printStream.println("\tat " + stackTraceElementArray3[i]);
            }
            if (n > 0) {
                printStream.println("\t... " + n + " more");
            }
            stackTraceElementArray2 = stackTraceElementArray3;
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.println(this.toString());
        StackTraceElement[] stackTraceElementArray = this.getInternalStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            printWriter.println("\tat " + stackTraceElementArray[i]);
        }
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
        for (Throwable throwable = this.getCause(); throwable != null; throwable = throwable.getCause()) {
            printWriter.print("Caused by: ");
            printWriter.println(throwable);
            StackTraceElement[] stackTraceElementArray3 = throwable.getInternalStackTrace();
            int n = Throwable.countDuplicates(stackTraceElementArray3, stackTraceElementArray2);
            for (int i = 0; i < stackTraceElementArray3.length - n; ++i) {
                printWriter.println("\tat " + stackTraceElementArray3[i]);
            }
            if (n > 0) {
                printWriter.println("\t... " + n + " more");
            }
            stackTraceElementArray2 = stackTraceElementArray3;
        }
    }

    public String toString() {
        String string = this.getLocalizedMessage();
        String string2 = this.getClass().getName();
        if (string == null) {
            return string2;
        }
        return new StringBuffer(string2.length() + 2 + string.length()).append(string2).append(": ").append(string).toString();
    }

    public synchronized Throwable initCause(Throwable throwable) {
        if (this.cause == this) {
            if (throwable != this) {
                this.cause = throwable;
                return this;
            }
            throw new IllegalArgumentException("Cause cannot be the receiver");
        }
        throw new IllegalStateException("Cause already initialized");
    }

    public Throwable getCause() {
        if (this.cause == this) {
            return null;
        }
        return this.cause;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.getInternalStackTrace();
        objectOutputStream.defaultWriteObject();
    }
}

