/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public final class StringBuffer
implements Serializable,
CharSequence,
Appendable {
    private static final long serialVersionUID = 3388685877147921107L;
    private static final int INITIAL_SIZE = 16;
    private int count;
    private char[] value;
    private boolean shared;

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int n) {
        this.count = 0;
        this.value = new char[n];
    }

    public StringBuffer(String string) {
        this.count = string.length();
        this.value = new char[this.count + 16];
        string.getChars(0, this.count, this.value, 0);
    }

    public synchronized StringBuffer append(char[] cArray) {
        int n = this.count + cArray.length;
        if (n > this.value.length) {
            this.ensureCapacityImpl(n);
        } else if (this.shared) {
            this.value = (char[])this.value.clone();
            this.shared = false;
        }
        System.arraycopy((Object)cArray, 0, (Object)this.value, this.count, cArray.length);
        this.count = n;
        return this;
    }

    public synchronized StringBuffer append(char[] cArray, int n, int n2) {
        if (n >= 0 && 0 <= n2 && n2 <= cArray.length - n) {
            int n3 = this.count + n2;
            if (n3 > this.value.length) {
                this.ensureCapacityImpl(n3);
            } else if (this.shared) {
                this.value = (char[])this.value.clone();
                this.shared = false;
            }
            System.arraycopy((Object)cArray, n, (Object)this.value, this.count, n2);
            this.count = n3;
            return this;
        }
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized StringBuffer append(char c) {
        if (this.count >= this.value.length) {
            this.ensureCapacityImpl(this.count + 1);
        }
        if (this.shared) {
            this.value = (char[])this.value.clone();
            this.shared = false;
        }
        this.value[this.count] = c;
        ++this.count;
        return this;
    }

    public StringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public StringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public StringBuffer append(int n) {
        return this.append(Integer.toString(n));
    }

    public StringBuffer append(long l) {
        return this.append(Long.toString(l));
    }

    public StringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public synchronized StringBuffer append(String string) {
        int n;
        int n2;
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n2 = this.count + (n = string.length())) > this.value.length) {
            this.ensureCapacityImpl(n2);
        } else if (this.shared) {
            this.value = (char[])this.value.clone();
            this.shared = false;
        }
        string.getChars(0, n, this.value, this.count);
        this.count = n2;
        return this;
    }

    public StringBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public int capacity() {
        return this.value.length;
    }

    public synchronized char charAt(int n) {
        try {
            if (n < this.count) {
                return this.value[n];
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public synchronized StringBuffer delete(int n, int n2) {
        if (n >= 0) {
            if (n2 > this.count) {
                n2 = this.count;
            }
            if (n2 > n) {
                int n3 = this.count - n2;
                if (n3 > 0) {
                    try {
                        if (!this.shared) {
                            System.arraycopy((Object)this.value, n2, (Object)this.value, n, n3);
                        } else {
                            char[] cArray = new char[this.value.length];
                            System.arraycopy((Object)this.value, 0, (Object)cArray, 0, n);
                            System.arraycopy((Object)this.value, n2, (Object)cArray, n, n3);
                            this.value = cArray;
                            this.shared = false;
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new StringIndexOutOfBoundsException();
                    }
                }
                this.count -= n2 - n;
                return this;
            }
            if (n == n2) {
                return this;
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized StringBuffer deleteCharAt(int n) {
        if (0 <= n && n < this.count) {
            int n2 = this.count - n - 1;
            if (n2 > 0) {
                try {
                    if (!this.shared) {
                        System.arraycopy((Object)this.value, n + 1, (Object)this.value, n, n2);
                    } else {
                        char[] cArray = new char[this.value.length];
                        System.arraycopy((Object)this.value, 0, (Object)cArray, 0, n);
                        System.arraycopy((Object)this.value, n + 1, (Object)cArray, n, n2);
                        this.value = cArray;
                        this.shared = false;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new StringIndexOutOfBoundsException(n);
                }
            }
            --this.count;
            return this;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public synchronized void ensureCapacity(int n) {
        if (n > this.value.length) {
            this.ensureCapacityImpl(n);
        }
    }

    private void ensureCapacityImpl(int n) {
        int n2 = (this.value.length << 1) + 2;
        char[] cArray = new char[n > n2 ? n : n2];
        System.arraycopy((Object)this.value, 0, (Object)cArray, 0, this.count);
        this.value = cArray;
        this.shared = false;
    }

    public synchronized void getChars(int n, int n2, char[] cArray, int n3) {
        try {
            if (n <= this.count && n2 <= this.count) {
                System.arraycopy((Object)this.value, n, (Object)cArray, n3, n2 - n);
                return;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized StringBuffer insert(int n, char[] cArray) {
        if (0 <= n && n <= this.count) {
            this.move(cArray.length, n);
            System.arraycopy((Object)cArray, 0, (Object)this.value, n, cArray.length);
            this.count += cArray.length;
            return this;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public synchronized StringBuffer insert(int n, char[] cArray, int n2, int n3) {
        if (0 <= n && n <= this.count) {
            if (n2 >= 0 && 0 <= n3 && n3 <= cArray.length - n2) {
                this.move(n3, n);
                System.arraycopy((Object)cArray, n2, (Object)this.value, n, n3);
                this.count += n3;
                return this;
            }
            throw new StringIndexOutOfBoundsException();
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public synchronized StringBuffer insert(int n, char c) {
        if (0 <= n && n <= this.count) {
            this.move(1, n);
            this.value[n] = c;
            ++this.count;
            return this;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public StringBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public StringBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public StringBuffer insert(int n, int n2) {
        return this.insert(n, Integer.toString(n2));
    }

    public StringBuffer insert(int n, long l) {
        return this.insert(n, Long.toString(l));
    }

    public StringBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public synchronized StringBuffer insert(int n, String string) {
        if (0 <= n && n <= this.count) {
            if (string == null) {
                string = String.valueOf(string);
            }
            int n2 = string.length();
            this.move(n2, n);
            string.getChars(0, n2, this.value, n);
            this.count += n2;
            return this;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public StringBuffer insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public int length() {
        return this.count;
    }

    private void move(int n, int n2) {
        int n3;
        if (this.value.length - this.count >= n) {
            if (!this.shared) {
                System.arraycopy((Object)this.value, n2, (Object)this.value, n2 + n, this.count - n2);
                return;
            }
            n3 = this.value.length;
        } else {
            int n4 = this.count + n;
            int n5 = (this.value.length << 1) + 2;
            n3 = n4 > n5 ? n4 : n5;
        }
        char[] cArray = new char[n3];
        System.arraycopy((Object)this.value, 0, (Object)cArray, 0, n2);
        System.arraycopy((Object)this.value, n2, (Object)cArray, n2 + n, this.count - n2);
        this.value = cArray;
        this.shared = false;
    }

    public synchronized StringBuffer replace(int n, int n2, String string) {
        if (n >= 0) {
            if (n2 > this.count) {
                n2 = this.count;
            }
            if (n2 > n) {
                int n3 = string.length();
                int n4 = n2 - n - n3;
                if (n4 > 0) {
                    if (!this.shared) {
                        System.arraycopy((Object)this.value, n2, (Object)this.value, n + n3, this.count - n2);
                    } else {
                        char[] cArray = new char[this.value.length];
                        System.arraycopy((Object)this.value, 0, (Object)cArray, 0, n);
                        System.arraycopy((Object)this.value, n2, (Object)cArray, n + n3, this.count - n2);
                        this.value = cArray;
                        this.shared = false;
                    }
                } else if (n4 < 0) {
                    this.move(-n4, n2);
                } else if (this.shared) {
                    this.value = (char[])this.value.clone();
                    this.shared = false;
                }
                string.getChars(0, n3, this.value, n);
                this.count -= n4;
                return this;
            }
            if (n == n2) {
                if (string == null) {
                    throw new NullPointerException();
                }
                return this.insert(n, string);
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized StringBuffer reverse() {
        if (this.count < 2) {
            return this;
        }
        if (!this.shared) {
            int n = this.count - 1;
            char c = this.value[0];
            char c2 = this.value[n];
            boolean bl = true;
            boolean bl2 = true;
            int n2 = 0;
            int n3 = this.count / 2;
            while (n2 < n3) {
                char c3 = this.value[n2 + 1];
                char c4 = this.value[n - 1];
                boolean bl3 = false;
                boolean bl4 = false;
                if (bl && c3 >= '\udc00' && c3 <= '\udfff' && c >= '\ud800' && c <= '\udbff') {
                    bl3 = true;
                    if (this.count < 3) {
                        return this;
                    }
                }
                if (bl2 && c4 >= '\ud800' && c4 <= '\udbff' && c2 >= '\udc00' && c2 <= '\udfff') {
                    bl4 = true;
                }
                bl = true;
                bl2 = true;
                if (bl3 == bl4) {
                    if (bl3) {
                        this.value[n] = c3;
                        this.value[n - 1] = c;
                        this.value[n2] = c4;
                        this.value[n2 + 1] = c2;
                        c = this.value[n2 + 2];
                        c2 = this.value[n - 2];
                        ++n2;
                        --n;
                    } else {
                        this.value[n] = c;
                        this.value[n2] = c2;
                        c = c3;
                        c2 = c4;
                    }
                } else if (bl3) {
                    this.value[n] = c3;
                    this.value[n2] = c2;
                    c2 = c4;
                    bl = false;
                } else {
                    this.value[n] = c;
                    this.value[n2] = c4;
                    c = c3;
                    bl2 = false;
                }
                ++n2;
                --n;
            }
            if (!((this.count & 1) != 1 || bl && bl2)) {
                this.value[n] = bl ? c2 : c;
            }
        } else {
            char[] cArray = new char[this.value.length];
            int n = this.count;
            for (int i = 0; i < this.count; ++i) {
                char c;
                char c5 = this.value[i];
                if (i + 1 < this.count && c5 >= '\ud800' && c5 <= '\udbff' && (c = this.value[i + 1]) >= '\udc00' && c <= '\udfff') {
                    cArray[--n] = c;
                    ++i;
                }
                cArray[--n] = c5;
            }
            this.value = cArray;
            this.shared = false;
        }
        return this;
    }

    public synchronized void setCharAt(int n, char c) {
        if (this.shared) {
            this.value = (char[])this.value.clone();
            this.shared = false;
        }
        if (0 > n || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.value[n] = c;
    }

    public synchronized void setLength(int n) {
        if (n > this.value.length) {
            this.ensureCapacityImpl(n);
        }
        if (this.count > n) {
            if (!this.shared) {
                try {
                    Arrays.fill(this.value, n, this.count, '\u0000');
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IndexOutOfBoundsException();
                }
            } else {
                char[] cArray = new char[this.value.length];
                if (n > 0) {
                    System.arraycopy((Object)this.value, 0, (Object)cArray, 0, n);
                }
                this.value = cArray;
                this.shared = false;
            }
        }
        this.count = n;
    }

    public synchronized String substring(int n) {
        if (0 <= n && n <= this.count) {
            this.shared = true;
            return new String(n, this.count - n, this.value);
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public synchronized String substring(int n, int n2) {
        if (0 <= n && n <= n2 && n2 <= this.count) {
            this.shared = true;
            return new String(n, n2 - n, this.value);
        }
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized String toString() {
        if (this.count >= 256 && this.count <= this.value.length >> 1) {
            return new String(this.value, 0, this.count);
        }
        this.shared = true;
        return new String(0, this.count, this.value);
    }

    char[] shareValue() {
        this.shared = true;
        return this.value;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.count > this.value.length) {
            throw new InvalidObjectException(Msg.getString("K0199"));
        }
        this.shared = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StringBuffer append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return this.append((String)null);
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            int n = stringBuffer.count;
            int n2 = this.count + n;
            if (n2 > this.value.length) {
                this.ensureCapacityImpl(n2);
            } else if (this.shared) {
                this.value = (char[])this.value.clone();
                this.shared = false;
            }
            System.arraycopy((Object)stringBuffer.value, 0, (Object)this.value, this.count, n);
            this.count = n2;
        }
        return this;
    }

    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public synchronized int indexOf(String string, int n) {
        int n2;
        if (n < 0) {
            n = 0;
        }
        if ((n2 = string.length()) > 0) {
            if (n2 + n > this.count) {
                return -1;
            }
            char c = string.charAt(0);
            while (true) {
                int n3;
                boolean bl = false;
                for (n3 = n; n3 < this.count; ++n3) {
                    if (this.value[n3] != c) continue;
                    bl = true;
                    break;
                }
                if (!bl || n2 + n3 > this.count) {
                    return -1;
                }
                int n4 = n3;
                int n5 = 0;
                while (++n5 < n2 && this.value[++n4] == string.charAt(n5)) {
                }
                if (n5 == n2) {
                    return n3;
                }
                n = n3 + 1;
            }
        }
        return n < this.count || n == 0 ? n : this.count;
    }

    public synchronized int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public synchronized int lastIndexOf(String string, int n) {
        int n2 = string.length();
        if (n2 <= this.count && n >= 0) {
            if (n2 > 0) {
                if (n > this.count - n2) {
                    n = this.count - n2;
                }
                char c = string.charAt(0);
                while (true) {
                    int n3;
                    boolean bl = false;
                    for (n3 = n; n3 >= 0; --n3) {
                        if (this.value[n3] != c) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        return -1;
                    }
                    int n4 = n3;
                    int n5 = 0;
                    while (++n5 < n2 && this.value[++n4] == string.charAt(n5)) {
                    }
                    if (n5 == n2) {
                        return n3;
                    }
                    n = n3 - 1;
                }
            }
            return n < this.count ? n : this.count;
        }
        return -1;
    }

    char[] getValue() {
        return this.value;
    }

    public StringBuffer(CharSequence charSequence) {
        int n = charSequence.length();
        if (n < 0) {
            n = 0;
        }
        this.value = new char[n + 16];
        if (charSequence instanceof String) {
            this.append((String)charSequence);
            return;
        }
        if (charSequence instanceof StringBuffer) {
            this.append((StringBuffer)charSequence);
            return;
        }
        this.count = n;
        for (int i = 0; i < n; ++i) {
            this.value[i] = charSequence.charAt(i);
        }
    }

    public synchronized StringBuffer append(CharSequence charSequence) {
        if (charSequence == null) {
            return this.append(String.valueOf(charSequence));
        }
        if (charSequence instanceof String) {
            return this.append((String)charSequence);
        }
        if (charSequence instanceof StringBuffer) {
            return this.append((StringBuffer)charSequence);
        }
        int n = this.count + charSequence.length();
        if (n > this.count) {
            if (n > this.value.length) {
                this.ensureCapacityImpl(n);
            } else if (this.shared) {
                this.value = (char[])this.value.clone();
                this.shared = false;
            }
            for (int i = 0; i < charSequence.length(); ++i) {
                this.value[this.count + i] = charSequence.charAt(i);
            }
            this.count = n;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StringBuffer append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            return this.append(String.valueOf(charSequence), n, n2);
        }
        if (charSequence instanceof String) {
            return this.append(((String)charSequence).substring(n, n2));
        }
        if (n >= 0 && n2 >= 0 && n <= n2 && n2 <= charSequence.length()) {
            if (charSequence instanceof StringBuffer) {
                CharSequence charSequence2 = charSequence;
                synchronized (charSequence2) {
                    return this.append(((StringBuffer)charSequence).value, n, n2 - n);
                }
            }
            int n3 = n2 - n;
            if (n3 > 0) {
                int n4 = this.count + n3;
                if (n4 > this.value.length) {
                    this.ensureCapacityImpl(n4);
                } else if (this.shared) {
                    this.value = (char[])this.value.clone();
                    this.shared = false;
                }
                for (int i = 0; i < n3; ++i) {
                    this.value[this.count + i] = charSequence.charAt(n + i);
                }
                this.count = n4;
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StringBuffer insert(int n, CharSequence charSequence) {
        if (n >= 0 && n <= this.count) {
            if (charSequence == null) {
                return this.insert(n, String.valueOf(charSequence));
            }
            if (charSequence instanceof String) {
                return this.insert(n, (String)charSequence);
            }
            if (charSequence instanceof StringBuffer) {
                CharSequence charSequence2 = charSequence;
                synchronized (charSequence2) {
                    return this.insert(n, ((StringBuffer)charSequence).value, 0, ((StringBuffer)charSequence).count);
                }
            }
            int n2 = charSequence.length();
            if (n2 > 0) {
                this.move(n2, n);
                for (int i = 0; i < charSequence.length(); ++i) {
                    this.value[n + i] = charSequence.charAt(i);
                }
                this.count += n2;
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StringBuffer insert(int n, CharSequence charSequence, int n2, int n3) {
        if (n >= 0 && n <= this.count) {
            if (charSequence == null) {
                return this.insert(n, String.valueOf(charSequence), n2, n3);
            }
            if (charSequence instanceof String) {
                return this.insert(n, ((String)charSequence).substring(n2, n3));
            }
            if (n2 >= 0 && n3 >= 0 && n2 <= n3 && n3 <= charSequence.length()) {
                if (charSequence instanceof StringBuffer) {
                    CharSequence charSequence2 = charSequence;
                    synchronized (charSequence2) {
                        return this.insert(n, ((StringBuffer)charSequence).value, n2, n3 - n2);
                    }
                }
                int n4 = n3 - n2;
                if (n4 > 0) {
                    this.move(n4, n);
                    for (int i = 0; i < n4; ++i) {
                        this.value[n + i] = charSequence.charAt(n2 + i);
                    }
                    this.count += n4;
                }
                return this;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public synchronized void trimToSize() {
        if (!this.shared && this.value.length != this.count) {
            char[] cArray = new char[this.count];
            System.arraycopy((Object)this.value, 0, (Object)cArray, 0, this.count);
            this.value = cArray;
        }
    }

    public synchronized int codePointAt(int n) {
        if (n >= 0 && n < this.count) {
            char c;
            char c2 = this.value[n];
            if (n + 1 < this.count && c2 >= '\ud800' && c2 <= '\udbff' && (c = this.value[n + 1]) >= '\udc00' && c <= '\udfff') {
                return 65536 + (c2 - 55296 << 10) + (c - 56320);
            }
            return c2;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public synchronized int codePointBefore(int n) {
        if (n > 0 && n <= this.count) {
            char c;
            char c2 = this.value[n - 1];
            if (n > 1 && c2 >= '\udc00' && c2 <= '\udfff' && (c = this.value[n - 2]) >= '\ud800' && c <= '\udbff') {
                return 65536 + (c - 55296 << 10) + (c2 - 56320);
            }
            return c2;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public synchronized int codePointCount(int n, int n2) {
        if (n >= 0 && n <= n2 && n2 <= this.count) {
            int n3 = 0;
            for (int i = n; i < n2; ++i) {
                char c;
                char c2 = this.value[i];
                if (i + 1 < n2 && c2 >= '\ud800' && c2 <= '\udbff' && (c = this.value[i + 1]) >= '\udc00' && c <= '\udfff') {
                    ++i;
                }
                ++n3;
            }
            return n3;
        }
        throw new IndexOutOfBoundsException();
    }

    public synchronized int offsetByCodePoints(int n, int n2) {
        if (n >= 0 && n <= this.count) {
            int n3 = n;
            if (n2 == 0) {
                return n;
            }
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    char c;
                    if (n3 == this.count) {
                        throw new IndexOutOfBoundsException();
                    }
                    char c2 = this.value[n3];
                    if (n3 + 1 < this.count && c2 >= '\ud800' && c2 <= '\udbff' && (c = this.value[n3 + 1]) >= '\udc00' && c <= '\udfff') {
                        ++n3;
                    }
                    ++n3;
                }
            } else {
                for (int i = n2; i < 0; ++i) {
                    char c;
                    if (n3 < 1) {
                        throw new IndexOutOfBoundsException();
                    }
                    char c3 = this.value[n3 - 1];
                    if (n3 > 1 && c3 >= '\udc00' && c3 <= '\udfff' && (c = this.value[n3 - 2]) >= '\ud800' && c <= '\udbff') {
                        --n3;
                    }
                    --n3;
                }
            }
            return n3;
        }
        throw new IndexOutOfBoundsException();
    }

    public synchronized StringBuffer appendCodePoint(int n) {
        if (n < 0 || n >= 0x110000) {
            throw new IllegalArgumentException();
        }
        if (n < 65536) {
            this.append((char)n);
        } else {
            if (this.count + 2 > this.value.length) {
                this.ensureCapacityImpl(this.count + 2);
            }
            if (this.shared) {
                this.value = (char[])this.value.clone();
                this.shared = false;
            }
            this.value[this.count] = (char)(55296 + ((n -= 65536) >> 10));
            this.value[this.count + 1] = (char)(56320 + (n & 0x3FF));
            this.count += 2;
        }
        return this;
    }
}

