/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class String
implements Serializable,
Comparable<String>,
CharSequence {
    private static final long serialVersionUID = -6849794470754667710L;
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();
    private static final char[] ascii = new char[128];
    private final char[] value;
    private final int offset;
    private final int count;
    private int hashCode;
    private static char[] startCombiningAbove;
    private static char[] endCombiningAbove;
    private static final char[] upperValues;
    private static final ObjectStreamField[] serialPersistentFields;

    public String() {
        this.value = new char[0];
        this.offset = 0;
        this.count = 0;
    }

    private String(String string, char c) {
        this.offset = 0;
        this.value = new char[string.count + 1];
        this.count = string.count + 1;
        System.arraycopy((Object)string.value, string.offset, (Object)this.value, 0, string.count);
        this.value[string.count] = c;
    }

    public String(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    @Deprecated
    public String(byte[] byArray, int n) {
        this(byArray, n, 0, byArray.length);
    }

    public String(byte[] byArray, int n, int n2) {
        if (n < 0 || 0 > n2 || n2 > byArray.length - n) {
            throw new StringIndexOutOfBoundsException();
        }
        this.offset = 0;
        this.value = StringCoding.decode((byte[])byArray, (int)n, (int)n2);
        this.count = this.value.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public String(byte[] byArray, int n, int n2, int n3) {
        if (byArray == null) throw new NullPointerException();
        if (n2 < 0 || 0 > n3 || n3 > byArray.length - n2) throw new StringIndexOutOfBoundsException();
        this.offset = 0;
        this.value = new char[n3];
        this.count = n3;
        n <<= 8;
        for (int i = 0; i < this.count; ++i) {
            this.value[i] = (char)(n + (byArray[n2++] & 0xFF));
        }
    }

    public String(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (n < 0 || 0 > n2 || n2 > byArray.length - n) {
            throw new StringIndexOutOfBoundsException();
        }
        this.offset = 0;
        this.value = StringCoding.decode((String)string, (byte[])byArray, (int)n, (int)n2);
        this.count = this.value.length;
    }

    public String(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(byArray, 0, byArray.length, string);
    }

    public String(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public String(char[] cArray, int n, int n2) {
        if (n >= 0 && 0 <= n2 && n2 <= cArray.length - n) {
            this.offset = 0;
            this.value = new char[n2];
            this.count = n2;
            try {
                System.arraycopy((Object)cArray, n, (Object)this.value, 0, this.count);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new StringIndexOutOfBoundsException();
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    String(int n, int n2, char[] cArray) {
        this.value = cArray;
        this.offset = n;
        this.count = n2;
    }

    public String(String string) {
        this.value = string.value;
        this.offset = string.offset;
        this.count = string.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String(StringBuffer stringBuffer) {
        this.offset = 0;
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            this.value = stringBuffer.shareValue();
            this.count = stringBuffer.length();
        }
    }

    private String(String string, String string2) {
        if (string == null) {
            string = "null";
        }
        if (string2 == null) {
            string2 = "null";
        }
        int n = string.count + string2.count;
        this.value = new char[n];
        this.offset = 0;
        System.arraycopy((Object)string.value, string.offset, (Object)this.value, 0, string.count);
        System.arraycopy((Object)string2.value, string2.offset, (Object)this.value, string.count, string2.count);
        this.count = n;
    }

    private String(String string, String string2, String string3) {
        if (string == null) {
            string = "null";
        }
        if (string2 == null) {
            string2 = "null";
        }
        if (string3 == null) {
            string3 = "null";
        }
        int n = string.count + string2.count + string3.count;
        this.value = new char[n];
        this.offset = 0;
        System.arraycopy((Object)string.value, string.offset, (Object)this.value, 0, string.count);
        System.arraycopy((Object)string2.value, string2.offset, (Object)this.value, string.count, string2.count);
        System.arraycopy((Object)string3.value, string3.offset, (Object)this.value, string.count + string2.count, string3.count);
        this.count = n;
    }

    private String(String string, int n) {
        int n2;
        int n3;
        if (string == null) {
            string = "null";
        }
        int n4 = 1;
        int n5 = n;
        while ((n5 /= 10) != 0) {
            ++n4;
        }
        if (n >= 0) {
            n3 = -n;
        } else {
            ++n4;
            n3 = n;
        }
        int n6 = string.count + n4;
        this.value = new char[n6];
        int n7 = n6 - 1;
        do {
            n2 = n3 / 10;
            int n8 = n3 - n2 * 10;
            this.value[n7] = (char)(48 - n8);
            --n7;
        } while ((n3 = n2) != 0);
        if (n < 0) {
            this.value[n7] = 45;
        }
        this.offset = 0;
        System.arraycopy((Object)string.value, string.offset, (Object)this.value, 0, string.count);
        this.count = n6;
    }

    @Override
    public char charAt(int n) {
        if (0 <= n && n < this.count) {
            return this.value[this.offset + n];
        }
        throw new StringIndexOutOfBoundsException();
    }

    @Override
    public int compareTo(String string) {
        int n = this.offset;
        int n2 = string.offset;
        int n3 = this.offset + (this.count < string.count ? this.count : string.count);
        char[] cArray = string.value;
        while (n < n3) {
            int n4;
            if ((n4 = this.value[n++] - cArray[n2++]) == 0) continue;
            return n4;
        }
        return this.count - string.count;
    }

    public int compareToIgnoreCase(String string) {
        int n = this.offset;
        int n2 = string.offset;
        int n3 = this.offset + (this.count < string.count ? this.count : string.count);
        char[] cArray = string.value;
        while (n < n3) {
            int n4;
            char c;
            char c2;
            if ((c2 = this.value[n++]) == (c = cArray[n2++]) || (n4 = (c2 = Character.toLowerCase(Character.toUpperCase(c2))) - (c = Character.toLowerCase(Character.toUpperCase(c)))) == 0) continue;
            return n4;
        }
        return this.count - string.count;
    }

    public String concat(String string) {
        if (string.count > 0) {
            char[] cArray = new char[this.count + string.count];
            if (this.count > 0) {
                System.arraycopy((Object)this.value, this.offset, (Object)cArray, 0, this.count);
            }
            System.arraycopy((Object)string.value, string.offset, (Object)cArray, this.count, string.count);
            return new String(0, cArray.length, cArray);
        }
        return this;
    }

    public static String copyValueOf(char[] cArray) {
        return new String(cArray, 0, cArray.length);
    }

    public static String copyValueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public boolean endsWith(String string) {
        return this.regionMatches(this.count - string.count, string, 0, string.count);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (this.count != string.count || this.hashCode != string.hashCode && this.hashCode != 0 && string.hashCode != 0) {
                return false;
            }
            return this.regionMatches(0, string, 0, this.count);
        }
        return false;
    }

    public boolean equalsIgnoreCase(String string) {
        if (string == this) {
            return true;
        }
        if (string == null || this.count != string.count) {
            return false;
        }
        int n = this.offset;
        int n2 = string.offset;
        int n3 = this.offset + this.count;
        char[] cArray = string.value;
        while (n < n3) {
            char c;
            char c2;
            if ((c2 = this.value[n++]) == (c = cArray[n2++]) || Character.toUpperCase(c2) == Character.toUpperCase(c) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public byte[] getBytes() {
        return StringCoding.encode((char[])this.value, (int)this.offset, (int)this.count);
    }

    @Deprecated
    public void getBytes(int n, int n2, byte[] byArray, int n3) {
        if (0 <= n && n <= n2 && n2 <= this.count) {
            n2 += this.offset;
            try {
                for (int i = this.offset + n; i < n2; ++i) {
                    byArray[n3++] = (byte)this.value[i];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new StringIndexOutOfBoundsException();
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        return StringCoding.encode((String)string, (char[])this.value, (int)this.offset, (int)this.count);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (0 > n || n > n2 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy((Object)this.value, n + this.offset, (Object)cArray, n3, n2 - n);
    }

    void getChars(char[] cArray, int n) {
        System.arraycopy((Object)this.value, this.offset, (Object)cArray, n, this.count);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 0;
            int n2 = 1;
            for (int i = this.offset + this.count - 1; i >= this.offset; --i) {
                n += this.value[i] * n2;
                int n3 = n2 << 5;
                n2 = n3 - n2;
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        block4: {
            block5: {
                if (n2 >= this.count) break block4;
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n < 0 || n > 65535) break block5;
                for (int i = this.offset + n2; i < this.offset + this.count; ++i) {
                    if (this.value[i] != n) continue;
                    return i - this.offset;
                }
                break block4;
            }
            if (n > 0x10FFFF) break block4;
            for (int i = n2; i < this.count; ++i) {
                int n3 = this.codePointAt(i);
                if (n3 == n) {
                    return i;
                }
                if (n3 < 65536) continue;
                ++i;
            }
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        int n2;
        if (n < 0) {
            n = 0;
        }
        if ((n2 = string.count) > 0) {
            if (n2 + n > this.count) {
                return -1;
            }
            char[] cArray = string.value;
            int n3 = string.offset;
            char c = cArray[n3];
            int n4 = n3 + n2;
            while (true) {
                int n5;
                if ((n5 = this.indexOf(c, n)) == -1 || n2 + n5 > this.count) {
                    return -1;
                }
                int n6 = this.offset + n5;
                int n7 = n3;
                while (++n7 < n4 && this.value[++n6] == cArray[n7]) {
                }
                if (n7 == n4) {
                    return n5;
                }
                n = n5 + 1;
            }
        }
        return n < this.count ? n : this.count;
    }

    public native String intern();

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.count - 1);
    }

    public int lastIndexOf(int n, int n2) {
        block4: {
            block5: {
                if (n2 < 0) break block4;
                if (n2 >= this.count) {
                    n2 = this.count - 1;
                }
                if (n < 0 || n > 65535) break block5;
                for (int i = this.offset + n2; i >= this.offset; --i) {
                    if (this.value[i] != n) continue;
                    return i - this.offset;
                }
                break block4;
            }
            if (n > 0x10FFFF) break block4;
            for (int i = n2; i >= 0; --i) {
                int n3 = this.codePointAt(i);
                if (n3 == n) {
                    return i;
                }
                if (n3 < 65536) continue;
                --i;
            }
        }
        return -1;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String string, int n) {
        int n2 = string.count;
        if (n2 <= this.count && n >= 0) {
            if (n2 > 0) {
                if (n > this.count - n2) {
                    n = this.count - n2;
                }
                char[] cArray = string.value;
                int n3 = string.offset;
                char c = cArray[n3];
                int n4 = n3 + n2;
                while (true) {
                    int n5;
                    if ((n5 = this.lastIndexOf(c, n)) == -1) {
                        return -1;
                    }
                    int n6 = this.offset + n5;
                    int n7 = n3;
                    while (++n7 < n4 && this.value[++n6] == cArray[n7]) {
                    }
                    if (n7 == n4) {
                        return n5;
                    }
                    n = n5 - 1;
                }
            }
            return n < this.count ? n : this.count;
        }
        return -1;
    }

    @Override
    public int length() {
        return this.count;
    }

    public boolean regionMatches(int n, String string, int n2, int n3) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || string.count - n2 < n3) {
            return false;
        }
        if (n < 0 || this.count - n < n3) {
            return false;
        }
        if (n3 <= 0) {
            return true;
        }
        int n4 = this.offset + n;
        int n5 = string.offset + n2;
        for (int i = 0; i < n3; ++i) {
            if (this.value[n4 + i] == string.value[n5 + i]) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(boolean bl, int n, String string, int n2, int n3) {
        if (!bl) {
            return this.regionMatches(n, string, n2, n3);
        }
        if (string != null) {
            if (n < 0 || n3 > this.count - n) {
                return false;
            }
            if (n2 < 0 || n3 > string.count - n2) {
                return false;
            }
            n2 += string.offset;
            int n4 = (n += this.offset) + n3;
            char[] cArray = string.value;
            while (n < n4) {
                char c;
                char c2;
                if ((c2 = this.value[n++]) == (c = cArray[n2++]) || Character.toUpperCase(c2) == Character.toUpperCase(c) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
                return false;
            }
            return true;
        }
        throw new NullPointerException();
    }

    public String replace(char c, char c2) {
        int n = this.indexOf(c, 0);
        if (n == -1) {
            return this;
        }
        char[] cArray = new char[this.count];
        System.arraycopy((Object)this.value, this.offset, (Object)cArray, 0, this.count);
        do {
            cArray[n++] = c2;
        } while ((n = this.indexOf(c, n)) != -1);
        return new String(0, this.count, cArray);
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, 0);
    }

    public boolean startsWith(String string, int n) {
        return this.regionMatches(n, string, 0, string.count);
    }

    public String substring(int n) {
        if (n == 0) {
            return this;
        }
        if (0 <= n && n <= this.count) {
            return new String(this.offset + n, this.count - n, this.value);
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public String substring(int n, int n2) {
        if (n == 0 && n2 == this.count) {
            return this;
        }
        if (0 <= n && n <= n2 && n2 <= this.count) {
            return new String(this.offset + n, n2 - n, this.value);
        }
        throw new StringIndexOutOfBoundsException();
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.count];
        System.arraycopy((Object)this.value, this.offset, (Object)cArray, 0, this.count);
        return cArray;
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public String toLowerCase(Locale locale) {
        String string = locale.getLanguage();
        for (int i = 0; i < this.count; ++i) {
            int n = this.codePointAt(i);
            if (n != Character.toLowerCase(n)) {
                StringBuilder stringBuilder = new StringBuilder(this.count);
                stringBuilder.append(this.substring(0, i));
                if (!("tr".equals(string) || "az".equals(string) || "lt".equals(string))) {
                    while (i < this.count) {
                        n = this.codePointAt(i);
                        if (n == 931) {
                            stringBuilder.append(this.convertSigma(i));
                        } else {
                            stringBuilder.appendCodePoint(Character.toLowerCase(n));
                        }
                        if (n >= 65536) {
                            ++i;
                        }
                        ++i;
                    }
                } else if ("lt".equals(string)) {
                    while (i < this.count) {
                        n = this.codePointAt(i);
                        if (n == 931) {
                            stringBuilder.append(this.convertSigma(i));
                        } else if (n == 73 || n == 74 || n == 302) {
                            int n2;
                            stringBuilder.append(n == 302 ? (char)'\u012f' : (char)(n + 32));
                            if (i + 1 < this.count && String.isCombiningAbove(n2 = this.codePointAt(i + 1))) {
                                stringBuilder.append('\u0307');
                            }
                        } else if (n == 204) {
                            stringBuilder.append('i');
                            stringBuilder.append('\u0307');
                            stringBuilder.append('\u0300');
                        } else if (n == 205) {
                            stringBuilder.append('i');
                            stringBuilder.append('\u0307');
                            stringBuilder.append('\u0301');
                        } else if (n == 296) {
                            stringBuilder.append('i');
                            stringBuilder.append('\u0307');
                            stringBuilder.append('\u0303');
                        } else {
                            stringBuilder.appendCodePoint(Character.toLowerCase(n));
                        }
                        if (n >= 65536) {
                            ++i;
                        }
                        ++i;
                    }
                } else {
                    while (i < this.count) {
                        n = this.codePointAt(i);
                        if (n == 931) {
                            stringBuilder.append(this.convertSigma(i));
                        } else if (n == 73) {
                            boolean bl = i + 1 < this.count && this.charAt(i + 1) == '\u0307';
                            stringBuilder.append(bl ? (char)'i' : '\u0131');
                            if (bl) {
                                ++i;
                            }
                        } else {
                            stringBuilder.appendCodePoint(Character.toLowerCase(n));
                        }
                        if (n >= 65536) {
                            ++i;
                        }
                        ++i;
                    }
                }
                return stringBuilder.toString();
            }
            if (n < 65536) continue;
            ++i;
        }
        return this;
    }

    private static int binarySearchRange(char[] cArray, char c) {
        char c2 = '\u0000';
        int n = 0;
        int n2 = -1;
        int n3 = cArray.length - 1;
        while (n <= n3) {
            n2 = n + n3 >> 1;
            c2 = cArray[n2];
            if (c > c2) {
                n = n2 + 1;
                continue;
            }
            if (c == c2) {
                return n2;
            }
            n3 = n2 - 1;
        }
        return n2 - (c < c2 ? 1 : 0);
    }

    private static boolean isCombiningAbove(int n) {
        if (n < 65535) {
            int n2 = String.binarySearchRange(startCombiningAbove, (char)n);
            return n2 >= 0 && endCombiningAbove[n2] >= n;
        }
        return n >= 119173 && n <= 119177 || n >= 119210 && n <= 119213;
    }

    private boolean isWordPart(int n) {
        return n == 837 || this.isWordStart(n);
    }

    private boolean isWordStart(int n) {
        int n2 = Character.getType(n);
        return n2 >= 1 && n2 <= 3 || n >= 688 && n <= 696 || n >= 704 && n <= 705 || n >= 736 && n <= 740 || n == 890 || n >= 8544 && n <= 8575 || n >= 7468 && n <= 7521;
    }

    private char convertSigma(int n) {
        if (n == 0 || !this.isWordStart(this.codePointBefore(n)) || n + 1 < this.count && this.isWordPart(this.codePointAt(n + 1))) {
            return '\u03c3';
        }
        return '\u03c2';
    }

    @Override
    public String toString() {
        return this;
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    private int upperIndex(int n) {
        int n2 = -1;
        if (n >= 223 && n <= 64279) {
            if (n <= 1415) {
                if (n == 223) {
                    n2 = 0;
                } else if (n <= 329) {
                    if (n == 329) {
                        n2 = 1;
                    }
                } else if (n <= 496) {
                    if (n == 496) {
                        n2 = 2;
                    }
                } else if (n <= 912) {
                    if (n == 912) {
                        n2 = 3;
                    }
                } else if (n <= 944) {
                    if (n == 944) {
                        n2 = 4;
                    }
                } else if (n <= 1415 && n == 1415) {
                    n2 = 5;
                }
            } else if (n >= 7830) {
                if (n <= 7834) {
                    n2 = 6 + n - 7830;
                } else if (n >= 8016 && n <= 8188) {
                    n2 = "\u000b\u0000\f\u0000\r\u0000\u000e\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123456789:;<=>\u0000\u0000?@A\u0000BC\u0000\u0000\u0000\u0000D\u0000\u0000\u0000\u0000\u0000EFG\u0000HI\u0000\u0000\u0000\u0000J\u0000\u0000\u0000\u0000\u0000KL\u0000\u0000MN\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000OPQ\u0000RS\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000TUV\u0000WX\u0000\u0000\u0000\u0000Y".value[n - 8016];
                    if (n2 == 0) {
                        n2 = -1;
                    }
                } else if (n >= 64256) {
                    if (n <= 64262) {
                        n2 = 90 + n - 64256;
                    } else if (n >= 64275 && n <= 64279) {
                        n2 = 97 + n - 64275;
                    }
                }
            }
        }
        return n2;
    }

    public String toUpperCase(Locale locale) {
        String string = locale.getLanguage();
        boolean bl = "tr".equals(string) || "az".equals(string);
        boolean bl2 = "lt".equals(string);
        StringBuilder stringBuilder = null;
        boolean bl3 = false;
        for (int i = 0; i < this.count; ++i) {
            int n;
            int n2 = this.codePointAt(i);
            int n3 = this.upperIndex(n2);
            if (n3 == -1) {
                int n4 = !bl ? Character.toUpperCase(n2) : (n = n2 != 105 ? Character.toUpperCase(n2) : 304);
                if (n2 != n) {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(this.count);
                        stringBuilder.append(this.substring(0, i));
                    }
                    stringBuilder.appendCodePoint(n);
                } else if (stringBuilder != null) {
                    stringBuilder.appendCodePoint(n2);
                }
                if (bl2 && n2 <= 7883 && i + 1 < this.count && this.charAt(i + 1) == '\u0307' && "ij\u012f\u0268\u0456\u0458\u1e2d\u1ecb".indexOf((char)n2) != -1) {
                    ++i;
                }
            } else {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(this.count + this.count / 6 + 2);
                    stringBuilder.append(this.substring(0, i));
                }
                n = n3 * 3;
                char c = upperValues[n];
                stringBuilder.append(c);
                c = upperValues[n + 1];
                stringBuilder.append(c);
                c = upperValues[n + 2];
                if (c != '\u0000') {
                    stringBuilder.append(c);
                }
            }
            if (n2 < 65536) continue;
            ++i;
        }
        if (stringBuilder == null) {
            return this;
        }
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }

    public String trim() {
        int n;
        int n2;
        int n3 = n2 = this.offset + this.count - 1;
        for (n = this.offset; n <= n3 && this.value[n] <= ' '; ++n) {
        }
        while (n3 >= n && this.value[n3] <= ' ') {
            --n3;
        }
        if (n == this.offset && n3 == n2) {
            return this;
        }
        return new String(n, n3 - n + 1, this.value);
    }

    public static String valueOf(char[] cArray) {
        return new String(cArray, 0, cArray.length);
    }

    public static String valueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String valueOf(char c) {
        String string = c < '\u0080' ? new String(c, 1, ascii) : new String(0, 1, new char[]{c});
        string.hashCode = c;
        return string;
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(int n) {
        return Integer.toString(n);
    }

    public static String valueOf(long l) {
        return Long.toString(l);
    }

    public static String valueOf(Object object) {
        return object != null ? object.toString() : "null";
    }

    public static String valueOf(boolean bl) {
        return bl ? "true" : "false";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            int n = stringBuffer.length();
            if (this.count != n) {
                return false;
            }
            return this.regionMatches(0, new String(0, n, stringBuffer.getValue()), 0, n);
        }
    }

    public boolean matches(String string) {
        return Pattern.matches(string, this);
    }

    public String replaceAll(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceAll(string2);
    }

    public String replaceFirst(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceFirst(string2);
    }

    public String[] split(String string) {
        return Pattern.compile(string).split(this);
    }

    public String[] split(String string, int n) {
        return Pattern.compile(string).split(this, n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    private static int indexOf(String string, String string2, int n, int n2, char c) {
        char[] cArray = string.value;
        int n3 = string.offset;
        int n4 = string.count;
        char[] cArray2 = string2.value;
        int n5 = string2.offset;
        int n6 = string2.count;
        int n7 = n6 - 1;
        int n8 = n3 + n4;
        int n9 = n3 + n7;
        block0: while (n9 < n8) {
            if (c == cArray[n9]) {
                for (int i = 0; i < n7; ++i) {
                    if (cArray2[i + n5] == cArray[n9 + i - n7]) continue;
                    int n10 = 1;
                    if ((n & '\u0001' << cArray[n9]) == 0) {
                        n10 += i;
                    }
                    n9 += Math.max(n2, n10);
                    continue block0;
                }
                return n9 - n7 - n3;
            }
            if ((n & '\u0001' << cArray[n9]) == 0) {
                n9 += n7;
            }
            ++n9;
        }
        return -1;
    }

    public String(int[] nArray, int n, int n2) {
        if (n >= 0 && 0 <= n2 && n2 <= nArray.length - n) {
            int n3;
            int n4;
            int n5 = 0;
            for (n4 = n; n4 < n + n2; ++n4) {
                n3 = nArray[n4];
                if (n3 < 0) {
                    throw new IllegalArgumentException();
                }
                if (n3 < 65536) {
                    ++n5;
                    continue;
                }
                if (n3 <= 0x10FFFF) {
                    n5 += 2;
                    continue;
                }
                throw new IllegalArgumentException();
            }
            this.offset = 0;
            this.value = new char[n5];
            this.count = n5;
            n4 = 0;
            for (n3 = n; n3 < n + n2; ++n3) {
                int n6 = nArray[n3];
                if (n6 < 65536) {
                    this.value[n4++] = (char)n6;
                    continue;
                }
                this.value[n4++] = (char)(55296 + ((n6 -= 65536) >> 10));
                this.value[n4++] = (char)(56320 + (n6 & 0x3FF));
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    public String(StringBuilder stringBuilder) {
        this.offset = 0;
        this.value = stringBuilder.shareValue();
        this.count = stringBuilder.length();
    }

    public int codePointAt(int n) {
        if (n >= 0 && n < this.count) {
            char c;
            char c2 = this.value[this.offset + n];
            if (n + 1 < this.count && c2 >= '\ud800' && c2 <= '\udbff' && (c = this.value[this.offset + n + 1]) >= '\udc00' && c <= '\udfff') {
                return 65536 + (c2 - 55296 << 10) + (c - 56320);
            }
            return c2;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public int codePointBefore(int n) {
        if (n > 0 && n <= this.count) {
            char c;
            char c2 = this.value[this.offset + n - 1];
            if (n > 1 && c2 >= '\udc00' && c2 <= '\udfff' && (c = this.value[this.offset + n - 2]) >= '\ud800' && c <= '\udbff') {
                return 65536 + (c - 55296 << 10) + (c2 - 56320);
            }
            return c2;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public int codePointCount(int n, int n2) {
        if (n >= 0 && n <= n2 && n2 <= this.count) {
            int n3 = 0;
            int n4 = this.offset + n2;
            for (int i = this.offset + n; i < n4; ++i) {
                char c;
                char c2 = this.value[i];
                if (i + 1 < n4 && c2 >= '\ud800' && c2 <= '\udbff' && (c = this.value[i + 1]) >= '\udc00' && c <= '\udfff') {
                    ++i;
                }
                ++n3;
            }
            return n3;
        }
        throw new IndexOutOfBoundsException();
    }

    public int offsetByCodePoints(int n, int n2) {
        if (n >= 0 && n <= this.count) {
            int n3 = n;
            if (n2 == 0) {
                return n;
            }
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    char c;
                    if (n3 == this.count) {
                        throw new IndexOutOfBoundsException();
                    }
                    char c2 = this.value[this.offset + n3];
                    if (n3 + 1 < this.count && c2 >= '\ud800' && c2 <= '\udbff' && (c = this.value[this.offset + n3 + 1]) >= '\udc00' && c <= '\udfff') {
                        ++n3;
                    }
                    ++n3;
                }
            } else {
                for (int i = n2; i < 0; ++i) {
                    char c;
                    if (n3 < 1) {
                        throw new IndexOutOfBoundsException();
                    }
                    char c3 = this.value[this.offset + n3 - 1];
                    if (n3 > 1 && c3 >= '\udc00' && c3 <= '\udfff' && (c = this.value[this.offset + n3 - 2]) >= '\ud800' && c <= '\udbff') {
                        --n3;
                    }
                    --n3;
                }
            }
            return n3;
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean contentEquals(CharSequence charSequence) {
        if (this.count != charSequence.length()) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.value[this.offset + i] == charSequence.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(CharSequence charSequence) {
        int n = charSequence.length();
        if (n > this.count) {
            return false;
        }
        int n2 = 0;
        if (n > 0) {
            if (n + n2 > this.count) {
                return false;
            }
            int n3 = 0;
            char c = charSequence.charAt(n3);
            while (true) {
                int n4;
                if ((n4 = this.indexOf(c, n2)) == -1 || n + n4 > this.count) {
                    return false;
                }
                int n5 = this.offset + n4;
                int n6 = n3;
                while (++n6 < n && this.value[++n5] == charSequence.charAt(n6)) {
                }
                if (n6 == n) {
                    return true;
                }
                n2 = n4 + 1;
            }
        }
        return true;
    }

    public String replace(CharSequence charSequence, CharSequence charSequence2) {
        int n;
        if (charSequence2 == null) {
            throw new NullPointerException();
        }
        int n2 = charSequence.length();
        if (n2 == 0) {
            StringBuilder stringBuilder = new StringBuilder((this.count + 1) * charSequence2.length());
            stringBuilder.append(charSequence2);
            for (int i = 0; i < this.count; ++i) {
                stringBuilder.append(this.charAt(i));
                stringBuilder.append(charSequence2);
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        char c = charSequence.charAt(0);
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.count && (n = this.indexOf(c, n3)) != -1) {
            boolean bl = true;
            if (charSequence.length() > 1) {
                if (n + n2 > this.count) break;
                for (int i = 1; i < n2; ++i) {
                    if (this.charAt(n + i) == charSequence.charAt(i)) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                stringBuilder.append(this.substring(n4, n));
                stringBuilder.append(charSequence2);
                n4 = n3 = n + n2;
                continue;
            }
            n3 = n + 1;
        }
        if (stringBuilder.length() == 0 && n4 == 0) {
            return this;
        }
        stringBuilder.append(this.substring(n4));
        return stringBuilder.toString();
    }

    public static String format(String string, Object ... objectArray) {
        Formatter formatter = new Formatter();
        formatter.format(string, objectArray);
        return formatter.toString();
    }

    public static String format(Locale locale, String string, Object ... objectArray) {
        Formatter formatter = new Formatter(locale);
        formatter.format(string, objectArray);
        return formatter.toString();
    }

    static {
        for (int i = 0; i < ascii.length; ++i) {
            String.ascii[i] = (char)i;
        }
        startCombiningAbove = "\u0300\u033d\u0346\u034a\u0350\u0357\u0363\u0483\u0592\u0597\u059c\u05a8\u05ab\u05af\u05c4\u0610\u0653\u0657\u06d6\u06df\u06e4\u06e7\u06eb\u0730\u0732\u0735\u073a\u073d\u073f\u0743\u0745\u0747\u0749\u0951\u0953\u0f82\u0f86\u17dd\u193a\u20d0\u20d4\u20db\u20e1\u20e7\u20e9\ufe20".value;
        endCombiningAbove = "\u0314\u0344\u0346\u034c\u0352\u0357\u036f\u0486\u0595\u0599\u05a1\u05a9\u05ac\u05af\u05c4\u0615\u0654\u0658\u06dc\u06e2\u06e4\u06e8\u06ec\u0730\u0733\u0736\u073a\u073d\u0741\u0743\u0745\u0747\u074a\u0951\u0954\u0f83\u0f87\u17dd\u193a\u20d1\u20d7\u20dc\u20e1\u20e7\u20e9\ufe23".value;
        upperValues = "SS\u0000\u02bcN\u0000J\u030c\u0000\u0399\u0308\u0301\u03a5\u0308\u0301\u0535\u0552\u0000H\u0331\u0000T\u0308\u0000W\u030a\u0000Y\u030a\u0000A\u02be\u0000\u03a5\u0313\u0000\u03a5\u0313\u0300\u03a5\u0313\u0301\u03a5\u0313\u0342\u1f08\u0399\u0000\u1f09\u0399\u0000\u1f0a\u0399\u0000\u1f0b\u0399\u0000\u1f0c\u0399\u0000\u1f0d\u0399\u0000\u1f0e\u0399\u0000\u1f0f\u0399\u0000\u1f08\u0399\u0000\u1f09\u0399\u0000\u1f0a\u0399\u0000\u1f0b\u0399\u0000\u1f0c\u0399\u0000\u1f0d\u0399\u0000\u1f0e\u0399\u0000\u1f0f\u0399\u0000\u1f28\u0399\u0000\u1f29\u0399\u0000\u1f2a\u0399\u0000\u1f2b\u0399\u0000\u1f2c\u0399\u0000\u1f2d\u0399\u0000\u1f2e\u0399\u0000\u1f2f\u0399\u0000\u1f28\u0399\u0000\u1f29\u0399\u0000\u1f2a\u0399\u0000\u1f2b\u0399\u0000\u1f2c\u0399\u0000\u1f2d\u0399\u0000\u1f2e\u0399\u0000\u1f2f\u0399\u0000\u1f68\u0399\u0000\u1f69\u0399\u0000\u1f6a\u0399\u0000\u1f6b\u0399\u0000\u1f6c\u0399\u0000\u1f6d\u0399\u0000\u1f6e\u0399\u0000\u1f6f\u0399\u0000\u1f68\u0399\u0000\u1f69\u0399\u0000\u1f6a\u0399\u0000\u1f6b\u0399\u0000\u1f6c\u0399\u0000\u1f6d\u0399\u0000\u1f6e\u0399\u0000\u1f6f\u0399\u0000\u1fba\u0399\u0000\u0391\u0399\u0000\u0386\u0399\u0000\u0391\u0342\u0000\u0391\u0342\u0399\u0391\u0399\u0000\u1fca\u0399\u0000\u0397\u0399\u0000\u0389\u0399\u0000\u0397\u0342\u0000\u0397\u0342\u0399\u0397\u0399\u0000\u0399\u0308\u0300\u0399\u0308\u0301\u0399\u0342\u0000\u0399\u0308\u0342\u03a5\u0308\u0300\u03a5\u0308\u0301\u03a1\u0313\u0000\u03a5\u0342\u0000\u03a5\u0308\u0342\u1ffa\u0399\u0000\u03a9\u0399\u0000\u038f\u0399\u0000\u03a9\u0342\u0000\u03a9\u0342\u0399\u03a9\u0399\u0000FF\u0000FI\u0000FL\u0000FFIFFLST\u0000ST\u0000\u0544\u0546\u0000\u0544\u0535\u0000\u0544\u053b\u0000\u054e\u0546\u0000\u0544\u053d\u0000".value;
        serialPersistentFields = new ObjectStreamField[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            return string.compareToIgnoreCase(string2);
        }
    }
}

