/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.AbstractClassLoader;
import com.ibm.oti.vm.BootstrapClassLoader;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import sun.misc.Launcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLoader {
    static ClassLoader systemClassLoader;
    private static ClassLoader applicationClassLoader;
    private static boolean initSystemClassLoader;
    private long vmRef;
    ClassLoader parent;
    private Object assertionLock = new Object();
    private boolean defaultAssertionStatus;
    private Map packageAssertionStatus;
    private Map classAssertionStatus;
    private Hashtable genericRepository;
    private Hashtable annotationCache;
    private Hashtable packages = new Hashtable();
    private Object lazyInitLock = new Object();
    private Hashtable classSigners = null;
    private Hashtable packageSigners = new Hashtable();
    private static Certificate[] emptyCertificates;
    private ProtectionDomain defaultProtectionDomain;
    private Hashtable contexts = new Hashtable();

    static final void initializeClassLoaders() {
        if (systemClassLoader != null) {
            return;
        }
        ClassLoader classLoader = null;
        String string = System.getProperty("systemClassLoader");
        if (null == string) {
            classLoader = BootstrapClassLoader.singleton();
        } else {
            try {
                classLoader = (ClassLoader)Class.forName(string, true, null).newInstance();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                System.exit(1);
            }
        }
        systemClassLoader = classLoader;
        AbstractClassLoader.setBootstrapClassLoader(systemClassLoader);
        applicationClassLoader = systemClassLoader;
        applicationClassLoader = Launcher.getLauncher().getClassLoader();
    }

    protected ClassLoader() {
        this(applicationClassLoader);
    }

    protected ClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.parent = classLoader;
        if (systemClassLoader != null) {
            VM.initializeClassLoader(this, false);
        }
        this.initializeClassLoaderAssertStatus();
    }

    @Deprecated
    protected final Class<?> defineClass(byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(null, byArray, n, n2);
    }

    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(string, byArray, n, n2, null);
    }

    private String checkClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            if (string.startsWith("java.")) {
                throw new SecurityException(Msg.getString("K01d2", string2, string));
            }
            return string2;
        }
        return "";
    }

    protected final Class<?> defineClass(final String string, final byte[] byArray, final int n, final int n2, ProtectionDomain protectionDomain) throws ClassFormatError {
        Object object;
        Object[] objectArray = null;
        if (protectionDomain != null && (object = protectionDomain.getCodeSource()) != null) {
            objectArray = ((CodeSource)object).getCertificates();
        }
        if (string != null) {
            object = this.checkClassName(string);
            this.checkPackageSigners((String)object, string, (Certificate[])objectArray);
        }
        if (protectionDomain == null) {
            protectionDomain = this.getDefaultProtectionDomain();
        }
        object = protectionDomain;
        AccessControlContext accessControlContext = null;
        if (string != null) {
            accessControlContext = (AccessControlContext)this.contexts.get(string);
        }
        Class clazz = accessControlContext == null ? this.defineClassImpl(string, byArray, n, n2, object) : (Class)AccessController.doPrivileged(new PrivilegedAction((ProtectionDomain)object){
            final /* synthetic */ ProtectionDomain val$pd;
            {
                this.val$pd = protectionDomain;
            }

            public Object run() {
                return ClassLoader.this.defineClassImpl(string, byArray, n, n2, this.val$pd);
            }
        }, accessControlContext);
        if (this.isVerboseImpl()) {
            URL uRL;
            CodeSource codeSource;
            String string2 = "<unknown>";
            if (object != null && (codeSource = ((ProtectionDomain)object).getCodeSource()) != null && (uRL = codeSource.getLocation()) != null) {
                string2 = uRL.toString();
            }
            VM.dumpString("class load: " + clazz.getName() + " from: " + string2 + "\n");
        }
        if (objectArray != null) {
            this.setSigners(clazz, objectArray);
        }
        return clazz;
    }

    private native boolean isVerboseImpl();

    private void checkPackageSigners(String string, String string2, Certificate[] certificateArray) {
        Certificate[] certificateArray2 = (Certificate[])this.packageSigners.get(string);
        if (certificateArray2 == null) {
            if (certificateArray == null) {
                this.packageSigners.put(string, emptyCertificates);
            } else {
                this.packageSigners.put(string, certificateArray);
            }
        } else {
            if (certificateArray == null && certificateArray2.length == 0 || certificateArray == certificateArray2) {
                return;
            }
            if (certificateArray != null && certificateArray.length == certificateArray2.length) {
                boolean bl = true;
                block0: for (int i = 0; i < certificateArray.length; ++i) {
                    if (certificateArray[i] == certificateArray2[i] || certificateArray[i].equals(certificateArray2[i])) continue;
                    for (int j = 0; j < certificateArray2.length; ++j) {
                        if (j != i && (certificateArray[i] == certificateArray2[j] || certificateArray[i].equals(certificateArray2[j]))) continue block0;
                    }
                    bl = false;
                    break;
                }
                if (bl) {
                    return;
                }
            }
            throw new SecurityException(Msg.getString("K01d1", string2));
        }
    }

    private final ProtectionDomain getDefaultProtectionDomain() {
        if (this.defaultProtectionDomain == null) {
            CodeSource codeSource = new CodeSource(null, (Certificate[])null);
            this.defaultProtectionDomain = new ProtectionDomain(codeSource, null, this, null);
        }
        return this.defaultProtectionDomain;
    }

    private final native Class defineClassImpl(String var1, byte[] var2, int var3, int var4, Object var5);

    protected Class<?> findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException();
    }

    protected final native Class<?> findLoadedClass(String var1);

    protected final Class<?> findSystemClass(String string) throws ClassNotFoundException {
        return applicationClassLoader.loadClass(string);
    }

    public final ClassLoader getParent() {
        ClassLoader classLoader;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.callerClassLoader()) != null && classLoader != this && !classLoader.isAncestorOf(this)) {
            securityManager.checkPermission(RuntimePermission.permissionToGetClassLoader);
        }
        return this.parent;
    }

    public URL getResource(String string) {
        URL uRL;
        URL uRL2 = uRL = this.parent == null ? systemClassLoader.findResource(string) : this.parent.getResource(string);
        if (uRL != null) {
            return uRL;
        }
        return this.findResource(string);
    }

    public Enumeration<URL> getResources(String string) throws IOException {
        ClassLoader classLoader = this;
        final Vector<Enumeration<URL>> vector = new Vector<Enumeration<URL>>();
        while (true) {
            Enumeration<URL> enumeration;
            if ((enumeration = classLoader.findResources(string)) != null && enumeration.hasMoreElements()) {
                vector.addElement(enumeration);
            }
            if (classLoader == systemClassLoader) break;
            classLoader = classLoader.parent;
            if (classLoader != null) continue;
            classLoader = systemClassLoader;
        }
        return new Enumeration<URL>(){
            int index;
            {
                this.index = vector.size() - 1;
            }

            @Override
            public boolean hasMoreElements() {
                while (this.index >= 0) {
                    if (((Enumeration)vector.elementAt(this.index)).hasMoreElements()) {
                        return true;
                    }
                    --this.index;
                }
                return false;
            }

            @Override
            public URL nextElement() {
                while (this.index >= 0) {
                    Enumeration enumeration = (Enumeration)vector.elementAt(this.index);
                    if (enumeration.hasMoreElements()) {
                        return (URL)enumeration.nextElement();
                    }
                    --this.index;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            if (uRL != null) {
                return uRL.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static void completeInitialization() {
        initSystemClassLoader = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getSystemClassLoader() {
        Object object;
        Object object2;
        if (initSystemClassLoader) {
            object = object2 = ClassLoader.class;
            synchronized (object) {
                if (initSystemClassLoader) {
                    initSystemClassLoader = false;
                    String string = System.getProperty("java.system.class.loader");
                    if (string != null) {
                        try {
                            Class<?> clazz = Class.forName(string, true, applicationClassLoader);
                            Constructor<?> constructor = clazz.getConstructor(new Class[]{object2});
                            applicationClassLoader = (ClassLoader)constructor.newInstance(applicationClassLoader);
                        }
                        catch (Throwable throwable) {
                            throw new Error(throwable);
                        }
                    }
                }
            }
        }
        if ((object2 = System.getSecurityManager()) != null && (object = ClassLoader.callerClassLoader()) != null && object != applicationClassLoader && !((ClassLoader)object).isAncestorOf(applicationClassLoader)) {
            ((SecurityManager)object2).checkPermission(RuntimePermission.permissionToGetClassLoader);
        }
        return applicationClassLoader;
    }

    public static URL getSystemResource(String string) {
        return ClassLoader.getSystemClassLoader().getResource(string);
    }

    public static Enumeration<URL> getSystemResources(String string) throws IOException {
        return ClassLoader.getSystemClassLoader().getResources(string);
    }

    public static InputStream getSystemResourceAsStream(String string) {
        return ClassLoader.getSystemClassLoader().getResourceAsStream(string);
    }

    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.parent == null ? systemClassLoader.loadClass(string) : this.parent.loadClass(string, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    this.contexts.put(string, AccessController.getContext());
                    try {
                        clazz = this.findClass(string);
                    }
                    finally {
                        this.contexts.remove(string);
                    }
                } else {
                    clazz = this.findClass(string);
                }
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected final void resolveClass(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        J9VMInternals.verify(clazz);
    }

    private void setParent(ClassLoader classLoader) {
        this.parent = classLoader;
    }

    final boolean isSystemClassLoader() {
        if (this == systemClassLoader) {
            return true;
        }
        ClassLoader classLoader = applicationClassLoader;
        while (classLoader != null) {
            if (this == classLoader) {
                return true;
            }
            classLoader = classLoader.parent;
        }
        return false;
    }

    final boolean isAncestorOf(ClassLoader classLoader) {
        if (classLoader == null) {
            return false;
        }
        if (this == systemClassLoader) {
            return true;
        }
        ClassLoader classLoader2 = classLoader.parent;
        while (classLoader2 != null) {
            if (this == classLoader2) {
                return true;
            }
            classLoader2 = classLoader2.parent;
        }
        return false;
    }

    protected URL findResource(String string) {
        return null;
    }

    protected Enumeration<URL> findResources(String string) throws IOException {
        return new Vector().elements();
    }

    protected String findLibrary(String string) {
        return null;
    }

    protected Package getPackage(String string) {
        if (this != systemClassLoader) {
            Package package_;
            ClassLoader classLoader = this.parent;
            if (classLoader == null) {
                classLoader = systemClassLoader;
            }
            if ((package_ = classLoader.getPackage(string)) != null) {
                return package_;
            }
        }
        return (Package)this.packages.get(string);
    }

    protected Package[] getPackages() {
        Package[] packageArray = null;
        if (this.parent == null) {
            if (this != systemClassLoader) {
                packageArray = systemClassLoader.getPackages();
            }
        } else {
            packageArray = this.parent.getPackages();
        }
        int n = this.packages.size();
        if (packageArray != null) {
            n += packageArray.length;
        }
        Package[] packageArray2 = new Package[n];
        Enumeration enumeration = this.packages.elements();
        if (packageArray != null) {
            for (int i = 0; i < packageArray.length; ++i) {
                packageArray2[i] = packageArray[i];
            }
        }
        while (enumeration.hasMoreElements()) {
            packageArray2[i++] = (Package)enumeration.nextElement();
        }
        return packageArray2;
    }

    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        Hashtable hashtable = this.packages;
        synchronized (hashtable) {
            if (this.getPackage(string) == null) {
                Package package_ = new Package(string, string2, string3, string4, string5, string6, string7, uRL, this);
                this.packages.put(string, package_);
                return package_;
            }
            throw new IllegalArgumentException(Msg.getString("K0053", string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object[] getSigners(Class clazz) {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.classSigners == null) {
                return null;
            }
        }
        try {
            object = this.classSigners.get(clazz);
            if (object != null) {
                return (Object[])object.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSigners(Class<?> clazz, Object[] objectArray) {
        if (clazz.getClassLoaderImpl() == this) {
            if (objectArray == null) {
                Object object = this.lazyInitLock;
                synchronized (object) {
                    if (this.classSigners == null) {
                        return;
                    }
                }
                this.classSigners.remove(clazz);
            } else {
                Object object = this.lazyInitLock;
                synchronized (object) {
                    if (this.classSigners == null) {
                        this.classSigners = new Hashtable();
                    }
                }
                this.classSigners.put(clazz, objectArray);
            }
        } else {
            clazz.getClassLoaderImpl().setSigners(clazz, objectArray);
        }
    }

    static ClassLoader getCallerClassLoader() {
        ClassLoader classLoader = ClassLoader.getStackClassLoader(2);
        if (classLoader == systemClassLoader) {
            return null;
        }
        return classLoader;
    }

    static final native ClassLoader getStackClassLoader(int var0);

    static ClassLoader callerClassLoader() {
        ClassLoader classLoader = ClassLoader.getStackClassLoader(2);
        if (classLoader == systemClassLoader) {
            return null;
        }
        return classLoader;
    }

    static synchronized void loadLibraryWithClassLoader(String string, ClassLoader classLoader) {
        String string2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        if (classLoader != null && (string2 = classLoader.findLibrary(string)) != null) {
            ClassLoader.loadLibraryWithPath(string2, classLoader, null);
            return;
        }
        ClassLoader.loadLibraryWithPath(string, classLoader, System.internalGetProperties().getProperty(classLoader == null ? "com.ibm.oti.vm.bootstrap.library.path" : "java.library.path"));
    }

    static void loadLibraryWithPath(String string, ClassLoader classLoader, String string2) {
        byte[] byArray = ClassLoader.loadLibraryWithPath(Util.getBytes(string), classLoader, string2 == null ? null : Util.getBytes(string2));
        if (byArray != null) {
            String string3;
            try {
                string3 = Util.convertFromUTF8(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                string3 = Util.toString(byArray);
            }
            throw new UnsatisfiedLinkError(string + " (" + string3 + ")");
        }
    }

    private static native byte[] loadLibraryWithPath(byte[] var0, ClassLoader var1, byte[] var2);

    static void loadLibrary(Class clazz, String string, boolean bl) {
        if (bl) {
            ClassLoader.loadLibraryWithPath(string, clazz.getClassLoaderImpl(), null);
        } else {
            ClassLoader.loadLibraryWithClassLoader(string, clazz.getClassLoaderImpl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassAssertionStatus(String string, boolean bl) {
        Object object = this.assertionLock;
        synchronized (object) {
            if (this.classAssertionStatus == null) {
                this.classAssertionStatus = new HashMap();
            }
            this.classAssertionStatus.put(string, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackageAssertionStatus(String string, boolean bl) {
        Object object = this.assertionLock;
        synchronized (object) {
            if (this.packageAssertionStatus == null) {
                this.packageAssertionStatus = new HashMap();
            }
            this.packageAssertionStatus.put(string, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultAssertionStatus(boolean bl) {
        Object object = this.assertionLock;
        synchronized (object) {
            this.defaultAssertionStatus = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAssertionStatus() {
        Object object = this.assertionLock;
        synchronized (object) {
            this.defaultAssertionStatus = false;
            this.classAssertionStatus = null;
            this.packageAssertionStatus = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getClassAssertionStatus(String string) {
        Object object = this.assertionLock;
        synchronized (object) {
            int n = -1;
            if (this.classAssertionStatus != null) {
                Boolean bl = (Boolean)this.classAssertionStatus.get(string);
                if (bl != null) {
                    return bl;
                }
                n = string.indexOf(36);
                if (n > 0 && (bl = (Boolean)this.classAssertionStatus.get(string.substring(0, n))) != null) {
                    return bl;
                }
            }
            if ((n = string.lastIndexOf(46)) > 0) {
                return this.getPackageAssertionStatus(string.substring(0, n));
            }
            return this.getDefaultAssertionStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getPackageAssertionStatus(String string) {
        Object object = this.assertionLock;
        synchronized (object) {
            int n = -1;
            if (this.packageAssertionStatus != null) {
                Boolean bl = (Boolean)this.packageAssertionStatus.get(string);
                if (bl != null) {
                    return bl;
                }
                n = string.lastIndexOf(46);
                if (n > 0) {
                    return this.getPackageAssertionStatus(string.substring(0, n));
                }
            }
            return this.getDefaultAssertionStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getDefaultAssertionStatus() {
        Object object = this.assertionLock;
        synchronized (object) {
            return this.defaultAssertionStatus;
        }
    }

    private void initializeClassLoaderAssertStatus() {
        boolean bl = systemClassLoader == null;
        String[] stringArray = VM.getVMArgs();
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            boolean bl2;
            int n = stringArray[i].indexOf(58);
            if (n == -1) {
                stringArray2[i] = stringArray[i];
            } else {
                stringArray2[i] = stringArray[i].substring(0, n);
                stringArray3[i] = stringArray[i].substring(n + 1);
            }
            if (stringArray2[i].compareTo("-ea") == 0 || stringArray2[i].compareTo("-enableassertions") == 0 || stringArray2[i].compareTo("-da") == 0 || stringArray2[i].compareTo("-disableassertions") == 0) {
                bl2 = stringArray2[i].charAt(1) == 'e';
                if (stringArray3[i] == null) {
                    if (bl) continue;
                    this.setDefaultAssertionStatus(bl2);
                    continue;
                }
                String string = stringArray3[i];
                int n2 = string.length();
                if (n2 > 3 && string.charAt(n2 - 1) == '.' && string.charAt(n2 - 2) == '.' && string.charAt(n2 - 3) == '.') {
                    string = string.substring(0, n2 - 3);
                    this.setPackageAssertionStatus(string, bl2);
                    continue;
                }
                this.setClassAssertionStatus(string, bl2);
                continue;
            }
            if (stringArray2[i].compareTo("-esa") != 0 && stringArray2[i].compareTo("-enablesystemassertions") != 0 && stringArray2[i].compareTo("-dsa") != 0 && stringArray2[i].compareTo("-disablesystemassertions") != 0 || !bl) continue;
            bl2 = stringArray2[i].charAt(1) == 'e';
            this.setDefaultAssertionStatus(bl2);
        }
    }

    protected final Class<?> defineClass(String string, ByteBuffer byteBuffer, ProtectionDomain protectionDomain) throws ClassFormatError {
        if (byteBuffer.hasArray()) {
            return this.defineClass(string, byteBuffer.array(), byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), protectionDomain);
        }
        int n = byteBuffer.limit() - byteBuffer.position();
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return this.defineClass(string, byArray, 0, byArray.length, protectionDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hashtable getGenericRepository() {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.genericRepository == null) {
                this.genericRepository = new Hashtable();
            }
        }
        return this.genericRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hashtable getAnnotationCache() {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.annotationCache == null) {
                this.annotationCache = new Hashtable();
            }
        }
        return this.annotationCache;
    }

    static {
        initSystemClassLoader = false;
        emptyCertificates = new Certificate[0];
    }
}

