/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.TracePoint;
import com.ibm.jvm.format.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Vector;

public class TraceRecord50
implements Comparable {
    private BigInteger timeStamp;
    private BigInteger wrapTime;
    private BigInteger writePlatform = BigInteger.ZERO;
    private BigInteger writeSystem = BigInteger.ZERO;
    private long threadID = 0L;
    private long threadSyn1 = 0L;
    private long threadSyn2 = 0L;
    private int firstEntry;
    private int nextEntry;
    private String threadName;
    private BigInteger upperTimeWord = BigInteger.ZERO;
    private String threadIDString = null;
    private String fromFileName = null;
    private int offsetInFile = -1;
    private int bufferLength = -1;
    private int traceRecordType = -1;
    private long lostTracePointsOnThisRecord = 0L;
    private Vector tps = new Vector();
    private int dataStart;
    private int dataEnd;
    private int dataLength;
    private byte[] extraData = null;
    private byte[] overspillData = null;
    private BigInteger overspillUpperWord = null;
    private boolean primed = false;
    private byte[] rawTraceRecord;
    private TraceFile traceFile;
    private int offset;
    private int tplength;
    private TracePoint sp;
    private boolean coalescedInternalBuffer = false;
    private int absolutePositionInFile;
    private byte[] tpdata;
    private byte[] dataAtEndOfBuffer;
    private boolean isMiddleOfTracePoint = false;

    public int processTraceBufferHeader(TraceFile traceFile, int n, int n2) throws IOException {
        this.fromFileName = traceFile.toString();
        this.offsetInFile = n;
        this.bufferLength = n2;
        this.traceFile = traceFile;
        traceFile.seek(n);
        this.timeStamp = traceFile.readBigInteger(8);
        this.wrapTime = traceFile.readBigInteger(8);
        this.writePlatform = traceFile.readBigInteger(8);
        this.writeSystem = traceFile.readBigInteger(8);
        this.threadID = traceFile.readL();
        this.threadSyn1 = traceFile.readL();
        this.threadSyn2 = traceFile.readL();
        this.firstEntry = traceFile.readI();
        this.nextEntry = traceFile.readI();
        this.threadName = traceFile.readString(this.firstEntry - 64);
        this.upperTimeWord = this.timeStamp.shiftRight(32);
        this.threadIDString = Long.toString(this.threadID, 16);
        this.dataStart = this.firstEntry;
        this.dataEnd = this.nextEntry;
        if (this.dataEnd < 0) {
            this.isMiddleOfTracePoint = true;
            this.dataLength = n2 - this.dataStart;
            Util.Debug.println("Found a middle section - dataLength == " + this.dataLength);
        } else {
            this.dataLength = this.dataEnd - this.dataStart;
        }
        Util.Debug.println("Buffer is at offset " + n + " in " + traceFile);
        Util.Debug.println("  First TracePoint in buffer is at offset " + this.firstEntry);
        Util.Debug.println("  Last TracePoint in buffer is at offset  " + this.nextEntry);
        Util.Debug.println("  timeStamp:    " + this.timeStamp);
        Util.Debug.println("  wrapTime:     " + this.wrapTime);
        Util.Debug.println("  writePlatform " + this.writePlatform);
        Util.Debug.println("  writeSystem   " + this.writeSystem);
        if (this.writePlatform.compareTo(TraceFormat.lastWritePlatform) > 0) {
            Util.Debug.println("updating lastWritePlatform" + this.writePlatform);
            Util.Debug.println("updating lastWriteSystem  " + this.writeSystem);
            TraceFormat.lastWritePlatform = this.writePlatform;
            TraceFormat.lastWriteSystem = this.writeSystem;
        }
        if (this.wrapTime.compareTo(TraceFormat.first) < 0) {
            TraceFormat.first = this.wrapTime;
        }
        if (this.timeStamp.compareTo(TraceFormat.last) > 0) {
            TraceFormat.last = this.timeStamp;
        }
        return 1;
    }

    public TracePoint getNextTracePoint() {
        TracePoint tracePoint = null;
        if (!this.primed) {
            try {
                this.primeRecord(this.traceFile);
                this.primed = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            tracePoint = (TracePoint)this.tps.elementAt(0);
            this.tps.removeElementAt(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Util.Debug.println("Reached end of buffer ");
            Util.Debug.println(arrayIndexOutOfBoundsException);
            tracePoint = null;
        }
        return tracePoint;
    }

    public boolean addOverspillData(byte[] byArray, BigInteger bigInteger) {
        this.overspillData = byArray;
        return true;
    }

    public boolean isMiddleOfTracePoint() {
        if (!this.primed) {
            try {
                this.primeRecord(this.traceFile);
                this.primed = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.isMiddleOfTracePoint;
    }

    public byte[] getExtraData() {
        if (this.isMiddleOfTracePoint) {
            if (!this.primed) {
                try {
                    this.primeRecord(this.traceFile);
                    this.primed = true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return null;
                }
            }
            if (this.rawTraceRecord != null) {
                Util.Debug.println("returning " + this.rawTraceRecord.length + " bytes of middle");
            } else {
                Util.Debug.println("returning some null stuff for the middle");
            }
            return this.rawTraceRecord;
        }
        return this.dataAtEndOfBuffer;
    }

    public boolean primeRecord(TraceFile traceFile) throws IOException {
        Long l;
        traceFile.seek((long)this.dataStart + (long)this.offsetInFile);
        this.absolutePositionInFile = this.offsetInFile + this.dataStart;
        this.rawTraceRecord = new byte[this.dataLength + 1];
        int n = traceFile.read(this.rawTraceRecord);
        if (n != this.dataLength + 1) {
            System.err.println("*** Incorrect data length read, expecting " + (this.dataLength + 1) + " found " + n + " skipping this TraceBuffer");
            return false;
        }
        if (this.dataEnd < 0) {
            Util.Debug.println("this is the middle - dataLength == " + this.dataLength);
            Util.Debug.println("dataStart " + this.dataStart + " dataEnd " + this.dataEnd + " bufferLength " + this.bufferLength);
            return true;
        }
        int n2 = this.bufferLength - this.dataEnd;
        if (n2 > 0) {
            this.dataAtEndOfBuffer = new byte[n2];
            traceFile.seek((long)this.dataEnd + (long)this.offsetInFile);
            n = traceFile.read(this.dataAtEndOfBuffer);
            if (n != n2) {
                TraceFormat.outStream.println("*** Can't read the last " + n2 + "bytes from a trace record. Record begins at file offset " + this.offsetInFile + " data to be read should start at " + this.dataEnd);
                TraceFormat.outStream.println("  * will continue processing the remainder of the buffer");
            } else {
                Util.Debug.println("Read some excess data from end of buffer at offset " + (this.dataEnd + this.offsetInFile) + " in " + traceFile);
            }
        }
        if (!Util.findThreadID(l = new Long(this.threadID))) {
            Util.putThreadID(l);
        }
        this.offset = this.rawTraceRecord.length - 1;
        this.tplength = 1;
        this.tpdata = new byte[this.bufferLength];
        this.sp = new TracePoint();
        while (this.tplength > 0 && this.offset > 0) {
            int n3;
            Util.Debug.println("parsing TracePoint at absolute file offset " + (this.offset + this.dataStart + this.offsetInFile));
            this.tplength = Util.constructUnsignedByte(this.rawTraceRecord, this.offset);
            Util.Debug.println("next tracepoint is " + this.tplength + " bytes long");
            if (this.sp.isLongTracePoint()) {
                n3 = this.sp.longTracePointLength();
                Util.Debug.println("Processing long tracepoint - length = " + n3);
                this.tplength = n3;
            }
            if (this.tplength > this.offset) {
                byte[] byArray;
                byte[] byArray2;
                if (this.coalescedInternalBuffer) break;
                n3 = this.tplength - this.offset;
                if (this.traceRecordType == 0) {
                    if (this.dataAtEndOfBuffer != null) {
                        byArray2 = this.dataAtEndOfBuffer;
                        byArray = new byte[byArray2.length + this.offset + 1];
                        System.arraycopy((Object)byArray2, 0, (Object)byArray, 0, byArray2.length);
                        System.arraycopy((Object)this.rawTraceRecord, 0, (Object)byArray, byArray2.length, this.offset + 1);
                        Util.Debug.println(" coalesced the buffers successfully! ");
                        this.coalescedInternalBuffer = true;
                        this.rawTraceRecord = byArray;
                        this.offset = byArray.length - 1;
                        continue;
                    }
                    Util.Debug.println(" TraceRecord50 wrapped an internal buffer which doesn't seem to have any extra data at the end");
                    break;
                }
                if (this.overspillData != null) {
                    byArray2 = this.overspillData;
                    byArray = new byte[byArray2.length + this.offset + 1];
                    System.arraycopy((Object)byArray2, 0, (Object)byArray, 0, byArray2.length);
                    System.arraycopy((Object)this.rawTraceRecord, 0, (Object)byArray, byArray2.length, this.offset + 1);
                    Util.Debug.println(" coalesced the buffers successfully! ");
                    this.coalescedInternalBuffer = true;
                    this.rawTraceRecord = byArray;
                    this.offset = byArray.length - 1;
                    continue;
                }
                Util.Debug.println(" TraceRecord50 walked back off the beginning of this buffer, but found no overspill data");
                break;
            }
            this.offset -= this.tplength;
            this.absolutePositionInFile -= this.tplength;
            if (this.tpdata.length < this.tplength) {
                this.tpdata = new byte[this.tplength + 1];
            }
            System.arraycopy((Object)this.rawTraceRecord, this.offset, (Object)this.tpdata, 0, this.tplength);
            this.sp = new TracePoint(this.tpdata, this.tplength, this.upperTimeWord, this.threadID, traceFile.toString(), this.absolutePositionInFile);
            if (this.sp.isTimerUpperWord()) {
                this.upperTimeWord = BigInteger.valueOf(this.sp.getNewTimerUpperWord());
            }
            if (!this.sp.isNormalTracepoint()) continue;
            this.tps.add(this.sp);
        }
        if (this.offset == 0) {
            Util.Debug.println("TraceRecord ended (i.e. started!) on a complete tracepoint");
        } else {
            Util.Debug.println("TraceRecored ended with some extra data");
        }
        this.coalescedInternalBuffer = false;
        this.absolutePositionInFile += this.offset;
        Util.Debug.println("About to sort");
        Collections.sort(this.tps);
        Util.Debug.println("      sorted");
        if (!this.isMiddleOfTracePoint) {
            this.rawTraceRecord = null;
        }
        return true;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getThreadIDAsLong() {
        return this.threadID;
    }

    public String getFileName() {
        return this.fromFileName;
    }

    public int getOffsetInFile() {
        return this.offsetInFile;
    }

    public BigInteger getTimeStamp() {
        return this.timeStamp;
    }

    public BigInteger getLastTimerWrap() {
        return this.wrapTime;
    }

    public void setTimeStamp(BigInteger bigInteger) {
        this.timeStamp = bigInteger;
    }

    public int compareTo(Object object) {
        if (this.timeStamp == null) {
            TraceFormat.outStream.println("compareTo called on a TraceRecord50 which has a null timestamp");
            return 0;
        }
        if (((TraceRecord50)object).getTimeStamp() == null) {
            TraceFormat.outStream.println("compareTo called with a TraceRecord50 which has a null timestamp");
            return 0;
        }
        return this.timeStamp.compareTo(((TraceRecord50)object).getTimeStamp());
    }

    public int getTraceType() {
        return this.traceRecordType;
    }

    public void setTraceType(int n) {
        this.traceRecordType = n;
    }

    public BigInteger getLastUpperWord() {
        return this.upperTimeWord;
    }
}

