/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.persistence.aspects;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;

public abstract class AbstractLoggingAspect {
    abstract Logger getLogger();

    abstract boolean getShownLoggerException();

    abstract void setShownLoggerException(boolean var1);

    void handleLoggerException(Throwable t) {
        if (!this.getShownLoggerException()) {
            this.setShownLoggerException(true);
            System.err.println("AbstractLoggingAspect: Caught Throwable: " + t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    void logEntry(JoinPoint tjp) {
        Signature sig = tjp.getStaticPart().getSignature();
        if (tjp.getArgs() != null) {
            try {
                this.getLogger().entering(sig.getDeclaringTypeName(), sig.getName(), tjp.getArgs());
            }
            catch (Throwable throwable) {
                this.getLogger().entering(sig.getDeclaringTypeName(), sig.getName(), "EXCEPTION");
            }
        } else {
            this.getLogger().entering(sig.getDeclaringTypeName(), sig.getName());
        }
    }

    void logExit(JoinPoint tjp, Object o) {
        Signature sig = tjp.getStaticPart().getSignature();
        if (o != null) {
            try {
                this.getLogger().exiting(sig.getDeclaringTypeName(), sig.getName(), o);
            }
            catch (Throwable throwable) {
                this.getLogger().exiting(sig.getDeclaringTypeName(), sig.getName(), "EXCEPTION");
            }
        } else {
            this.getLogger().exiting(sig.getDeclaringTypeName(), sig.getName());
        }
    }

    void logException(JoinPoint tjp, Exception e) {
        Signature sig = tjp.getStaticPart().getSignature();
        try {
            this.getLogger().throwing(sig.getDeclaringTypeName(), sig.getName(), e);
        }
        catch (Throwable throwable) {
            this.getLogger().throwing(sig.getDeclaringTypeName(), sig.getName(), new Exception("EXCEPTION"));
        }
    }

    public void ajc$before$com_ibm_websphere_persistence_aspects_AbstractLoggingAspect$1$91473c9d(JoinPoint thisJoinPoint) {
        try {
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.logEntry(thisJoinPoint);
            }
        }
        catch (Throwable t) {
            this.handleLoggerException(t);
        }
    }

    public void ajc$before$com_ibm_websphere_persistence_aspects_AbstractLoggingAspect$2$3fcb93d0(JoinPoint thisJoinPoint) {
        try {
            if (this.getLogger().isLoggable(Level.FINEST)) {
                this.logEntry(thisJoinPoint);
            }
        }
        catch (Throwable t) {
            this.handleLoggerException(t);
        }
    }

    public void ajc$afterReturning$com_ibm_websphere_persistence_aspects_AbstractLoggingAspect$3$91473c9d(Object o, JoinPoint thisJoinPoint) {
        try {
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.logExit(thisJoinPoint, o);
            }
        }
        catch (Throwable t) {
            this.handleLoggerException(t);
        }
    }

    public void ajc$afterReturning$com_ibm_websphere_persistence_aspects_AbstractLoggingAspect$4$3fcb93d0(Object o, JoinPoint thisJoinPoint) {
        try {
            if (this.getLogger().isLoggable(Level.FINEST)) {
                this.logExit(thisJoinPoint, o);
            }
        }
        catch (Throwable t) {
            this.handleLoggerException(t);
        }
    }

    public void ajc$afterThrowing$com_ibm_websphere_persistence_aspects_AbstractLoggingAspect$5$91473c9d(Exception e, JoinPoint thisJoinPoint) {
        try {
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.logException(thisJoinPoint, e);
            }
        }
        catch (Throwable t) {
            this.handleLoggerException(t);
        }
    }

    public void ajc$afterThrowing$com_ibm_websphere_persistence_aspects_AbstractLoggingAspect$6$3fcb93d0(Exception e, JoinPoint thisJoinPoint) {
        try {
            if (this.getLogger().isLoggable(Level.FINEST)) {
                this.logException(thisJoinPoint, e);
            }
        }
        catch (Throwable t) {
            this.handleLoggerException(t);
        }
    }
}

