/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import sun.tools.jconsole.inspector.XMBeanAttributes;

public class TableSorter
extends DefaultTableModel
implements MouseListener {
    private boolean ascending = true;
    private TableColumnModel columnModel;
    private JTable tableView;
    private Vector<TableModelListener> listenerList = new Vector();
    private int sortColumn = 0;
    private int[] invertedIndex;

    public TableSorter() {
    }

    public TableSorter(Object[] objectArray, int n) {
        super(objectArray, n);
    }

    public void newDataAvailable(TableModelEvent tableModelEvent) {
        super.newDataAvailable(tableModelEvent);
        this.invertedIndex = new int[this.getRowCount()];
        for (int i = 0; i < this.invertedIndex.length; ++i) {
            this.invertedIndex[i] = i;
        }
        this.sort(this.sortColumn);
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.add(tableModelListener);
        super.addTableModelListener(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.remove(tableModelListener);
        super.removeTableModelListener(tableModelListener);
    }

    private void removeListeners() {
        for (TableModelListener tableModelListener : this.listenerList) {
            super.removeTableModelListener(tableModelListener);
        }
    }

    private void restoreListeners() {
        for (TableModelListener tableModelListener : this.listenerList) {
            super.addTableModelListener(tableModelListener);
        }
    }

    public int compare(Object object, Object object2) {
        if (object == null) {
            return 1;
        }
        if (object2 == null) {
            return -1;
        }
        if (object.getClass().equals(object2.getClass()) && object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        return object.toString().compareTo(object2.toString());
    }

    public void sort(int n) {
        this.removeListeners();
        this.quickSort(0, this.getRowCount() - 1, n);
        this.restoreListeners();
        this.sortColumn = n;
    }

    private synchronized boolean compareS(Object object, Object object2) {
        if (this.ascending) {
            return this.compare(object, object2) > 0;
        }
        return this.compare(object, object2) < 0;
    }

    private synchronized boolean compareG(Object object, Object object2) {
        if (this.ascending) {
            return this.compare(object, object2) < 0;
        }
        return this.compare(object, object2) > 0;
    }

    private synchronized void quickSort(int n, int n2, int n3) {
        int n4 = n;
        int n5 = n2;
        if (n2 > n) {
            Object object = this.getValueAt((n + n2) / 2, n3);
            while (n4 <= n5) {
                while (n4 < n2 && this.compareS(object, this.getValueAt(n4, n3))) {
                    ++n4;
                }
                while (n5 > n && this.compareG(object, this.getValueAt(n5, n3))) {
                    --n5;
                }
                if (n4 > n5) continue;
                this.swap(n4, n5, n3);
                ++n4;
                --n5;
            }
            if (n < n5) {
                this.quickSort(n, n5, n3);
            }
            if (n4 <= n2) {
                this.quickSort(n4, n2, n3);
            }
        }
    }

    public void n2sort(int n) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                if (this.compare(this.getValueAt(i, n), this.getValueAt(j, n)) != -1) continue;
                this.swap(i, j, n);
            }
        }
    }

    private Vector getRow(int n) {
        return (Vector)this.dataVector.elementAt(n);
    }

    private void setRow(Vector vector, int n) {
        this.dataVector.setElementAt(vector, n);
        if (this.tableView instanceof XMBeanAttributes) {
            ((XMBeanAttributes)this.tableView).updateRowHeight(vector.elementAt(1), n);
        }
    }

    public void swap(int n, int n2, int n3) {
        Vector vector = this.getRow(n);
        this.setRow(this.getRow(n2), n);
        this.setRow(vector, n2);
        int n4 = this.invertedIndex[n];
        this.invertedIndex[n] = this.invertedIndex[n2];
        this.invertedIndex[n2] = n4;
    }

    public void sortByColumn(int n) {
        this.sortByColumn(n, !this.ascending);
    }

    public void sortByColumn(int n, boolean bl) {
        this.ascending = bl;
        this.sort(n);
    }

    public int[] getInvertedIndex() {
        return this.invertedIndex;
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        this.tableView = jTable;
        this.columnModel = this.tableView.getColumnModel();
        JTableHeader jTableHeader = this.tableView.getTableHeader();
        jTableHeader.addMouseListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.columnModel.getColumnIndexAtX(mouseEvent.getX());
        int n2 = this.tableView.convertColumnIndexToModel(n);
        if (mouseEvent.getClickCount() == 1 && n2 != -1) {
            this.tableView.invalidate();
            this.sortByColumn(n2);
            this.tableView.validate();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

