/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XOperations;
import sun.tools.jconsole.inspector.XTextField;

public class OperationEntry
extends JPanel {
    private MBeanOperationInfo operation;
    private JComboBox sigs;
    private Dimension preferredSize;
    private XTextField[] inputs;

    public OperationEntry(MBeanOperationInfo mBeanOperationInfo, boolean bl, JButton jButton, XOperations xOperations) {
        super(new BorderLayout());
        this.operation = mBeanOperationInfo;
        this.setLayout(new FlowLayout(0));
        this.setPanel(bl, jButton, xOperations);
    }

    private String preProcessSignature(String string) {
        int n = string.indexOf(" throws");
        if (n > 0) {
            string = string.substring(0, n);
        }
        while ((n = string.indexOf("java.lang.")) > 0) {
            string = string.substring(0, n) + string.substring(n + 10, string.length());
        }
        return string;
    }

    private void setPanel(boolean bl, JButton jButton, XOperations xOperations) {
        try {
            MBeanParameterInfo[] mBeanParameterInfoArray = this.operation.getSignature();
            this.add(new JLabel("(", 0));
            this.inputs = new XTextField[mBeanParameterInfoArray.length];
            for (int i = 0; i < mBeanParameterInfoArray.length; ++i) {
                int n;
                Object object;
                if (mBeanParameterInfoArray[i].getName() != null) {
                    object = new JLabel(mBeanParameterInfoArray[i].getName(), 0);
                    ((JComponent)object).setToolTipText(mBeanParameterInfoArray[i].getDescription());
                    this.add((Component)object);
                }
                if ((n = ((String)(object = Utils.getDefaultValue(mBeanParameterInfoArray[i].getType()))).length()) > 15) {
                    n = 15;
                } else if (n < 10) {
                    n = 10;
                }
                this.inputs[i] = new XTextField(object, Utils.getClass(mBeanParameterInfoArray[i].getType()), n, bl, jButton, xOperations);
                this.add(this.inputs[i]);
                this.inputs[i].setHorizontalAlignment(0);
                if (mBeanParameterInfoArray[i].getName() != null) {
                    this.inputs[i].textField.getAccessibleContext().setAccessibleName(mBeanParameterInfoArray[i].getName());
                }
                if (i >= mBeanParameterInfoArray.length - 1) continue;
                this.add(new JLabel(",", 0));
            }
            this.add(new JLabel(")", 0));
            this.validate();
            this.doLayout();
        }
        catch (Exception exception) {
            System.out.println("Error setting Operation panel :" + exception.getMessage());
        }
    }

    public String[] getSignature() {
        MBeanParameterInfo[] mBeanParameterInfoArray = this.operation.getSignature();
        String[] stringArray = new String[mBeanParameterInfoArray.length];
        for (int i = 0; i < mBeanParameterInfoArray.length; ++i) {
            stringArray[i] = mBeanParameterInfoArray[i].getType();
        }
        return stringArray;
    }

    public Object[] getParameters() throws Exception {
        MBeanParameterInfo[] mBeanParameterInfoArray = this.operation.getSignature();
        String[] stringArray = new String[mBeanParameterInfoArray.length];
        for (int i = 0; i < mBeanParameterInfoArray.length; ++i) {
            stringArray[i] = mBeanParameterInfoArray[i].getType();
        }
        return Utils.getParameters(this.inputs, stringArray);
    }

    public String getReturnType() {
        return this.operation.getReturnType();
    }
}

