/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.ibm.lang.management.OperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import sun.tools.jconsole.MemoryPoolProxy;
import sun.tools.jconsole.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyClient {
    private static Map<String, ProxyClient> cache = Collections.synchronizedMap(new HashMap());
    private boolean isDead = false;
    private String hostName;
    private int port;
    private int vmid;
    private String userName;
    private String password;
    private MBeanServerConnection server;
    private JMXConnector jmxc;
    private String url;
    private ClassLoadingMXBean classLoadingMBean;
    private CompilationMXBean compilationMBean;
    private MemoryMXBean memoryMBean;
    private java.lang.management.OperatingSystemMXBean operatingSystemMBean;
    private RuntimeMXBean runtimeMBean;
    private ThreadMXBean threadMBean;
    private OperatingSystemMXBean IBMOperatingSystemMXBean;
    private static final String CREDENTIALS = "jmx.remote.credentials";
    private List<MemoryPoolProxy> memoryPoolProxies;
    private List<GarbageCollectorMXBean> garbageCollectorMBeans;
    String verboseException = System.getProperty("com.ibm.jconsole.verbose");

    public static ProxyClient getProxyClient(int n, String string) throws IOException {
        String string2 = Integer.toString(n);
        ProxyClient proxyClient = cache.get(string2);
        if (proxyClient == null) {
            proxyClient = new ProxyClient(n, string);
            cache.put(string2, proxyClient);
        }
        return proxyClient;
    }

    public static ProxyClient getProxyClient(String string, int n) throws IOException {
        return ProxyClient.getProxyClient(string, n, "", "");
    }

    public static ProxyClient getProxyClient(JMXServiceURL jMXServiceURL, Map map) throws IOException {
        ProxyClient proxyClient = cache.get(jMXServiceURL.toString());
        if (proxyClient == null) {
            proxyClient = new ProxyClient(jMXServiceURL, map);
            cache.put(jMXServiceURL.toString(), proxyClient);
        }
        return proxyClient;
    }

    public static ProxyClient getProxyClient(String string, int n, String string2, String string3) throws IOException {
        String string4 = string + ":" + n + ":" + string2 + ":" + string3;
        ProxyClient proxyClient = cache.get(string4);
        if (proxyClient == null) {
            proxyClient = new ProxyClient(string, n, string2, string3);
            cache.put(string4, proxyClient);
        }
        return proxyClient;
    }

    public ProxyClient(JMXServiceURL jMXServiceURL, Map map) throws IOException {
        this.url = jMXServiceURL.toString();
        this.vmid = -1;
        this.hostName = jMXServiceURL.getHost();
        this.port = jMXServiceURL.getPort();
        this.jmxc = JMXConnectorFactory.connect(jMXServiceURL, map);
        this.server = this.jmxc.getMBeanServerConnection();
    }

    public String getConnectionName() {
        String string = this.vmid >= 0 ? Integer.toString(this.vmid) + "@localhost" : (this.url != null && (this.hostName == null || this.hostName.length() == 0 || this.port == 0) ? this.url : this.hostName + ":" + this.port);
        if (this.userName != null && this.userName.length() > 0) {
            string = Resources.getText("ConnectionName", this.userName, string);
        }
        if (this.isDead()) {
            string = Resources.getText("ConnectionName (disconnected)", this.userName, string);
        }
        return string;
    }

    public String toString() {
        return this.getConnectionName();
    }

    public ProxyClient(int n, String string) throws IOException {
        this.hostName = "localhost";
        this.port = 0;
        this.vmid = n;
        this.userName = "";
        this.password = "";
        JMXServiceURL jMXServiceURL = new JMXServiceURL(string);
        this.jmxc = JMXConnectorFactory.connect(jMXServiceURL);
        this.server = this.jmxc.getMBeanServerConnection();
    }

    public ProxyClient(String string, int n, String string2, String string3) throws IOException {
        this.hostName = string;
        this.port = n;
        this.vmid = -1;
        this.userName = string2;
        this.password = string3;
        String string4 = "/jndi/rmi://" + string + ":" + n + "/jmxrmi";
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        String[] stringArray = new String[]{string2, string3};
        hashMap.put(CREDENTIALS, stringArray);
        try {
            if (string.equals("localhost") && n == 0) {
                this.server = ManagementFactory.getPlatformMBeanServer();
            } else {
                JMXServiceURL jMXServiceURL = new JMXServiceURL("rmi", "", 0, string4);
                this.jmxc = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
                this.server = this.jmxc.getMBeanServerConnection();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new InternalError("Should not reach here");
        }
        this.getRuntimeMXBean();
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.server;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public int getVmid() {
        return this.vmid;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void disconnect() {
        if (this.jmxc != null) {
            try {
                this.jmxc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String[] getDomains() throws IOException {
        return this.server.getDomains();
    }

    public Map<ObjectName, MBeanInfo> getMBeans(String string) throws IOException {
        ObjectName objectName;
        block8: {
            objectName = null;
            if (string != null) {
                try {
                    objectName = new ObjectName(string + ":*");
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
        }
        Set<ObjectName> set = this.server.queryNames(objectName, null);
        HashMap<ObjectName, MBeanInfo> hashMap = new HashMap<ObjectName, MBeanInfo>(set.size());
        for (ObjectName objectName2 : set) {
            if (!(objectName2 instanceof ObjectName)) continue;
            ObjectName objectName3 = objectName2;
            try {
                MBeanInfo mBeanInfo = this.server.getMBeanInfo(objectName3);
                hashMap.put(objectName3, mBeanInfo);
            }
            catch (IntrospectionException introspectionException) {
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (ReflectionException reflectionException) {}
        }
        return hashMap;
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws IOException {
        AttributeList attributeList = null;
        try {
            attributeList = this.server.getAttributes(objectName, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
        return attributeList;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InvalidAttributeValueException, MBeanException, IOException {
        try {
            this.server.setAttribute(objectName, attribute);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            assert (false);
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws IOException, MBeanException {
        Object object = null;
        try {
            object = this.server.invoke(objectName, string, objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
        return object;
    }

    public ClassLoadingMXBean getClassLoadingMXBean() throws IOException {
        if (this.classLoadingMBean == null) {
            this.classLoadingMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=ClassLoading", ClassLoadingMXBean.class);
        }
        return this.classLoadingMBean;
    }

    public CompilationMXBean getCompilationMXBean() throws IOException {
        if (this.compilationMBean == null) {
            this.compilationMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Compilation", CompilationMXBean.class);
        }
        return this.compilationMBean;
    }

    public Collection<MemoryPoolProxy> getMemoryPoolProxies() throws IOException {
        if (this.memoryPoolProxies == null) {
            ObjectName objectName;
            block5: {
                objectName = null;
                try {
                    objectName = new ObjectName("java.lang:type=MemoryPool,*");
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            Set<ObjectName> set = this.server.queryNames(objectName, null);
            if (set != null) {
                this.memoryPoolProxies = new ArrayList<MemoryPoolProxy>();
                for (ObjectName objectName2 : set) {
                    MemoryPoolProxy memoryPoolProxy = new MemoryPoolProxy(this, objectName2);
                    this.memoryPoolProxies.add(memoryPoolProxy);
                }
            }
        }
        return this.memoryPoolProxies;
    }

    public Collection<GarbageCollectorMXBean> getGarbageCollectorMXBeans() throws IOException {
        if (this.garbageCollectorMBeans == null) {
            ObjectName objectName;
            block5: {
                objectName = null;
                try {
                    objectName = new ObjectName("java.lang:type=GarbageCollector,*");
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            Set<ObjectName> set = this.server.queryNames(objectName, null);
            if (set != null) {
                this.garbageCollectorMBeans = new ArrayList<GarbageCollectorMXBean>();
                for (ObjectName objectName2 : set) {
                    String string = "java.lang:type=GarbageCollector,name=" + objectName2.getKeyProperty("name");
                    GarbageCollectorMXBean garbageCollectorMXBean = ManagementFactory.newPlatformMXBeanProxy(this.server, string, GarbageCollectorMXBean.class);
                    this.garbageCollectorMBeans.add(garbageCollectorMXBean);
                }
            }
        }
        return this.garbageCollectorMBeans;
    }

    public MemoryMXBean getMemoryMXBean() throws IOException {
        if (this.memoryMBean == null) {
            this.memoryMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Memory", MemoryMXBean.class);
        }
        return this.memoryMBean;
    }

    public RuntimeMXBean getRuntimeMXBean() throws IOException {
        if (this.runtimeMBean == null) {
            this.runtimeMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Runtime", RuntimeMXBean.class);
        }
        return this.runtimeMBean;
    }

    public ThreadMXBean getThreadMXBean() throws IOException {
        if (this.threadMBean == null) {
            this.threadMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Threading", ThreadMXBean.class);
        }
        return this.threadMBean;
    }

    public java.lang.management.OperatingSystemMXBean getOperatingSystemMXBean() throws IOException {
        if (this.operatingSystemMBean == null) {
            this.operatingSystemMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=OperatingSystem", java.lang.management.OperatingSystemMXBean.class);
        }
        return this.operatingSystemMBean;
    }

    public OperatingSystemMXBean getIBMOperatingSystemMXBean() throws IOException {
        try {
            ObjectName objectName = new ObjectName("java.lang:type=OperatingSystem");
            if (this.IBMOperatingSystemMXBean == null && this.server.isInstanceOf(objectName, "com.ibm.lang.management.OperatingSystemMXBean")) {
                this.IBMOperatingSystemMXBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            if (this.verboseException != null) {
                instanceNotFoundException.printStackTrace();
            }
            return null;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (this.verboseException != null) {
                malformedObjectNameException.printStackTrace();
            }
            return null;
        }
        return this.IBMOperatingSystemMXBean;
    }

    public <T> T getMXBean(ObjectName objectName, Class<T> clazz) throws IOException {
        return ManagementFactory.newPlatformMXBeanProxy(this.server, objectName.toString(), clazz);
    }

    public synchronized void markAsDead() {
        if (this.isDead()) {
            return;
        }
        this.disconnect();
        this.isDead = true;
        String string = null;
        string = this.vmid != -1 ? Integer.toString(this.vmid) : (this.url != null ? this.url : this.hostName + ":" + this.port + ":" + this.userName + ":" + this.password);
        cache.remove(string);
    }

    public synchronized boolean isDead() {
        return this.isDead;
    }

    public boolean isRegistered(ObjectName objectName) throws IOException {
        return this.server.isRegistered(objectName);
    }
}

