/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPathEntry;

public class ClassPath {
    static final char dirSeparator = File.pathSeparatorChar;
    String pathstr;
    private ClassPathEntry[] path;
    private final String fileSeparatorChar = "" + File.separatorChar;

    public ClassPath(String string) {
        this.init(string);
    }

    public ClassPath() {
        String string = System.getProperty("sun.boot.class.path");
        String string2 = System.getProperty("env.class.path");
        if (string2 == null) {
            string2 = ".";
        }
        String string3 = string + File.pathSeparator + string2;
        this.init(string3);
    }

    private void init(String string) {
        this.pathstr = string;
        if (string.length() == 0) {
            this.path = new ClassPathEntry[0];
        }
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(dirSeparator, n2)) != -1) {
            ++n;
            ++n2;
        }
        ClassPathEntry[] classPathEntryArray = new ClassPathEntry[n + 1];
        int n3 = string.length();
        n = 0;
        n2 = 0;
        while (n2 < n3) {
            int n4 = string.indexOf(dirSeparator, n2);
            if (n4 == -1) {
                n4 = n3;
            }
            if (n2 == n4) {
                classPathEntryArray[n] = new ClassPathEntry();
                classPathEntryArray[n++].dir = new File(".");
            } else {
                File file = new File(string.substring(n2, n4));
                if (file.isFile()) {
                    try {
                        ZipFile zipFile = new ZipFile(file);
                        classPathEntryArray[n] = new ClassPathEntry();
                        classPathEntryArray[n++].zip = zipFile;
                    }
                    catch (ZipException zipException) {
                    }
                    catch (IOException iOException) {}
                } else {
                    classPathEntryArray[n] = new ClassPathEntry();
                    classPathEntryArray[n++].dir = file;
                }
            }
            n2 = n4 + 1;
        }
        this.path = new ClassPathEntry[n];
        System.arraycopy(classPathEntryArray, 0, this.path, 0, n);
    }

    public ClassFile getDirectory(String string) {
        return this.getFile(string, true);
    }

    public ClassFile getFile(String string) {
        return this.getFile(string, false);
    }

    private ClassFile getFile(String string, boolean bl) {
        int n;
        String string2 = string;
        String string3 = "";
        if (!bl) {
            n = string.lastIndexOf(File.separatorChar);
            string2 = string.substring(0, n + 1);
            string3 = string.substring(n + 1);
        } else if (!string2.equals("") && !string2.endsWith(this.fileSeparatorChar)) {
            string = string2 = string2 + File.separatorChar;
        }
        for (n = 0; n < this.path.length; ++n) {
            String[] stringArray;
            Object object;
            if (this.path[n].zip != null) {
                object = string.replace(File.separatorChar, '/');
                stringArray = this.path[n].zip.getEntry((String)object);
                if (stringArray == null) continue;
                return new ClassFile(this.path[n].zip, (ZipEntry)stringArray);
            }
            object = new File(this.path[n].dir.getPath(), string);
            stringArray = this.path[n].getFiles(string2);
            if (bl) {
                if (stringArray.length <= 0) continue;
                return new ClassFile((File)object);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string3.equals(stringArray[i])) continue;
                return new ClassFile((File)object);
            }
        }
        return null;
    }

    public Enumeration getFiles(String string, String string2) {
        Hashtable<String, ClassFile> hashtable = new Hashtable<String, ClassFile>();
        int n = this.path.length;
        while (--n >= 0) {
            String string3;
            String[] stringArray;
            if (this.path[n].zip != null) {
                stringArray = this.path[n].zip.entries();
                while (stringArray.hasMoreElements()) {
                    ZipEntry zipEntry = (ZipEntry)stringArray.nextElement();
                    string3 = zipEntry.getName();
                    if (!(string3 = string3.replace('/', File.separatorChar)).startsWith(string) || !string3.endsWith(string2)) continue;
                    hashtable.put(string3, new ClassFile(this.path[n].zip, zipEntry));
                }
                continue;
            }
            stringArray = this.path[n].getFiles(string);
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = stringArray[i];
                if (!string3.endsWith(string2)) continue;
                string3 = string + File.separatorChar + string3;
                File file = new File(this.path[n].dir.getPath(), string3);
                hashtable.put(string3, new ClassFile(file));
            }
        }
        return hashtable.elements();
    }

    public void close() throws IOException {
        int n = this.path.length;
        while (--n >= 0) {
            if (this.path[n].zip == null) continue;
            this.path[n].zip.close();
        }
    }

    public String toString() {
        return this.pathstr;
    }
}

