/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.parser.Keywords;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.LayoutCharacters;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Position;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Scanner
implements LayoutCharacters {
    private Tokens token;
    private boolean allowHexFloats;
    private int pos;
    private int endPos;
    private int prevEndPos;
    private int errPos = 0;
    private Name name;
    private int radix;
    private boolean deprecatedFlag = false;
    private char[] sbuf = new char[128];
    private int sp;
    private char[] buf;
    private int bp;
    private int buflen;
    private char ch;
    private int line;
    private int col;
    private int unicodeConversionBp = -1;
    private final Log log;
    private final Name.Table names;
    private final Keywords keywords;
    private String docComment = null;
    private char[] docCommentBuffer;
    private int docCommentCount;
    private Source source;
    private static String defaultEncodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
    private static final boolean hexFloatsWork = Scanner.hexFloatsWork();
    private final ByteBufferCache byteBufferCache;
    static final boolean surrogatesSupported = Scanner.surrogatesSupported();

    private Scanner(Factory factory) {
        this.log = factory.log;
        this.names = factory.names;
        this.keywords = factory.keywords;
        this.byteBufferCache = factory.byteBufferCache;
        this.source = factory.source;
        this.allowHexFloats = factory.source.allowHexFloats();
    }

    private static boolean hexFloatsWork() {
        try {
            Float.valueOf("0x1.0p1");
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected Scanner(Factory factory, CharBuffer charBuffer) {
        this(factory, ((CharBuffer)charBuffer.compact().flip()).array(), charBuffer.limit());
    }

    protected Scanner(Factory factory, char[] cArray, int n) {
        this(factory);
        assert (n < cArray.length);
        this.buf = cArray;
        this.buflen = n;
        this.buf[this.buflen] = 26;
        this.line = 1;
        this.col = 0;
        this.bp = -1;
        this.scanChar();
        this.nextToken();
    }

    protected Scanner(Factory factory, InputStream inputStream, String string) throws IOException {
        this(factory, Scanner.makeByteBuffer(factory, inputStream), string, true);
        inputStream.close();
    }

    private static ByteBuffer makeByteBuffer(Factory factory, InputStream inputStream) throws IOException {
        int n = inputStream.available();
        if (n < 1024) {
            n = 1024;
        }
        ByteBuffer byteBuffer = factory.byteBufferCache.get(n);
        int n2 = 0;
        while (inputStream.available() != 0) {
            int n3;
            if (n2 >= n) {
                byteBuffer = ByteBuffer.allocate(n <<= 1).put((ByteBuffer)byteBuffer.flip());
            }
            if ((n3 = inputStream.read(byteBuffer.array(), n2, n - n2)) < 0) break;
            byteBuffer.position(n2 += n3);
        }
        return (ByteBuffer)byteBuffer.flip();
    }

    private Scanner(Factory factory, ByteBuffer byteBuffer, String string, boolean bl) {
        this(factory, Scanner.decode(factory, byteBuffer, string));
        if (bl) {
            this.byteBufferCache.put(byteBuffer);
        }
    }

    public Scanner(Factory factory, ByteBuffer byteBuffer, String string) {
        this(factory, byteBuffer, string, false);
    }

    private static CharBuffer decode(Factory factory, ByteBuffer byteBuffer, String string) {
        CoderResult coderResult;
        CharsetDecoder charsetDecoder;
        try {
            if (string == null) {
                string = defaultEncodingName;
            }
            Charset charset = Charset.forName(string);
            charsetDecoder = charset.newDecoder();
            charsetDecoder.onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            Scanner.lexError(factory.log, 0, "unsupported.encoding", string);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            Scanner.lexError(factory.log, 0, "unsupported.encoding", string);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        float f = charsetDecoder.averageCharsPerByte() * 0.8f + charsetDecoder.maxCharsPerByte() * 0.2f;
        CharBuffer charBuffer = CharBuffer.allocate(10 + (int)((float)byteBuffer.remaining() * f));
        while (true) {
            int n;
            coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            charBuffer.flip();
            if (coderResult.isUnderflow()) {
                if (charBuffer.limit() == charBuffer.capacity()) {
                    charBuffer = CharBuffer.allocate(charBuffer.capacity() + 1).put(charBuffer);
                    charBuffer.flip();
                }
                return charBuffer;
            }
            if (coderResult.isOverflow()) {
                n = 10 + charBuffer.capacity() + (int)((float)byteBuffer.remaining() * charsetDecoder.maxCharsPerByte());
                charBuffer = CharBuffer.allocate(n).put(charBuffer);
                continue;
            }
            if (!coderResult.isMalformed() && !coderResult.isUnmappable()) break;
            n = 0;
            int n2 = 0;
            Pattern pattern = Pattern.compile("^.*$", 8);
            Matcher matcher = pattern.matcher(charBuffer);
            while (matcher.find()) {
                ++n;
                n2 = matcher.start();
            }
            int n3 = 0;
            for (int i = n2; i < charBuffer.limit(); ++i) {
                if (charBuffer.get(i) == '\t') {
                    n3 = n3 / 8 * 8 + 8;
                    continue;
                }
                ++n3;
            }
            ++n3;
            if (!factory.source.allowEncodingErrors()) {
                Scanner.lexError(factory.log, Position.make(n, n3), "illegal.char.for.encoding", string);
            } else {
                Scanner.lexWarning(factory.log, Position.make(n, n3), "illegal.char.for.encoding", string);
            }
            byteBuffer.position(byteBuffer.position() + coderResult.length());
            charBuffer.position(charBuffer.limit());
            charBuffer.limit(charBuffer.capacity());
            charBuffer.put('\ufffd');
        }
        throw new AssertionError(coderResult);
    }

    private static void lexWarning(Log log, int n, String string, Object object) {
        log.warning(n, string, object);
    }

    private static void lexError(Log log, int n, String string, Object object) {
        log.error(n, string, object);
    }

    private static void lexError(Log log, int n, String string) {
        Scanner.lexError(log, n, string, null);
    }

    private void lexError(int n, String string, Object object) {
        this.log.error(n, string, object);
        this.token = Tokens.ERROR;
        this.errPos = n;
    }

    private void lexError(int n, String string) {
        this.lexError(n, string, null);
    }

    private void lexError(String string) {
        this.lexError(this.pos, string, null);
    }

    private void lexError(String string, Object object) {
        this.lexError(this.pos, string, object);
    }

    private void lexWarning(int n, String string) {
        this.log.warning(n, string, new Object[0]);
    }

    private int digit(int n) {
        char c = this.ch;
        int n2 = Character.digit(c, n);
        if (n2 >= 0 && c > '\u007f') {
            this.lexWarning(this.pos + 1, "illegal.nonascii.digit");
            this.ch = "0123456789abcdef".charAt(n2);
        }
        return n2;
    }

    private void convertUnicode() {
        int n = this.col++;
        if (this.ch == '\\' && this.unicodeConversionBp != this.bp) {
            ++this.bp;
            this.ch = this.buf[this.bp];
            if (this.ch == 'u') {
                do {
                    ++this.bp;
                    this.ch = this.buf[this.bp];
                    ++this.col;
                } while (this.ch == 'u');
                int n2 = this.bp + 3;
                if (n2 < this.buflen) {
                    int n3;
                    int n4 = n3 = this.digit(16);
                    while (this.bp < n2 && n3 >= 0) {
                        ++this.bp;
                        this.ch = this.buf[this.bp];
                        ++this.col;
                        n3 = this.digit(16);
                        n4 = (n4 << 4) + n3;
                    }
                    if (n3 >= 0) {
                        this.ch = (char)n4;
                        this.unicodeConversionBp = this.bp;
                        return;
                    }
                }
                this.lexError(Position.make(this.line, n), "illegal.unicode.esc");
            } else {
                --this.bp;
                this.ch = (char)92;
                --this.col;
            }
        }
    }

    private void scanChar() {
        ++this.bp;
        this.ch = this.buf[this.bp];
        switch (this.ch) {
            case '\r': {
                this.col = 0;
                ++this.line;
                break;
            }
            case '\n': {
                if (this.bp != 0 && this.buf[this.bp - 1] == '\r') break;
                this.col = 0;
                ++this.line;
                break;
            }
            case '\t': {
                this.col = this.col / 8 * 8 + 8;
                break;
            }
            case '\\': {
                ++this.col;
                this.convertUnicode();
                break;
            }
            default: {
                ++this.col;
            }
        }
    }

    private void scanCommentChar() {
        this.scanChar();
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                ++this.bp;
                ++this.col;
            } else {
                this.convertUnicode();
            }
        }
    }

    private void expandCommentBuffer() {
        char[] cArray = new char[this.docCommentBuffer.length * 2];
        System.arraycopy(this.docCommentBuffer, 0, cArray, 0, this.docCommentBuffer.length);
        this.docCommentBuffer = cArray;
    }

    private void scanDocCommentChar() {
        this.scanChar();
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                if (this.docCommentCount == this.docCommentBuffer.length) {
                    this.expandCommentBuffer();
                }
                this.docCommentBuffer[this.docCommentCount++] = this.ch;
                ++this.bp;
                ++this.col;
            } else {
                this.convertUnicode();
            }
        }
    }

    private void putChar(char c) {
        if (this.sp == this.sbuf.length) {
            char[] cArray = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
            this.sbuf = cArray;
        }
        this.sbuf[this.sp++] = c;
    }

    private void dch() {
        System.err.print(this.ch);
        System.out.flush();
    }

    private void scanLitChar() {
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                ++this.bp;
                ++this.col;
                this.putChar('\\');
                this.scanChar();
            } else {
                this.scanChar();
                switch (this.ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char c = this.ch;
                        int n = this.digit(8);
                        this.scanChar();
                        if ('0' <= this.ch && this.ch <= '7') {
                            n = n * 8 + this.digit(8);
                            this.scanChar();
                            if (c <= '3' && '0' <= this.ch && this.ch <= '7') {
                                n = n * 8 + this.digit(8);
                                this.scanChar();
                            }
                        }
                        this.putChar((char)n);
                        break;
                    }
                    case 'b': {
                        this.putChar('\b');
                        this.scanChar();
                        break;
                    }
                    case 't': {
                        this.putChar('\t');
                        this.scanChar();
                        break;
                    }
                    case 'n': {
                        this.putChar('\n');
                        this.scanChar();
                        break;
                    }
                    case 'f': {
                        this.putChar('\f');
                        this.scanChar();
                        break;
                    }
                    case 'r': {
                        this.putChar('\r');
                        this.scanChar();
                        break;
                    }
                    case '\'': {
                        this.putChar('\'');
                        this.scanChar();
                        break;
                    }
                    case '\"': {
                        this.putChar('\"');
                        this.scanChar();
                        break;
                    }
                    case '\\': {
                        this.putChar('\\');
                        this.scanChar();
                        break;
                    }
                    default: {
                        this.lexError(Position.make(this.line, this.col), "illegal.esc.char");
                        break;
                    }
                }
            }
        } else if (this.bp != this.buflen) {
            this.putChar(this.ch);
            this.scanChar();
        }
    }

    private void scanHexExponentAndSuffix() {
        if (this.ch == 'p' || this.ch == 'P') {
            this.putChar(this.ch);
            this.scanChar();
            if (this.ch == '+' || this.ch == '-') {
                this.putChar(this.ch);
                this.scanChar();
            }
            if ('0' <= this.ch && this.ch <= '9') {
                do {
                    this.putChar(this.ch);
                    this.scanChar();
                } while ('0' <= this.ch && this.ch <= '9');
                if (!this.allowHexFloats) {
                    this.lexError("unsupported.fp.lit");
                    this.allowHexFloats = true;
                } else if (!hexFloatsWork) {
                    this.lexError("unsupported.cross.fp.lit");
                }
            } else {
                this.lexError("malformed.fp.lit");
            }
        } else {
            this.lexError("malformed.fp.lit");
        }
        if (this.ch == 'f' || this.ch == 'F') {
            this.putChar(this.ch);
            this.scanChar();
            this.token = Tokens.FLOATLITERAL;
        } else {
            if (this.ch == 'd' || this.ch == 'D') {
                this.putChar(this.ch);
                this.scanChar();
            }
            this.token = Tokens.DOUBLELITERAL;
        }
    }

    private void scanFraction() {
        while (this.digit(10) >= 0) {
            this.putChar(this.ch);
            this.scanChar();
        }
        int n = this.sp;
        if (this.ch == 'e' || this.ch == 'E') {
            this.putChar(this.ch);
            this.scanChar();
            if (this.ch == '+' || this.ch == '-') {
                this.putChar(this.ch);
                this.scanChar();
            }
            if ('0' <= this.ch && this.ch <= '9') {
                do {
                    this.putChar(this.ch);
                    this.scanChar();
                } while ('0' <= this.ch && this.ch <= '9');
                return;
            }
            this.lexError("malformed.fp.lit");
            this.sp = n;
        }
    }

    private void scanFractionAndSuffix() {
        this.radix = 10;
        this.scanFraction();
        if (this.ch == 'f' || this.ch == 'F') {
            this.putChar(this.ch);
            this.scanChar();
            this.token = Tokens.FLOATLITERAL;
        } else {
            if (this.ch == 'd' || this.ch == 'D') {
                this.putChar(this.ch);
                this.scanChar();
            }
            this.token = Tokens.DOUBLELITERAL;
        }
    }

    private void scanHexFractionAndSuffix(boolean bl) {
        this.radix = 16;
        assert (this.ch == '.');
        this.putChar(this.ch);
        this.scanChar();
        while (this.digit(16) >= 0) {
            bl = true;
            this.putChar(this.ch);
            this.scanChar();
        }
        if (!bl) {
            this.lexError("invalid.hex.number");
        } else {
            this.scanHexExponentAndSuffix();
        }
    }

    private void scanNumber(int n) {
        this.radix = n;
        int n2 = n <= 10 ? 10 : 16;
        boolean bl = false;
        while (this.digit(n2) >= 0) {
            bl = true;
            this.putChar(this.ch);
            this.scanChar();
        }
        if (n == 16 && this.ch == '.') {
            this.scanHexFractionAndSuffix(bl);
        } else if (bl && n == 16 && (this.ch == 'p' || this.ch == 'P')) {
            this.scanHexExponentAndSuffix();
        } else if (n <= 10 && this.ch == '.') {
            this.putChar(this.ch);
            this.scanChar();
            this.scanFractionAndSuffix();
        } else if (n <= 10 && (this.ch == 'e' || this.ch == 'E' || this.ch == 'f' || this.ch == 'F' || this.ch == 'd' || this.ch == 'D')) {
            this.scanFractionAndSuffix();
        } else if (this.ch == 'l' || this.ch == 'L') {
            this.scanChar();
            this.token = Tokens.LONGLITERAL;
        } else {
            this.token = Tokens.INTLITERAL;
        }
    }

    private void scanIdent() {
        block4: while (true) {
            boolean bl;
            if (this.sp == this.sbuf.length) {
                this.putChar(this.ch);
            } else {
                this.sbuf[this.sp++] = this.ch;
            }
            this.scanChar();
            switch (this.ch) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '$': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '\u007f': {
                    continue block4;
                }
                case '\u001a': {
                    if (this.bp < this.buflen) continue block4;
                    this.name = this.names.fromChars(this.sbuf, 0, this.sp);
                    this.token = this.keywords.key(this.name);
                    return;
                }
            }
            if (this.ch < '\u0080') {
                bl = false;
            } else {
                char c = this.scanSurrogates();
                if (c != '\u0000') {
                    if (this.sp == this.sbuf.length) {
                        this.putChar(c);
                    } else {
                        this.sbuf[this.sp++] = c;
                    }
                    bl = Character.isJavaIdentifierPart(Character.toCodePoint(c, this.ch));
                } else {
                    bl = Character.isJavaIdentifierPart(this.ch);
                }
            }
            if (!bl) break;
        }
        this.name = this.names.fromChars(this.sbuf, 0, this.sp);
        this.token = this.keywords.key(this.name);
    }

    private static boolean surrogatesSupported() {
        try {
            boolean bl = Character.isHighSurrogate('a');
            return true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return false;
        }
    }

    private char scanSurrogates() {
        if (surrogatesSupported && Character.isHighSurrogate(this.ch)) {
            char c = this.ch;
            this.scanChar();
            if (Character.isLowSurrogate(this.ch)) {
                return c;
            }
            this.ch = c;
        }
        return '\u0000';
    }

    private boolean isSpecial(char c) {
        switch (c) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private void scanOperator() {
        do {
            this.putChar(this.ch);
            Name name = this.names.fromChars(this.sbuf, 0, this.sp);
            if (this.keywords.key(name) == Tokens.IDENTIFIER) {
                --this.sp;
                break;
            }
            this.name = name;
            this.token = this.keywords.key(name);
            this.scanChar();
        } while (this.isSpecial(this.ch));
    }

    private void scanDocCommentTag() {
        int n = this.bp + 1;
        do {
            this.scanDocCommentChar();
        } while ('a' <= this.ch && this.ch <= 'z');
        if (this.names.fromChars(this.buf, n, this.bp - n) == this.names.deprecated) {
            this.deprecatedFlag = true;
        }
    }

    private void skipComment() {
        block3: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '*': {
                    this.scanChar();
                    if (this.ch != '/') continue block3;
                    return;
                }
            }
            this.scanCommentChar();
        }
    }

    private String scanDocComment() {
        int n;
        if (this.docCommentBuffer == null) {
            this.docCommentBuffer = new char[1024];
        }
        this.docCommentCount = 0;
        boolean bl = false;
        boolean bl2 = true;
        while (this.bp < this.buflen && this.ch == '*') {
            this.scanDocCommentChar();
        }
        if (this.bp < this.buflen && this.ch == '/') {
            return "";
        }
        if (this.bp < this.buflen) {
            if (this.ch == '\n') {
                this.scanDocCommentChar();
                bl2 = false;
            } else if (this.ch == '\r') {
                this.scanDocCommentChar();
                if (this.ch == '\n') {
                    this.scanDocCommentChar();
                    bl2 = false;
                }
            }
        }
        block16: while (this.bp < this.buflen) {
            block17: while (this.bp < this.buflen) {
                switch (this.ch) {
                    case ' ': {
                        this.scanDocCommentChar();
                        continue block17;
                    }
                    case '\t': {
                        this.col = (this.col - 1) / 8 * 8 + 8;
                        this.scanDocCommentChar();
                        continue block17;
                    }
                    case '\f': {
                        this.col = 0;
                        this.scanDocCommentChar();
                        continue block17;
                    }
                }
            }
            if (this.ch == '*') {
                do {
                    this.scanDocCommentChar();
                } while (this.ch == '*');
                if (this.ch == '/') {
                    break;
                }
            } else if (!bl2) {
                for (n = 1; n < this.col; ++n) {
                    if (this.docCommentCount == this.docCommentBuffer.length) {
                        this.expandCommentBuffer();
                    }
                    this.docCommentBuffer[this.docCommentCount++] = 32;
                }
            }
            bl = true;
            block20: while (this.bp < this.buflen) {
                switch (this.ch) {
                    case '*': {
                        bl = false;
                        this.scanDocCommentChar();
                        if (this.ch == '/') break block16;
                        if (this.docCommentCount == this.docCommentBuffer.length) {
                            this.expandCommentBuffer();
                        }
                        this.docCommentBuffer[this.docCommentCount++] = 42;
                        continue block20;
                    }
                    case '\t': 
                    case ' ': {
                        if (this.docCommentCount == this.docCommentBuffer.length) {
                            this.expandCommentBuffer();
                        }
                        this.docCommentBuffer[this.docCommentCount++] = this.ch;
                        this.scanDocCommentChar();
                        continue block20;
                    }
                    case '\f': {
                        this.scanDocCommentChar();
                        break block20;
                    }
                    case '\r': {
                        this.scanDocCommentChar();
                        if (this.ch != '\n') {
                            if (this.docCommentCount == this.docCommentBuffer.length) {
                                this.expandCommentBuffer();
                            }
                            this.docCommentBuffer[this.docCommentCount++] = 10;
                            break block20;
                        }
                    }
                    case '\n': {
                        if (this.docCommentCount == this.docCommentBuffer.length) {
                            this.expandCommentBuffer();
                        }
                        this.docCommentBuffer[this.docCommentCount++] = this.ch;
                        this.scanDocCommentChar();
                        break block20;
                    }
                    default: {
                        if (this.ch == '@' && bl) {
                            n = this.bp + 1;
                            do {
                                if (this.docCommentCount == this.docCommentBuffer.length) {
                                    this.expandCommentBuffer();
                                }
                                this.docCommentBuffer[this.docCommentCount++] = this.ch;
                                this.scanDocCommentChar();
                            } while ('a' <= this.ch && this.ch <= 'z');
                            if (this.names.fromChars(this.buf, n, this.bp - n) == this.names.deprecated) {
                                this.deprecatedFlag = true;
                            }
                        } else {
                            if (this.docCommentCount == this.docCommentBuffer.length) {
                                this.expandCommentBuffer();
                            }
                            this.docCommentBuffer[this.docCommentCount++] = this.ch;
                            this.scanDocCommentChar();
                        }
                        bl = false;
                        continue block20;
                    }
                }
            }
            bl2 = false;
        }
        if (this.docCommentCount > 0) {
            block22: for (n = this.docCommentCount - 1; n > -1; --n) {
                switch (this.docCommentBuffer[n]) {
                    case '*': {
                        continue block22;
                    }
                }
            }
            this.docCommentCount = n + 1;
            return new String(this.docCommentBuffer, 0, this.docCommentCount);
        }
        return "";
    }

    public String stringVal() {
        return new String(this.sbuf, 0, this.sp);
    }

    public void nextToken() {
        try {
            this.prevEndPos = this.endPos;
            this.sp = 0;
            this.docComment = null;
            while (true) {
                this.pos = (this.line << 10) + this.col;
                int n = this.bp;
                switch (this.ch) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        this.scanChar();
                        break;
                    }
                    case '$': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '_': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        this.scanIdent();
                        return;
                    }
                    case '0': {
                        this.scanChar();
                        if (this.ch == 'x' || this.ch == 'X') {
                            this.scanChar();
                            if (this.ch == '.') {
                                this.scanHexFractionAndSuffix(false);
                            } else if (this.digit(16) < 0) {
                                this.lexError("invalid.hex.number");
                            } else {
                                this.scanNumber(16);
                            }
                        } else {
                            this.putChar('0');
                            this.scanNumber(8);
                        }
                        return;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.scanNumber(10);
                        return;
                    }
                    case '.': {
                        this.scanChar();
                        if ('0' <= this.ch && this.ch <= '9') {
                            this.putChar('.');
                            this.scanFractionAndSuffix();
                        } else if (this.ch == '.') {
                            this.putChar('.');
                            this.putChar('.');
                            this.scanChar();
                            if (this.ch == '.') {
                                this.scanChar();
                                this.putChar('.');
                                this.token = Tokens.ELLIPSIS;
                            } else {
                                this.lexError("malformed.fp.lit");
                            }
                        } else {
                            this.token = Tokens.DOT;
                        }
                        return;
                    }
                    case ',': {
                        this.scanChar();
                        this.token = Tokens.COMMA;
                        return;
                    }
                    case ';': {
                        this.scanChar();
                        this.token = Tokens.SEMI;
                        return;
                    }
                    case '(': {
                        this.scanChar();
                        this.token = Tokens.LPAREN;
                        return;
                    }
                    case ')': {
                        this.scanChar();
                        this.token = Tokens.RPAREN;
                        return;
                    }
                    case '[': {
                        this.scanChar();
                        this.token = Tokens.LBRACKET;
                        return;
                    }
                    case ']': {
                        this.scanChar();
                        this.token = Tokens.RBRACKET;
                        return;
                    }
                    case '{': {
                        this.scanChar();
                        this.token = Tokens.LBRACE;
                        return;
                    }
                    case '}': {
                        this.scanChar();
                        this.token = Tokens.RBRACE;
                        return;
                    }
                    case '/': {
                        this.scanChar();
                        if (this.ch == '/') {
                            do {
                                this.scanCommentChar();
                            } while (this.ch != '\r' && this.ch != '\n' && this.bp < this.buflen);
                            break;
                        }
                        if (this.ch == '*') {
                            this.scanChar();
                            if (this.ch == '*') {
                                this.docComment = this.scanDocComment();
                            } else {
                                this.skipComment();
                            }
                            if (this.ch == '/') {
                                this.scanChar();
                                break;
                            }
                            this.lexError("unclosed.comment");
                            return;
                        }
                        if (this.ch == '=') {
                            this.name = this.names.slashequals;
                            this.token = Tokens.SLASHEQ;
                            this.scanChar();
                        } else {
                            this.name = this.names.slash;
                            this.token = Tokens.SLASH;
                        }
                        return;
                    }
                    case '\'': {
                        this.scanChar();
                        if (this.ch == '\'') {
                            this.lexError("empty.char.lit");
                        } else {
                            if (this.ch == '\r' || this.ch == '\n') {
                                this.lexError(this.pos, "illegal.line.end.in.char.lit");
                            }
                            this.scanLitChar();
                            if (this.ch == '\'') {
                                this.scanChar();
                                this.token = Tokens.CHARLITERAL;
                            } else {
                                this.lexError(this.pos, "unclosed.char.lit");
                            }
                        }
                        return;
                    }
                    case '\"': {
                        this.scanChar();
                        while (this.ch != '\"' && this.ch != '\r' && this.ch != '\n' && this.bp < this.buflen) {
                            this.scanLitChar();
                        }
                        if (this.ch == '\"') {
                            this.token = Tokens.STRINGLITERAL;
                            this.scanChar();
                        } else {
                            this.lexError(this.pos, "unclosed.str.lit");
                        }
                        return;
                    }
                    default: {
                        if (this.isSpecial(this.ch)) {
                            this.scanOperator();
                        } else {
                            boolean bl;
                            if (this.ch < '\u0080') {
                                bl = false;
                            } else {
                                char c = this.scanSurrogates();
                                if (c != '\u0000') {
                                    if (this.sp == this.sbuf.length) {
                                        this.putChar(c);
                                    } else {
                                        this.sbuf[this.sp++] = c;
                                    }
                                    bl = Character.isJavaIdentifierStart(Character.toCodePoint(c, this.ch));
                                } else {
                                    bl = Character.isJavaIdentifierStart(this.ch);
                                }
                            }
                            if (bl) {
                                this.scanIdent();
                            } else if (this.bp == this.buflen || this.ch == '\u001a' && this.bp + 1 == this.buflen) {
                                this.token = Tokens.EOF;
                            } else {
                                this.lexError("illegal.char", (Object)String.valueOf((int)this.ch));
                                this.scanChar();
                            }
                        }
                        return;
                    }
                }
            }
        }
        finally {
            this.endPos = (this.line << 10) + this.col - 1;
        }
    }

    public Tokens token() {
        return this.token;
    }

    public void token(Tokens tokens) {
        this.token = tokens;
    }

    public int pos() {
        return this.pos;
    }

    public int endPos() {
        return this.endPos;
    }

    public int prevEndPos() {
        return this.prevEndPos;
    }

    public int errPos() {
        return this.errPos;
    }

    public void errPos(int n) {
        this.errPos = n;
    }

    public Name name() {
        return this.name;
    }

    public int radix() {
        return this.radix;
    }

    public boolean deprecatedFlag() {
        return this.deprecatedFlag;
    }

    public void resetDeprecatedFlag() {
        this.deprecatedFlag = false;
    }

    public String docComment() {
        return this.docComment;
    }

    private static class ByteBufferCache {
        private ByteBuffer cached;
        protected static final Context.Key<ByteBufferCache> key = new Context.Key();

        ByteBuffer get(int n) {
            if (n < 20480) {
                n = 20480;
            }
            ByteBuffer byteBuffer = this.cached != null && this.cached.capacity() >= n ? (ByteBuffer)this.cached.clear() : ByteBuffer.allocate(n + n >> 1);
            this.cached = null;
            return byteBuffer;
        }

        void put(ByteBuffer byteBuffer) {
            this.cached = byteBuffer;
        }

        protected ByteBufferCache(Context context) {
            context.put(key, this);
        }

        static ByteBufferCache instance(Context context) {
            ByteBufferCache byteBufferCache = context.get(key);
            if (byteBufferCache == null) {
                byteBufferCache = new ByteBufferCache(context);
            }
            return byteBufferCache;
        }
    }

    public static class Factory {
        protected static final Context.Key<Factory> scannerFactoryKey = new Context.Key();
        final Log log;
        final Name.Table names;
        final Source source;
        final Keywords keywords;
        final ByteBufferCache byteBufferCache;

        public static Factory instance(Context context) {
            Factory factory = context.get(scannerFactoryKey);
            if (factory == null) {
                factory = new Factory(context);
            }
            return factory;
        }

        protected Factory(Context context) {
            context.put(scannerFactoryKey, this);
            this.log = Log.instance(context);
            this.names = Name.Table.instance(context);
            this.source = Source.instance(context);
            this.keywords = Keywords.instance(context);
            this.byteBufferCache = ByteBufferCache.instance(context);
        }

        public Scanner newScanner(InputStream inputStream, String string) throws IOException {
            return new Scanner(this, inputStream, string);
        }

        public Scanner newScanner(CharBuffer charBuffer) {
            return new Scanner(this, charBuffer);
        }

        public Scanner newScanner(char[] cArray, int n) {
            return new Scanner(this, cArray, n);
        }
    }
}

