/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.formats.html.AbstractTreeWriter;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.ClassTree;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;

public class PackageTreeWriter
extends AbstractTreeWriter {
    protected PackageDoc packagedoc;
    protected PackageDoc prev;
    protected PackageDoc next;

    public PackageTreeWriter(ConfigurationImpl configurationImpl, String string, String string2, PackageDoc packageDoc, PackageDoc packageDoc2, PackageDoc packageDoc3) throws IOException {
        super(configurationImpl, string, string2, new ClassTree(configurationImpl.classDocCatalog.allClasses(packageDoc), (Configuration)configurationImpl), packageDoc);
        this.packagedoc = packageDoc;
        this.prev = packageDoc2;
        this.next = packageDoc3;
    }

    public static void generate(ConfigurationImpl configurationImpl, PackageDoc packageDoc, PackageDoc packageDoc2, PackageDoc packageDoc3, boolean bl) {
        String string = DirectoryManager.getDirectoryPath(packageDoc);
        String string2 = "package-tree.html";
        try {
            PackageTreeWriter packageTreeWriter = new PackageTreeWriter(configurationImpl, string, string2, packageDoc, packageDoc2, packageDoc3);
            packageTreeWriter.generatePackageTreeFile();
            packageTreeWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), string2);
            throw new DocletAbortException();
        }
    }

    protected void generatePackageTreeFile() throws IOException {
        this.printHtmlHeader(this.packagedoc.name() + " " + this.configuration.getText("doclet.Window_Class_Hierarchy"), null, true);
        this.printPackageTreeHeader();
        if (this.configuration.packages.length > 1) {
            this.printLinkToMainTree();
        }
        this.generateTree(this.classtree.baseclasses(), "doclet.Class_Hierarchy");
        this.generateTree(this.classtree.baseinterfaces(), "doclet.Interface_Hierarchy");
        this.generateTree(this.classtree.baseAnnotationTypes(), "doclet.Annotation_Type_Hierarchy");
        this.generateTree(this.classtree.baseEnums(), "doclet.Enum_Hierarchy");
        this.printPackageTreeFooter();
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printPackageTreeHeader() {
        this.navLinks(true);
        this.hr();
        this.aName("main");
        this.aEnd();
        this.println("");
        this.center();
        this.h2(this.configuration.getText("doclet.Hierarchy_For_Package", Util.getPackageName(this.packagedoc)));
        this.centerEnd();
    }

    protected void printLinkToMainTree() {
        this.dl();
        this.dt();
        this.boldText("doclet.Package_Hierarchies");
        this.dd();
        this.navLinkMainTree(this.configuration.getText("doclet.All_Packages"));
        this.dlEnd();
        this.hr();
    }

    protected void printPackageTreeFooter() {
        this.hr();
        this.navLinks(false);
    }

    protected void navLinkPrevious() {
        if (this.prev == null) {
            this.navLinkPrevious(null);
        } else {
            String string = DirectoryManager.getRelativePath(this.packagedoc.name(), this.prev.name());
            this.navLinkPrevious(string + "package-tree.html");
        }
    }

    protected void navLinkNext() {
        if (this.next == null) {
            this.navLinkNext(null);
        } else {
            String string = DirectoryManager.getRelativePath(this.packagedoc.name(), this.next.name());
            this.navLinkNext(string + "package-tree.html");
        }
    }

    protected void navLinkPackage() {
        this.navCellStart();
        this.printHyperLink("package-summary.html", "", this.configuration.getText("doclet.Package"), true, "NavBarFont1");
        this.navCellEnd();
    }
}

