/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.comp;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.AnnotationProcessors;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.tools.apt.comp.AnnotationProcessingError;
import com.sun.tools.apt.comp.BootstrapAPF;
import com.sun.tools.apt.comp.UsageMessageNeededException;
import com.sun.tools.apt.mirror.AptEnv;
import com.sun.tools.apt.mirror.apt.AnnotationProcessorEnvironmentImpl;
import com.sun.tools.apt.mirror.apt.FilerImpl;
import com.sun.tools.apt.mirror.declaration.DeclarationMaker;
import com.sun.tools.apt.util.Bark;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Options;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import sun.misc.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Apt
extends ListBuffer<Env<AttrContext>> {
    Set<String> genSourceFileNames = new LinkedHashSet<String>();
    Set<String> genClassFileNames = new LinkedHashSet<String>();
    AptEnv aptenv;
    private Context context;
    protected static final Context.Key<Apt> aptKey = new Context.Key();
    private static final Pattern allMatches = Pattern.compile(".*");
    private static final Pattern noMatches = Pattern.compile("(\\P{all})+");

    public Set<String> getSourceFileNames() {
        return this.genSourceFileNames;
    }

    public Set<String> getClassFileNames() {
        return this.genClassFileNames;
    }

    public static Apt instance(Context context) {
        Apt apt = context.get(aptKey);
        if (apt == null) {
            apt = new Apt(context);
        }
        return apt;
    }

    protected Apt(Context context) {
        this.context = context;
        context.put(aptKey, this);
        this.aptenv = AptEnv.instance(context);
    }

    Set<String> computeAnnotationSet(Collection<Symbol.ClassSymbol> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Symbol.ClassSymbol classSymbol : collection) {
            this.computeAnnotationSet(classSymbol, hashSet);
        }
        return hashSet;
    }

    void computeAnnotationSet(Symbol symbol, Set<String> set) {
        if (symbol != null) {
            if (symbol.attributes() != null) {
                for (Attribute.Compound object : symbol.attributes()) {
                    set.add(object.type.tsym.toString());
                }
            }
            if (symbol instanceof Symbol.MethodSymbol) {
                for (Symbol.VarSymbol varSymbol : ((Symbol.MethodSymbol)symbol).params()) {
                    this.computeAnnotationSet(varSymbol, set);
                }
            }
            if (symbol.members() != null) {
                for (Iterator<Object> iterator : symbol.members().table) {
                    this.computeAnnotationSet(((Scope.Entry)((Object)iterator)).sym, set);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void main(List<Tree> list, ListBuffer<Symbol.ClassSymbol> listBuffer, Map<String, String> map, ClassLoader classLoader, AnnotationProcessorFactory annotationProcessorFactory, Set<Class<? extends AnnotationProcessorFactory>> set) {
        Object object;
        Bark bark = Bark.instance(this.context);
        PrintWriter printWriter = bark.warnWriter;
        Options options = Options.instance(this.context);
        LinkedHashSet<TypeDeclaration> linkedHashSet = new LinkedHashSet<TypeDeclaration>();
        LinkedHashSet<TypeDeclaration> linkedHashSet2 = new LinkedHashSet<TypeDeclaration>();
        LinkedHashSet<String> linkedHashSet3 = new LinkedHashSet<String>();
        Set set2 = Collections.emptySet();
        LinkedHashSet linkedHashSet4 = new LinkedHashSet();
        AptTreeScanner aptTreeScanner = new AptTreeScanner();
        for (Tree iterator2 : list) {
            iterator2.accept(aptTreeScanner);
        }
        for (Symbol.ClassSymbol classSymbol : aptTreeScanner.specifiedDeclCollection) {
            object = this.aptenv.declMaker.getTypeDeclaration(classSymbol);
            linkedHashSet.add((TypeDeclaration)object);
        }
        for (Symbol.ClassSymbol classSymbol : aptTreeScanner.declCollection) {
            object = this.aptenv.declMaker.getTypeDeclaration(classSymbol);
            linkedHashSet2.add((TypeDeclaration)object);
        }
        linkedHashSet3.addAll(aptTreeScanner.getAnnotationSet());
        for (Symbol.ClassSymbol classSymbol : listBuffer) {
            object = this.aptenv.declMaker.getTypeDeclaration(classSymbol);
            linkedHashSet.add((TypeDeclaration)object);
            linkedHashSet2.add((TypeDeclaration)object);
            this.computeAnnotationSet(classSymbol, linkedHashSet3);
        }
        if (options.get("-XListAnnotationTypes") != null) {
            printWriter.println("Set of annotations found:" + new TreeSet(linkedHashSet3).toString());
        }
        AnnotationProcessorEnvironmentImpl annotationProcessorEnvironmentImpl = new AnnotationProcessorEnvironmentImpl(linkedHashSet, linkedHashSet2, map, this.context);
        if (options.get("-XListDeclarations") != null) {
            printWriter.println("Set of Specified Declarations:" + linkedHashSet);
            printWriter.println("Set of Included Declarations: " + linkedHashSet2);
        }
        if (options.get("-print") != null) {
            if (linkedHashSet.size() == 0) {
                throw new UsageMessageNeededException();
            }
            AnnotationProcessor annotationProcessor = new BootstrapAPF().getProcessorFor(new HashSet<AnnotationTypeDeclaration>(), annotationProcessorEnvironmentImpl);
            annotationProcessor.process();
        } else {
            Object object2;
            Serializable serializable2;
            void var17_29;
            Object object3;
            Object var17_25 = null;
            object = new LinkedList();
            Set<Serializable> set3 = (String)options.get("-factory");
            if (annotationProcessorFactory != null) {
                object.add(annotationProcessorFactory);
                Iterator iterator = object.iterator();
            } else if (set3 != null) {
                try {
                    object3 = (AnnotationProcessorFactory)classLoader.loadClass((String)((Object)set3)).newInstance();
                    object.add(object3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bark.warning(0, "FactoryNotFound", set3);
                }
                catch (ClassCastException classCastException) {
                    bark.warning(0, "FactoryWrongType", set3);
                }
                catch (Exception exception) {
                    bark.warning(0, "FactoryCantInstantiate", set3);
                }
                catch (Throwable throwable) {
                    throw new AnnotationProcessingError(throwable);
                }
                Iterator iterator = object.iterator();
            } else {
                Iterator iterator = Service.providers(AnnotationProcessorFactory.class, (ClassLoader)classLoader);
            }
            object = new LinkedHashMap();
            if (!var17_29.hasNext() && set.size() == 0) {
                if (linkedHashSet3.size() > 0) {
                    bark.warning(0, "NoAnnotationProcessors", new Object[0]);
                }
                if (linkedHashSet.size() == 0) {
                    throw new UsageMessageNeededException();
                }
                return;
            }
            if (linkedHashSet3.size() == 0) {
                linkedHashSet3.add("");
            }
            set3 = new HashSet();
            set3.add((Serializable)((Object)""));
            set3 = Collections.unmodifiableSet(set3);
            while (var17_29.hasNext()) {
                object3 = var17_29.next();
                try {
                    serializable2 = new HashSet();
                    object2 = object3;
                    Collection collection = object2.supportedAnnotationTypes();
                    LinkedList<Pattern> linkedList = new LinkedList<Pattern>();
                    for (String string : collection) {
                        linkedList.add(this.importStringToPattern(string));
                    }
                    block22: for (String string : linkedHashSet3) {
                        for (Pattern pattern : linkedList) {
                            if (!pattern.matcher(string).matches()) continue;
                            serializable2.add(string);
                            continue block22;
                        }
                    }
                    linkedHashSet3.removeAll((Collection<?>)((Object)serializable2));
                    if (options.get("-XPrintFactoryInfo") != null) {
                        printWriter.println("Factory " + object2.getClass().getName() + " matches " + (serializable2.size() == 0 ? "nothing." : serializable2));
                    }
                    if (serializable2.size() > 0) {
                        HashSet hashSet = new HashSet();
                        if (!serializable2.equals(set3)) {
                            Iterator iterator = serializable2.iterator();
                            while (iterator.hasNext()) {
                                Pattern pattern;
                                String string = (String)iterator.next();
                                pattern = this.aptenv.declMaker.getTypeDeclaration(string);
                                if (pattern == null) {
                                    bark.error(0, "DeclarationCreation", string);
                                    continue;
                                }
                                try {
                                    AnnotationTypeDeclaration annotationTypeDeclaration = (AnnotationTypeDeclaration)pattern;
                                    hashSet.add(annotationTypeDeclaration);
                                }
                                catch (ClassCastException classCastException) {
                                    bark.error(0, "BadDeclaration", string);
                                }
                            }
                        }
                        linkedHashSet4.add(object2.getClass());
                        set.add(object2.getClass());
                        object.put(object2, hashSet);
                    } else if (set.contains(object2.getClass())) {
                        linkedHashSet4.add(object2.getClass());
                        object.put(object2, set2);
                    }
                    if (linkedHashSet3.size() != 0) continue;
                    break;
                }
                catch (ClassCastException classCastException) {
                    bark.warning(0, "BadFactory", classCastException);
                }
            }
            linkedHashSet3.remove("");
            set3 = new LinkedHashSet<Class<? extends AnnotationProcessorFactory>>(set);
            set3.removeAll(linkedHashSet4);
            for (Serializable serializable2 : set3) {
                try {
                    object2 = (AnnotationProcessorFactory)((Class)serializable2).newInstance();
                    object.put(object2, set2);
                }
                catch (Exception exception) {
                    bark.warning(0, "FactoryCantInstantiate", ((Class)serializable2).getName());
                }
                catch (Throwable throwable) {
                    throw new AnnotationProcessingError(throwable);
                }
            }
            if (linkedHashSet3.size() > 0) {
                bark.warning(0, "AnnotationsWithoutProcessors", linkedHashSet3);
            }
            set3 = new LinkedHashSet<Serializable>();
            if (linkedHashSet.size() == 0 && object.keySet().size() == 0) {
                throw new UsageMessageNeededException();
            }
            try {
                for (Serializable serializable2 : object.keySet()) {
                    object2 = serializable2.getProcessorFor((Set)object.get(serializable2), annotationProcessorEnvironmentImpl);
                    if (object2 != null) {
                        set3.add((Serializable)object2);
                        continue;
                    }
                    bark.warning(0, "NullProcessor", serializable2.getClass().getName());
                }
            }
            catch (Throwable throwable) {
                throw new AnnotationProcessingError(throwable);
            }
            object3 = new LinkedList();
            ((LinkedList)object3).addAll(set3);
            serializable2 = AnnotationProcessors.getCompositeAnnotationProcessor((Collection)object3);
            try {
                serializable2.process();
            }
            catch (Throwable throwable) {
                throw new AnnotationProcessingError(throwable);
            }
            annotationProcessorEnvironmentImpl.roundComplete();
            object2 = (FilerImpl)annotationProcessorEnvironmentImpl.getFiler();
            this.genSourceFileNames = ((FilerImpl)object2).getSourceFileNames();
            this.genClassFileNames = ((FilerImpl)object2).getClassFileNames();
            ((FilerImpl)object2).flush();
        }
    }

    Pattern importStringToPattern(String string) {
        Object object;
        if (string.equals("*")) {
            return allMatches;
        }
        String string2 = string;
        boolean bl = false;
        boolean bl2 = true;
        int n = string2.indexOf(42);
        if (n != -1) {
            if (n == string2.length() - 1) {
                if (n - 1 >= 0) {
                    bl2 = string2.charAt(n - 1) == '.';
                    string2 = string2.substring(0, string2.length() - 2);
                }
            } else {
                bl2 = false;
            }
        }
        if (bl2) {
            for (String string3 : object = string2.split("\\.", string2.length() + 2)) {
                bl2 &= DeclarationMaker.isJavaIdentifier(string3);
            }
        }
        if (!bl2) {
            object = Bark.instance(this.context);
            object.warning(0, "MalformedSupportedString", string);
            return noMatches;
        }
        object = string.replaceAll("\\.", "\\\\.");
        if (object.endsWith("*")) {
            object = object.substring(0, object.length() - 1) + ".+";
        }
        return Pattern.compile((String)object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AptTreeScanner
    extends TreeScanner {
        private Set<String> annotationSet = new LinkedHashSet<String>();
        private Collection<Symbol.ClassSymbol> specifiedDeclCollection = new LinkedHashSet<Symbol.ClassSymbol>();
        private Collection<Symbol.ClassSymbol> declCollection = new LinkedHashSet<Symbol.ClassSymbol>();

        public Set<String> getAnnotationSet() {
            return this.annotationSet;
        }

        @Override
        public void visitTopLevel(Tree.TopLevel topLevel) {
            super.visitTopLevel(topLevel);
            for (Tree tree : topLevel.defs) {
                if (!(tree instanceof Tree.ClassDef)) continue;
                this.specifiedDeclCollection.add(((Tree.ClassDef)tree).sym);
            }
        }

        @Override
        public void visitBlock(Tree.Block block) {
        }

        @Override
        public void visitClassDef(Tree.ClassDef classDef) {
            if (classDef.sym == null) {
                return;
            }
            super.visitClassDef(classDef);
            this.declCollection.add(classDef.sym);
        }

        @Override
        public void visitMethodDef(Tree.MethodDef methodDef) {
            super.visitMethodDef(methodDef);
        }

        @Override
        public void visitVarDef(Tree.VarDef varDef) {
            super.visitVarDef(varDef);
        }

        @Override
        public void visitAnnotation(Tree.Annotation annotation) {
            super.visitAnnotation(annotation);
            this.annotationSet.add(annotation.type.tsym.toString());
        }
    }
}

