/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.indexsupport;

import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.j9.Builder;
import com.ibm.dtfj.image.j9.BytecodeImageSection;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.image.j9.IFileLocationResolver;
import com.ibm.dtfj.image.j9.Image;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import com.ibm.dtfj.image.j9.ImageProcess;
import com.ibm.dtfj.image.j9.JitImageSection;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaArrayClass;
import com.ibm.dtfj.java.j9.JavaClass;
import com.ibm.dtfj.java.j9.JavaClassLoader;
import com.ibm.dtfj.java.j9.JavaHeap;
import com.ibm.dtfj.java.j9.JavaInstanceField;
import com.ibm.dtfj.java.j9.JavaMethod;
import com.ibm.dtfj.java.j9.JavaMonitor;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import com.ibm.dtfj.java.j9.JavaStackFrame;
import com.ibm.dtfj.java.j9.JavaStaticField;
import com.ibm.dtfj.java.j9.JavaThread;
import com.ibm.dtfj.java.j9.JavaVMInitArgs;
import com.ibm.dtfj.java.j9.JavaVMOption;
import com.ibm.dtfj.java.j9.TraceBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLIndexReader
extends DefaultHandler {
    private ICoreFileReader _coreFile;
    private Image _coreImage;
    private Stack _elements;
    private ImageAddressSpace _tempAddressSpace;
    private ImageProcess _tempProc;
    private JavaRuntime _currentRuntime;
    private JavaClass _currentClass;
    private TraceBuffer _currentTraceBuffer;
    private JavaHeap _currentHeap;
    private JavaThread _currentVMThread;
    private JavaVMInitArgs _currentInitArgs;
    private String _vmVersion;
    private HashMap _methodsByID = new HashMap();
    private HashMap _monitorsByID = new HashMap();
    private HashMap _blockedThreadsByMonitorID = new HashMap();
    private HashMap _waitingThreadsByMonitorID = new HashMap();
    private StringBuffer _scrapingBuffer;
    private IFileLocationResolver _fileResolvingAgent;
    private ClosingFileReader _reader;

    public Image parseIndexWithDump(InputStream inputStream, ICoreFileReader iCoreFileReader, ClosingFileReader closingFileReader, IFileLocationResolver iFileLocationResolver) {
        this._fileResolvingAgent = iFileLocationResolver;
        this._elements = new Stack();
        this._coreFile = iCoreFileReader;
        this._reader = closingFileReader;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)this);
            this._postProcess();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this._coreImage;
    }

    private void _postProcess() {
        for (Long l : this._monitorsByID.keySet()) {
            JavaMonitor javaMonitor = (JavaMonitor)this._monitorsByID.get(l);
            Vector vector = (Vector)this._blockedThreadsByMonitorID.get(l);
            Vector vector2 = (Vector)this._waitingThreadsByMonitorID.get(l);
            if (null != vector) {
                javaMonitor.setBlockedThreads(vector);
            }
            if (null == vector2) continue;
            javaMonitor.setWaitingThreads(vector2);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object = "spacer";
        long l = this._longFromString(attributes.getValue("id"));
        if (string3.equals("j9dump")) {
            String string4 = attributes.getValue("osname");
            String string5 = attributes.getValue("osversion");
            String string6 = attributes.getValue("arch");
            this._vmVersion = attributes.getValue("version");
            int n = Integer.parseInt(attributes.getValue("size"));
            int n2 = Integer.parseInt(attributes.getValue("cpus"));
            long l2 = Long.parseLong(attributes.getValue("memory"));
            long l3 = this._longFromString(attributes.getValue("environ"));
            Builder builder = new Builder(this._coreFile, this._reader, l3, this._fileResolvingAgent);
            this._coreFile.extract(builder);
            String string7 = builder.getCPUSubType();
            long l4 = builder.getCreationTime();
            this._coreImage = new Image(string4, string5, string6, string7, n2, l2, l4);
            this._tempAddressSpace = (ImageAddressSpace)builder.getAddressSpaces().next();
            this._tempProc = (ImageProcess)this._tempAddressSpace.getCurrentProcess();
            this._coreImage.addAddressSpace(this._tempAddressSpace);
            if (null != this._tempProc && this._tempProc.getPointerSize() != n) {
                System.err.println("WARNING:  XML and core file pointer sizes differ");
            }
            object = this._coreImage;
        } else if (string3.equals("javavm")) {
            ImagePointer imagePointer = this._tempAddressSpace.getPointer(l);
            this._currentRuntime = new JavaRuntime(imagePointer, this._vmVersion);
            if (null != this._tempProc) {
                this._tempProc.addRuntime(this._currentRuntime);
            }
            object = this._currentRuntime;
        } else if (string3.equals("javavminitargs")) {
            if (this._elements.peek() == this._currentRuntime) {
                boolean bl = "true".equals(attributes.getValue("ignoreunrecognized"));
                int n = (int)this._longFromString(attributes.getValue("version"));
                this._currentInitArgs = new JavaVMInitArgs(n, bl);
                this._currentRuntime.setJavaVMInitArgs(this._currentInitArgs);
                object = this._currentInitArgs;
            }
        } else if (string3.equals("javavmoption")) {
            if (this._elements.peek() == this._currentInitArgs) {
                String string8 = attributes.getValue("optionstring");
                long l5 = this._longFromString(attributes.getValue("extrainfo"));
                this._currentInitArgs.addOption(new JavaVMOption(string8, this._tempAddressSpace.getPointer(l5)));
            }
        } else if (string3.equals("jit")) {
            if (this._elements.peek() instanceof JavaMethod) {
                long l6 = this._longFromString(attributes.getValue("start"));
                long l7 = this._longFromString(attributes.getValue("end"));
                long l8 = l7 - l6;
                JitImageSection jitImageSection = new JitImageSection(this._tempAddressSpace.getPointer(l), this._tempAddressSpace.getPointer(l6), l8);
                ((JavaMethod)this._elements.peek()).addCompiledSection(jitImageSection);
            }
        } else if (string3.equals("class")) {
            if (this._elements.peek() == this._currentRuntime) {
                JavaClass javaClass;
                long l9 = this._longFromString(attributes.getValue("super"));
                String string9 = attributes.getValue("name");
                int n = Integer.parseInt(attributes.getValue("instanceSize"));
                long l10 = this._longFromString(attributes.getValue("loader"));
                long l11 = this._longFromString(attributes.getValue("modifiers"));
                String string10 = attributes.getValue("source");
                this._currentClass = javaClass = new JavaClass(this._currentRuntime, this._tempAddressSpace.getPointer(l), l9, string9, n, l10, (int)l11, string10);
                this._currentRuntime.addClass(javaClass);
                object = javaClass;
            } else if (this._elements.peek().equals("constantpool")) {
                this._currentClass.addConstantPoolClassRef(l);
            } else if (this._elements.peek() instanceof JavaClassLoader) {
                JavaClassLoader javaClassLoader = (JavaClassLoader)this._elements.peek();
                javaClassLoader.addClassID(l);
            }
        } else if (string3.equals("arrayclass")) {
            long l12 = this._longFromString(attributes.getValue("leaf"));
            int n = Integer.parseInt(attributes.getValue("arity"));
            long l13 = this._longFromString(attributes.getValue("modifiers"));
            int n3 = Integer.parseInt(attributes.getValue("firstElementOffset"));
            int n4 = Integer.parseInt(attributes.getValue("sizeOffset"));
            int n5 = Integer.parseInt(attributes.getValue("sizeBytes"));
            long l14 = this._longFromString(attributes.getValue("loader"));
            JavaArrayClass javaArrayClass = new JavaArrayClass(this._currentRuntime, this._tempAddressSpace.getPointer(l), (int)l13, n4, n5, n3, l12, n, l14);
            this._currentRuntime.addClass(javaArrayClass);
            object = javaArrayClass;
        } else if (string3.equals("monitor")) {
            String string11 = attributes.getValue("name");
            long l15 = this._longFromString(attributes.getValue("object"));
            long l16 = this._longFromString(attributes.getValue("owner"));
            JavaObject javaObject = null;
            if (0L != l15) {
                javaObject = JavaObject.createJavaObject(this._currentRuntime, this._tempAddressSpace.getPointer(l15));
            }
            JavaMonitor javaMonitor = new JavaMonitor(this._currentRuntime, this._tempAddressSpace.getPointer(l), string11, javaObject, l16);
            this._monitorsByID.put(new Long(l), javaMonitor);
            this._currentRuntime.addMonitor(javaMonitor);
            object = javaMonitor;
        } else if (string3.equals("heap")) {
            String string12 = attributes.getValue("name");
            long l17 = this._longFromString(attributes.getValue("start"));
            long l18 = this._longFromString(attributes.getValue("end"));
            int n = Integer.parseInt(attributes.getValue("objectAlignment"));
            int n6 = Integer.parseInt(attributes.getValue("minimumObjectSize"));
            this._currentHeap = new JavaHeap(this._currentRuntime, string12, n, n6, this._tempAddressSpace.getPointer(l17), l18 - l17);
            this._currentRuntime.addHeap(this._currentHeap);
            object = this._currentHeap;
        } else if (string3.equals("method")) {
            JavaClass javaClass = (JavaClass)this._elements.peek();
            String string13 = attributes.getValue("name");
            String string14 = attributes.getValue("sig");
            long l19 = this._longFromString(attributes.getValue("modifiers"));
            JavaMethod javaMethod = new JavaMethod(this._tempAddressSpace.getPointer(l), string13, string14, (int)l19, javaClass);
            this._methodsByID.put(new Long(l), javaMethod);
            javaClass.addMethod(javaMethod);
            object = javaMethod;
        } else if (string3.equals("vmthread")) {
            Object object2;
            Object object3;
            long l20 = this._longFromString(attributes.getValue("obj"));
            String string15 = attributes.getValue("state");
            long l21 = this._longFromString(attributes.getValue("monitor"));
            String string16 = attributes.getValue("native");
            ImageThread imageThread = null;
            try {
                if (null != this._tempProc) {
                    object3 = this._tempProc.getThreads();
                    while (object3.hasNext()) {
                        object2 = (ImageThread)object3.next();
                        if (Long.decode(object2.getID()).longValue() != this._longFromString(string16)) continue;
                        imageThread = object2;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._currentVMThread = new JavaThread(this._currentRuntime, this._tempAddressSpace.getPointer(l), this._tempAddressSpace.getPointer(l20), string15, l21, imageThread);
            this._currentRuntime.addThread(this._currentVMThread);
            if (0L != l21) {
                object3 = new Long(l21);
                if (string15.equals("Blocked")) {
                    object2 = (Vector)this._blockedThreadsByMonitorID.get(object3);
                    if (null == object2) {
                        object2 = new Vector();
                        this._blockedThreadsByMonitorID.put(object3, object2);
                    }
                    object2.add(this._currentVMThread);
                } else if (string15.equals("Waiting")) {
                    object2 = (Vector)this._waitingThreadsByMonitorID.get(object3);
                    if (null == object2) {
                        object2 = new Vector();
                        this._waitingThreadsByMonitorID.put(object3, object2);
                    }
                    object2.add(this._currentVMThread);
                }
            }
            object = this._currentVMThread;
        } else if (string3.equals("interface")) {
            JavaAbstractClass javaAbstractClass = (JavaAbstractClass)this._elements.peek();
            String string17 = attributes.getValue("name");
            javaAbstractClass.addInterfaceName(string17);
            object = string17;
        } else if (string3.equals("classloader")) {
            long l22 = this._longFromString(attributes.getValue("obj"));
            JavaClassLoader javaClassLoader = new JavaClassLoader(this._currentRuntime, this._tempAddressSpace.getPointer(l), this._tempAddressSpace.getPointer(l22));
            this._currentRuntime.addClassLoader(javaClassLoader);
            object = javaClassLoader;
        } else if (string3.equals("bytecode")) {
            long l23 = this._longFromString(attributes.getValue("start"));
            long l24 = this._longFromString(attributes.getValue("end"));
            long l25 = l24 - l23;
            BytecodeImageSection bytecodeImageSection = new BytecodeImageSection(this._tempAddressSpace.getPointer(l23), l25);
            ((JavaMethod)this._elements.peek()).addBytecodeSection(bytecodeImageSection);
        } else if (string3.equals("field")) {
            long l26 = this._longFromString(attributes.getValue("class"));
            JavaClass javaClass = (JavaClass)this._elements.peek();
            if (javaClass.getID().getAddress() == l26) {
                String string18 = attributes.getValue("name");
                String string19 = attributes.getValue("sig");
                long l27 = this._longFromString(attributes.getValue("modifiers"));
                int n = Integer.parseInt(attributes.getValue("offset"));
                JavaInstanceField javaInstanceField = new JavaInstanceField(this._currentRuntime, string18, string19, (int)l27, n, l26);
                ((JavaClass)this._elements.peek()).addField(javaInstanceField);
            }
        } else if (string3.equals("static")) {
            String string20 = attributes.getValue("name");
            String string21 = attributes.getValue("sig");
            long l28 = this._longFromString(attributes.getValue("modifiers"));
            String string22 = attributes.getValue("value");
            if (string22.startsWith("0x")) {
                string22 = string22.substring(2);
            }
            JavaClass javaClass = (JavaClass)this._elements.peek();
            JavaStaticField javaStaticField = new JavaStaticField(this._currentRuntime, string20, string21, (int)l28, string22, javaClass.getID().getAddress());
            javaClass.addField(javaStaticField);
        } else if (string3.equals("constantpool")) {
            object = "constantpool";
        } else if (string3.equals("object")) {
            JavaObject javaObject = JavaObject.createJavaObject(this._currentRuntime, this._tempAddressSpace.getPointer(l));
            this._currentClass.addConstantPoolObjectRef(javaObject);
        } else if (string3.equals("trace")) {
            this._currentTraceBuffer = new TraceBuffer();
            this._currentRuntime.setTraceBufferForName(this._currentTraceBuffer, "trace");
        } else if (string3.equals("header")) {
            ImagePointer imagePointer = this._tempAddressSpace.getPointer(this._longFromString(attributes.getValue("address")));
            long l29 = Long.parseLong(attributes.getValue("size"));
            this._currentTraceBuffer.setHeader(imagePointer, l29);
        } else if (string3.equals("buffers")) {
            ImagePointer imagePointer = this._tempAddressSpace.getPointer(this._longFromString(attributes.getValue("address")));
            long l30 = Long.parseLong(attributes.getValue("size"));
            int n = Integer.parseInt(attributes.getValue("offset"));
            int n7 = Integer.parseInt(attributes.getValue("link"));
            int n8 = (int)this._longFromString(attributes.getValue("terminator"));
            this._currentTraceBuffer.setBuffer(imagePointer, l30, n, n7, n8);
        } else if (string3.equals("objects")) {
            long l31 = this._longFromString(attributes.getValue("start"));
            long l32 = this._longFromString(attributes.getValue("end"));
            int n = Integer.parseInt(attributes.getValue("count"));
            ImagePointer imagePointer = this._tempAddressSpace.getPointer(l31);
            int n9 = (int)(l32 - l31);
            this._currentHeap.addExtent(imagePointer, n9, n);
        } else if (string3.equals("stack")) {
            long l33 = this._longFromString(attributes.getValue("start"));
            long l34 = this._longFromString(attributes.getValue("end"));
            this._currentVMThread.setStackSection(l33, l34 - l33);
        } else if (string3.equals("frame")) {
            long l35 = this._longFromString(attributes.getValue("method"));
            long l36 = this._longFromString(attributes.getValue("pc"));
            long l37 = this._longFromString(attributes.getValue("arguments"));
            int n = -1;
            if (attributes.getValue("line") != null) {
                try {
                    n = Integer.parseInt(attributes.getValue("line"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            JavaStackFrame javaStackFrame = new JavaStackFrame(this._tempAddressSpace.getPointer(l37), (JavaMethod)this._methodsByID.get(new Long(l35)), this._tempAddressSpace.getPointer(l36), n);
            this._currentVMThread.addFrame(javaStackFrame);
        } else if (string3.equals("property")) {
            String string23 = attributes.getValue("key");
            String string24 = attributes.getValue("value");
            if (string23 != null && string24 != null) {
                this._currentRuntime.setSystemProperty(string23, string24);
            }
        } else if (string3.equals("gpf")) {
            long l38 = this._longFromString(attributes.getValue("nativeFailingThread"));
            if (null != this._tempProc) {
                this._tempProc.setFaultingThreadID(l38);
            }
            this._scrapingBuffer = new StringBuffer();
            object = "gpf";
        } else if (string3.equals("net")) {
            String string25 = attributes.getValue("hostname");
            this._coreImage.setHostName(string25);
        } else if (string3.equals("ip")) {
            String string26 = attributes.getValue("address");
            Object object4 = null;
            try {
                object4 = InetAddress.getByName(string26);
            }
            catch (UnknownHostException unknownHostException) {
                object4 = new CorruptData("IP cannot be parsed: \"" + string26 + "\"", null);
            }
            this._coreImage.addIPAddress(object4);
        }
        this._elements.push(object);
    }

    private long _longFromString(String string) {
        long l = 0L;
        if (null != string) {
            if (string.startsWith("0x")) {
                string = string.substring(2);
            }
            if (16 == string.length()) {
                String string2 = string.substring(0, 8);
                String string3 = string.substring(8, 16);
                long l2 = Long.parseLong(string2, 16);
                long l3 = Long.parseLong(string3, 16);
                l = l2 << 32 | l3;
            } else {
                l = Long.parseLong(string, 16);
            }
        }
        return l;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this._elements.peek().equals("gpf")) {
            String string4 = this._scrapingBuffer.toString();
            int n = (int)this._longByResolvingRawKey(string4, "Signal_Number");
            if (null != this._tempProc) {
                this._tempProc.setSignalNumber(n);
            }
        }
        this._scrapingBuffer = null;
        this._elements.pop();
    }

    private long _longByResolvingRawKey(String string, String string2) {
        int n;
        long l = 0L;
        int n2 = string.indexOf(string2);
        while (n2 > 0 && !Character.isWhitespace(string.charAt(n2 - 1))) {
            n2 = string.indexOf(string2, n2 + 1);
        }
        if (n2 >= 0 && (n = string.indexOf("=", n2)) > n2) {
            int n3;
            for (n3 = n + 1; n3 < string.length() && !Character.isWhitespace(string.charAt(n3)); ++n3) {
            }
            String string3 = string.substring(n + 1, n3);
            l = Long.parseLong(string3, 16);
        }
        return l;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (null != this._scrapingBuffer) {
            this._scrapingBuffer.append(cArray, n, n2);
        }
    }
}

