/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.extract;

import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.DeprecatedCoreAPI;
import com.ibm.dtfj.corereaders.Dump;
import com.ibm.dtfj.corereaders.DumpFactory;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Main {
    private String _dumpName = null;
    private File _virtualRootDirectory = null;
    private ICoreFileReader _dump = null;
    private static final String J9_LIB_NAME = "j9jextract";
    private static final int ZIP_BUFFER_SIZE = 32768;
    private static boolean TEST_WITHOUT_EXTRACTING = false;

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        File file = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        if (stringArray.length <= 0) {
            Main.printHelpAndExitWith(0);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!bl && stringArray[i].startsWith("-")) {
                File file2;
                if ("--".equals(stringArray[i])) {
                    bl = true;
                    continue;
                }
                if ("-interactive".equals(stringArray[i])) {
                    bl2 = true;
                    continue;
                }
                if ("-help".equals(stringArray[i])) {
                    Main.printHelpAndExitWith(0);
                    continue;
                }
                if ("-nozip".equals(stringArray[i]) || "-nojar".equals(stringArray[i])) {
                    bl3 = false;
                    continue;
                }
                if ("-f".equals(stringArray[i])) {
                    Main.ensure(++i < stringArray.length && !stringArray[i].startsWith("-"), "Syntax error: -f option specified but no file following");
                    file2 = new File(stringArray[i]);
                    Main.ensure(file2.exists() && file2.canRead(), "File specified using -f option (\"" + stringArray[i] + "\") not found.");
                    continue;
                }
                if ("-p".equals(stringArray[i])) {
                    Main.ensure(++i < stringArray.length && !stringArray[i].startsWith("-"), "Syntax error: -p option specified but no virtual root directory given");
                    file2 = new File(stringArray[i]);
                    Main.ensure(file2.exists() && file2.canRead() && file2.isDirectory(), "Virtual directory specified using -p option (\"" + stringArray[i] + "\") does not exist as a readable directory.");
                    file = new File(stringArray[i]);
                    continue;
                }
                Main.error("Unrecognized option: " + stringArray[i]);
                continue;
            }
            if (string == null) {
                string = stringArray[i];
                continue;
            }
            if (string2 == null) {
                string2 = stringArray[i];
                continue;
            }
            Main.error("Too many file arguments: " + stringArray[i]);
        }
        Main.ensure(null != string, "No dump file specified");
        Main main = new Main(string, file);
        if (bl2) {
            main.runInteractive();
        } else {
            main.runJextract(string2, bl3);
        }
    }

    private static void ensure(boolean bl, String string) {
        if (!bl) {
            Main.error(string);
        }
    }

    private static void error(String string) {
        Main.report(string);
        Main.printHelpAndExitWith(-1);
    }

    private static void fail(String string) {
        Main.report(string);
        System.exit(-1);
    }

    private static void chuck(String string) throws Exception {
        throw new Exception(string);
    }

    private static void failWithStackTrace(String string, Throwable throwable) {
        Main.report(string);
        throwable.printStackTrace();
        System.exit(-1);
    }

    private Main(String string, File file) {
        this._dumpName = string;
        this._virtualRootDirectory = file;
        if (TEST_WITHOUT_EXTRACTING) {
            return;
        }
        try {
            System.loadLibrary(J9_LIB_NAME);
        }
        catch (SecurityException securityException) {
            Main.fail("Error. Security permissions don't allow required native library to be loaded.");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Main.fail("Error. Native library j9jextract cannot be found. Please check your path.");
        }
        catch (Exception exception) {
            Main.failWithStackTrace("Error. Unexpected exception occurred loading: j9jextract", exception);
        }
        Main.report("Loading dump file...");
        File file2 = new File(string);
        try {
            ClosingFileReader closingFileReader = new ClosingFileReader(file2);
            this._dump = DumpFactory.createDumpForCore(closingFileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!file2.exists()) {
                Main.fail("Error. Could not find dump file: " + string);
            } else if (!file2.canRead()) {
                Main.fail("Error. Unable to read dump file (check permission): " + string);
            } else {
                Main.failWithStackTrace("Error. Unexpected FileNotFoundException occurred opening: " + string, fileNotFoundException);
            }
        }
        catch (Exception exception) {
            Main.failWithStackTrace("Error. Unexpected Exception occurred opening: " + string, exception);
        }
        if (null == this._dump) {
            Main.fail("Error. Dump type not recognised for dump: " + string);
        }
        Main.report("Read memory image from " + this._dumpName);
    }

    private void runJextract(String string, boolean bl) {
        try {
            String string2 = null;
            string2 = null != string && false == bl ? string : this._dumpName.concat(".xml");
            File file = new File(string2);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!file.canWrite()) {
                Main.fail("Error. Unable to write to \"" + string2 + "\" (check permission)");
            }
            DummyBuilder dummyBuilder = new DummyBuilder(this._virtualRootDirectory);
            this._dump.extract(dummyBuilder);
            if (!TEST_WITHOUT_EXTRACTING) {
                try {
                    this.doJextract(this._dump.getAddressSpace(), string2);
                }
                catch (Throwable throwable) {
                    Main.report(throwable.getMessage());
                    Main.fail("Failure detected during jextract, see previous message(s).");
                }
            }
            if (bl) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(this._dumpName);
                arrayList.add(string2);
                Object object = this._dump.getAdditionalFileNames();
                while (object.hasNext()) {
                    arrayList.add((String)object.next());
                }
                try {
                    String string3;
                    object = System.getProperty("java.home") + File.separator + "lib" + File.separator;
                    String string4 = (String)object + "TraceFormat.dat";
                    if (new File(string4).exists()) {
                        arrayList.add(string4);
                    }
                    if (new File(string3 = (String)object + "J9TraceFormat.dat").exists()) {
                        arrayList.add(string3);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Main.createZipFromFileNames(null != string ? string : this._dumpName.concat(".zip"), arrayList.iterator(), dummyBuilder);
                file.deleteOnExit();
            }
            Main.report("jextract complete.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Main.report(exception.getMessage());
            Main.report("jextract failed.");
        }
    }

    private void runInteractive() {
        Main.report("Jextract interactive mode.");
        Main.report("Type '!j9help' for help.");
        Main.report("Type 'quit' to quit.");
        Main.report("(Commands must be prefixed with '!')");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        block4: while (true) {
            try {
                while (true) {
                    Main.report("> ");
                    String string = bufferedReader.readLine().trim();
                    if ("quit".equalsIgnoreCase(string) || "q".equalsIgnoreCase(string)) break block4;
                    try {
                        this.doCommand(this._dump.getAddressSpace(), string);
                        continue block4;
                    }
                    catch (Throwable throwable) {
                        Main.report(throwable.getMessage());
                        Main.report("Failure detected during command execution, see previous message(s).");
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                Main.report("Error reading input.");
                break;
            }
        }
    }

    private static void report(String string) {
        System.out.println(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createZipFromFileNames(String string, Iterator iterator, Builder builder) throws Exception {
        Main.report("Creating zip file: " + string);
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            byte[] byArray = new byte[32768];
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                try {
                    ClosingFileReader closingFileReader = builder.openFile(string2);
                    String string3 = closingFileReader.getAbsolutePath();
                    if (string3.equals(new File(string2).getAbsolutePath())) {
                        Main.report("Adding \"" + string2 + "\" to zip");
                    } else {
                        Main.report("Adding \"" + string2 + "\" to zip (found at \"" + string3 + "\")");
                    }
                    InputStream inputStream = closingFileReader.streamFromFile();
                    zipOutputStream.putNextEntry(new ZipEntry(string2));
                    Main.copy(inputStream, zipOutputStream, byArray);
                    inputStream.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Main.report("Warning:  Could not find file \"" + string2 + "\" for inclusion in zip file.  This will limit the usefulness of the zip file.");
                }
                catch (IOException iOException) {
                    Main.chuck("Failure adding file to zip file (" + string2 + ") : " + iOException.getMessage());
                }
                finally {
                    zipOutputStream.closeEntry();
                }
            }
            try {
                zipOutputStream.close();
            }
            catch (IOException iOException) {
                Main.chuck("Failure closing zip file (" + string + ") : " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Main.chuck("Could not find zip file to output to: " + fileNotFoundException.getMessage());
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n = inputStream.read(byArray);
        while (n != -1) {
            outputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
    }

    private native void doJextract(DeprecatedCoreAPI var1, String var2) throws Exception;

    private native void doCommand(DeprecatedCoreAPI var1, String var2) throws Exception;

    private static void printHelpAndExitWith(int n) {
        Main.report("Usage: jextract [dump_name] [output filename] [[options]");
        Main.report(" output filename defaults to {dump_name}.zip");
        Main.report("    or {dump_name}.xml if -nozip option specified");
        Main.report(" options:");
        Main.report("   -help         print this screen");
        Main.report("   -nozip        don't create a zip");
        System.exit(n);
    }

    private static class DummyBuilder
    implements Builder {
        private File _virtualRootDirectory = null;
        private Vector _successfulSearchPaths = new Vector();

        public DummyBuilder(File file) {
            this._virtualRootDirectory = file;
        }

        public Object buildProcess(Object object, String string, String string2, Properties properties, Object object2, Iterator iterator, Object object3, Iterator iterator2, int n) {
            return new Object();
        }

        public Object buildAddressSpace(String string, Dump dump, int n) {
            return new Object();
        }

        public Object buildRegister(String string, Number number) {
            return new Register(string, number.longValue());
        }

        public Object buildStackSection(Object object, long l, long l2) {
            return new Object();
        }

        public Object buildThread(String string, Iterator iterator, Iterator iterator2, Iterator iterator3, Properties properties, int n) {
            return new Object();
        }

        public Object buildModuleSection(Object object, String string, long l, long l2) {
            return new Object();
        }

        public Object buildModule(String string, Properties properties, Iterator iterator, Iterator iterator2) {
            return new Object();
        }

        public long getEnvironmentAddress() {
            return 0L;
        }

        public long getValueOfNamedRegister(List list, String string) {
            for (Register register : list) {
                if (!string.equals(register.name)) continue;
                return register.value;
            }
            return -1L;
        }

        public Object buildStackFrame(Object object, long l, long l2) {
            return new Object();
        }

        public ClosingFileReader openFile(String string) throws FileNotFoundException {
            File file;
            Object object;
            Object object2;
            File file2 = new File(string);
            if (null != this._virtualRootDirectory && file2.isAbsolute()) {
                file2 = this.sysFileRelative(this._virtualRootDirectory, file2);
            } else if (!file2.isAbsolute() && !file2.exists()) {
                object2 = this._successfulSearchPaths.iterator();
                object = file2.getName();
                while (object2.hasNext()) {
                    file = (File)object2.next();
                    File file3 = new File(file, (String)object);
                    if (!file3.exists()) continue;
                    ClosingFileReader closingFileReader = new ClosingFileReader(file3);
                    return closingFileReader;
                }
            }
            if (file2.exists()) {
                object2 = new ClosingFileReader(file2);
                object = file2.getParentFile();
                if (null != object && !this._successfulSearchPaths.contains(file = ((File)object).getAbsoluteFile())) {
                    this._successfulSearchPaths.add(file);
                }
                return object2;
            }
            throw new FileNotFoundException("\"" + string + "\" not found in any known search path");
        }

        private File sysFileRelative(File file, File file2) {
            File file3 = file2;
            while (null != file3.getParentFile()) {
                file3 = file3.getParentFile();
            }
            File file4 = file2;
            if (file2.isAbsolute()) {
                String string = file2.getAbsolutePath().substring(file3.getAbsolutePath().length());
                file4 = new File(file, string);
            }
            return file4;
        }

        public Object buildSymbol(Object object, String string, long l) {
            return new Object();
        }

        public void setExecutableUnavailable(String string) {
        }

        public Object buildAddressSpace(String string, int n) {
            return new Object();
        }

        public void setCPUSubType(String string) {
        }

        public void setCreationTime(long l) {
        }

        public Object buildCorruptData(Object object, String string, long l) {
            return new Object();
        }

        private static class Register {
            final String name;
            final long value;

            Register(String string, long l) {
                this.name = string;
                this.value = l;
            }
        }
    }
}

