/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.j9.JavaLocation;
import com.ibm.dtfj.java.j9.JavaMethod;

public class JavaStackFrame
implements com.ibm.dtfj.java.JavaStackFrame {
    private ImagePointer _basePointer;
    private JavaMethod _method;
    private ImagePointer _pc;
    private int _lineNumber;

    public JavaStackFrame(ImagePointer imagePointer, JavaMethod javaMethod, ImagePointer imagePointer2, int n) {
        if (null == imagePointer) {
            throw new IllegalArgumentException("A Java stack frame must have a non-null base pointer");
        }
        if (null == javaMethod) {
            throw new IllegalArgumentException("A Java stack frame must refer to a non-null method");
        }
        if (null == imagePointer2) {
            throw new IllegalArgumentException("A Java stack frame must have a non-null program counter");
        }
        this._basePointer = imagePointer;
        this._method = javaMethod;
        this._pc = imagePointer2;
        this._lineNumber = n;
    }

    public ImagePointer getBasePointer() throws CorruptDataException {
        return this._basePointer;
    }

    public com.ibm.dtfj.java.JavaLocation getLocation() throws CorruptDataException {
        return new JavaLocation(this._method, this._pc, this._lineNumber);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaStackFrame) {
            JavaStackFrame javaStackFrame = (JavaStackFrame)object;
            bl = this._method.equals(javaStackFrame._method) && this._pc.equals(javaStackFrame._pc);
        }
        return bl;
    }

    public int hashCode() {
        return this._method.hashCode() ^ this._pc.hashCode();
    }
}

