/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaClass;
import com.ibm.dtfj.java.j9.JavaClassLoader;
import com.ibm.dtfj.java.j9.JavaHeap;
import com.ibm.dtfj.java.j9.JavaMethod;
import com.ibm.dtfj.java.j9.JavaMonitor;
import com.ibm.dtfj.java.j9.JavaThread;
import com.ibm.dtfj.java.j9.TraceBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class JavaRuntime
implements com.ibm.dtfj.java.JavaRuntime {
    private ImagePointer _address;
    private HashMap _classLoaders = new HashMap();
    private Vector _vmThreads = new Vector();
    private HashMap _classes = new HashMap();
    private Vector _monitors = new Vector();
    private Vector _heaps = new Vector();
    private HashMap _traceBuffers = new HashMap();
    private Properties _systemProperties = new Properties();
    private JavaVMInitArgs _javaVMInitArgs;
    private boolean _objectsShouldInferHash = false;

    public JavaRuntime(ImagePointer imagePointer, String string) {
        if (null == imagePointer) {
            throw new IllegalArgumentException("A Java Runtime cannot have a null base address");
        }
        this._address = imagePointer;
        this._objectsShouldInferHash = "2.2".equals(string) || "2.3".equals(string) || "2.4".equals(string);
    }

    public ImagePointer getJavaVM() throws CorruptDataException {
        return this._address;
    }

    public Iterator getJavaClassLoaders() {
        return this._classLoaders.values().iterator();
    }

    public Iterator getThreads() {
        return this._vmThreads.iterator();
    }

    public Iterator getCompiledMethods() {
        Iterator iterator = this._classes.values().iterator();
        Vector<JavaMethod> vector = new Vector<JavaMethod>();
        while (iterator.hasNext()) {
            JavaAbstractClass javaAbstractClass = (JavaAbstractClass)iterator.next();
            Iterator iterator2 = javaAbstractClass.getDeclaredMethods();
            while (iterator2.hasNext()) {
                JavaMethod javaMethod = (JavaMethod)iterator2.next();
                if (!javaMethod.getCompiledSections().hasNext()) continue;
                vector.add(javaMethod);
            }
        }
        return vector.iterator();
    }

    public Iterator getMonitors() {
        return this._monitors.iterator();
    }

    public Iterator getHeaps() {
        return this._heaps.iterator();
    }

    public Object getTraceBuffer(String string, boolean bl) throws CorruptDataException {
        return this._traceBuffers.get(string);
    }

    public String getFullVersion() throws CorruptDataException {
        return this.getVersion();
    }

    public String getVersion() throws CorruptDataException {
        String string = this.getRequiredSystemProperty("java.fullversion");
        String string2 = this.getRequiredSystemProperty("java.runtime.version");
        String string3 = this.getRequiredSystemProperty("java.runtime.name");
        String string4 = this.getRequiredSystemProperty("java.vm.name");
        String string5 = string3 + "(build " + string2 + ")\n";
        string5 = string5 + string4 + "(" + string + ")";
        return string5;
    }

    public void addClass(JavaAbstractClass javaAbstractClass) {
        long l = javaAbstractClass.getID().getAddress();
        this._classes.put(new Long(l), javaAbstractClass);
    }

    public void addClassLoader(JavaClassLoader javaClassLoader) {
        long l = javaClassLoader.getID();
        this._classLoaders.put(new Long(l), javaClassLoader);
    }

    public com.ibm.dtfj.java.JavaClass getClassForID(long l) {
        return (com.ibm.dtfj.java.JavaClass)this._classes.get(new Long(l));
    }

    public long getClassIDForClassName(String string) {
        long l = 0L;
        for (JavaClass javaClass : this._classes.values()) {
            try {
                if (!javaClass.getName().equals(string)) continue;
                l = javaClass.getID().getAddress();
                break;
            }
            catch (CorruptDataException corruptDataException) {
            }
        }
        return l;
    }

    public com.ibm.dtfj.java.JavaClassLoader getClassLoaderForID(long l) {
        return (com.ibm.dtfj.java.JavaClassLoader)this._classLoaders.get(new Long(l));
    }

    public void addMonitor(JavaMonitor javaMonitor) {
        this._monitors.add(javaMonitor);
    }

    public void addHeap(JavaHeap javaHeap) {
        this._heaps.add(javaHeap);
    }

    public void addThread(JavaThread javaThread) {
        this._vmThreads.add(javaThread);
    }

    public void setTraceBufferForName(TraceBuffer traceBuffer, String string) {
        this._traceBuffers.put(string, traceBuffer);
    }

    public String getSystemProperty(String string) {
        return this._systemProperties.getProperty(string);
    }

    public String getSystemProperty(String string, String string2) {
        return this._systemProperties.getProperty(string, string2);
    }

    String getRequiredSystemProperty(String string) throws CorruptDataException {
        String string2 = this.getSystemProperty(string);
        if (string2 == null) {
            throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("Required system property " + string + " not found in JExtract output", null));
        }
        return string2;
    }

    public void setSystemProperty(String string, String string2) {
        this._systemProperties.setProperty(string, string2);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaRuntime) {
            bl = this._address.equals(((JavaRuntime)object)._address);
        }
        return bl;
    }

    public int hashCode() {
        return this._address.hashCode();
    }

    public void setJavaVMInitArgs(JavaVMInitArgs javaVMInitArgs) {
        this._javaVMInitArgs = javaVMInitArgs;
    }

    public JavaVMInitArgs getJavaVMInitArgs() throws DataUnavailable, CorruptDataException {
        if (this._javaVMInitArgs == null) {
            throw new DataUnavailable("JavaVMInitArgs");
        }
        return this._javaVMInitArgs;
    }

    boolean objectShouldInferHash() {
        return this._objectsShouldInferHash;
    }
}

