/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Collections;
import java.util.Iterator;

public class JavaArrayClass
extends JavaAbstractClass {
    private int _sizeOffset;
    private int _bytesForSize;
    private int _firstElementOffset;
    private long _leafClassID;
    private int _dimension;

    public JavaArrayClass(JavaRuntime javaRuntime, ImagePointer imagePointer, int n, int n2, int n3, int n4, long l, int n5, long l2) {
        super(javaRuntime, imagePointer, n, l2);
        this._sizeOffset = n2;
        this._bytesForSize = n3;
        this._firstElementOffset = n4;
        this._leafClassID = l;
        this._dimension = n5;
    }

    public String getName() throws CorruptDataException {
        String string = "";
        for (int i = 0; i < this._dimension; ++i) {
            string = string + "[";
        }
        string = string + this.getComponentType().getName();
        return string;
    }

    public JavaClass getSuperclass() throws CorruptDataException {
        return null;
    }

    public boolean isArray() throws CorruptDataException {
        return true;
    }

    public JavaClass getComponentType() throws CorruptDataException {
        return this._javaVM.getClassForID(this._leafClassID);
    }

    public Iterator getDeclaredFields() {
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getDeclaredMethods() {
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getConstantPoolReferences() {
        return Collections.EMPTY_LIST.iterator();
    }

    public int getInstanceSize(JavaObject javaObject) {
        try {
            int n = javaObject.getArraySize();
            int n2 = this.getFirstElementOffset();
            int n3 = this._bytesPerElement();
            return n2 + n * n3;
        }
        catch (CorruptDataException corruptDataException) {
            return -1;
        }
    }

    private int _bytesPerElement() throws CorruptDataException {
        String string = this.getName().substring(1);
        int n = 0;
        if (string.equals("byte") || string.equals("boolean")) {
            n = 1;
        } else if (string.equals("char") || string.equals("short")) {
            n = 2;
        } else if (string.equals("float") || string.equals("int")) {
            n = 4;
        } else if (string.equals("double") || string.equals("long")) {
            n = 8;
        } else {
            ImageProcess imageProcess = this._classPointer.getAddressSpace().getCurrentProcess();
            if (null != imageProcess) {
                int n2 = imageProcess.getPointerSize();
                n = (n2 + 1) / 8;
            } else {
                throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("no current process", null));
            }
        }
        return n;
    }

    public int getFirstElementOffset() {
        return this._firstElementOffset;
    }

    public int getSizeOffset() {
        return this._sizeOffset;
    }

    public int getNumberOfSizeBytes() {
        return this._bytesForSize;
    }
}

