/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class ClosingFileReader {
    private static final int PAGE_SIZE = 4096;
    private static final int BUFFER_SIZE = 16384;
    private RandomAccessFile _file;
    private File _fileRef;
    private byte[] _buffer = new byte[16384];
    private long _bufferBase = -1L;
    private long _bufferEnd = -1L;
    private long _seekAddress = 0L;

    public ClosingFileReader(File file) throws FileNotFoundException {
        this._fileRef = file;
        this._file = new RandomAccessFile(this._fileRef, "r");
    }

    public byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    public int readInt() throws IOException {
        byte[] byArray = new byte[4];
        this.readFully(byArray);
        return (int)(((long)byArray[0] & 0xFFL) << 24 | ((long)byArray[1] & 0xFFL) << 16 | ((long)byArray[2] & 0xFFL) << 8 | (long)byArray[3] & 0xFFL);
    }

    public void seek(long l) throws IOException {
        this._seekAddress = l;
    }

    public long readLong() throws IOException {
        byte[] byArray = new byte[8];
        this.readFully(byArray);
        return ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
    }

    public short readShort() throws IOException {
        byte[] byArray = new byte[2];
        this.readFully(byArray);
        return (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
    }

    public byte readByte() throws IOException {
        byte[] byArray = new byte[1];
        this.readFully(byArray);
        return byArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this._file.close();
        }
        finally {
            super.finalize();
        }
    }

    public void readFully(byte[] byArray) throws IOException {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            int n2 = Math.min(this._buffer.length, byArray.length - i);
            n = this.readBufferMax(byArray, i, n2);
            if (0 != n) continue;
            break;
        }
    }

    private int readBufferMax(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (-1L == this._bufferBase) {
            this._recache();
        }
        long l = this._bufferBase;
        long l2 = this._bufferEnd;
        long l3 = this._seekAddress;
        long l4 = this._seekAddress + (long)n2;
        long l5 = Math.max(l, l3);
        long l6 = Math.min(l2, l4);
        if (l6 <= l5 || this._seekAddress < this._bufferBase) {
            this._recache();
            l = this._bufferBase;
            l2 = this._bufferEnd;
            l5 = Math.max(l, l3);
            l6 = Math.min(l2, l4);
        }
        int n4 = (int)(l5 - this._bufferBase);
        n3 = (int)(l6 - l5);
        System.arraycopy(this._buffer, n4, byArray, n, n3);
        this._seekAddress += (long)n3;
        return n3;
    }

    private void _recache() throws IOException {
        long l;
        long l2 = this._file.length();
        if (l2 > this._seekAddress) {
            l = this._seekAddress & 0xFFFFFFFFFFFFF000L;
            this._file.seek(l);
            try {
                this._file.readFully(this._buffer);
                this._bufferEnd = l + (long)this._buffer.length;
            }
            catch (EOFException eOFException) {
                this._bufferEnd = l2;
                this._file.seek(l);
                this._file.readFully(this._buffer, 0, (int)(this._bufferEnd - l));
            }
        } else {
            throw new EOFException("trying to cache beyond end of file");
        }
        this._bufferBase = l;
    }

    public void read(byte[] byArray) throws IOException {
        this.readFully(byArray);
    }

    public long length() throws IOException {
        return this._file.length();
    }

    public void close() throws IOException {
        this._file.close();
    }

    public InputStream streamFromFile() throws FileNotFoundException {
        return new FileInputStream(this._fileRef);
    }

    public String getAbsolutePath() {
        return this._fileRef.getAbsolutePath();
    }
}

