/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.binaryreaders;

import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class XCOFFReader {
    private static final short XCOFF_MAGIC_NUMBER_AIX32 = 479;
    private static final short XCOFF_MAGIC_NUMBER_AIX64_PRE43 = 495;
    private static final short XCOFF_MAGIC_NUMBER_AIX64_POST51 = 503;
    private ClosingFileReader _backing;
    private long _startOffset;
    private long _size;
    private boolean _is64Bit;
    private long _textSegmentOffset = -1L;
    private long _textSegmentSize = -1L;
    private long _sybolTableOffset = -1L;
    private long _timeAndDate = 0L;
    private short _flags = 0;
    private static final short F_RELFLG = 1;
    private static final short F_EXEC = 2;
    private static final short F_LNNO = 4;
    private static final short F_AR32W = 512;
    private static final short F_DYNLOAD = 4096;
    private static final short F_SHROBJ = 8192;
    private static final short F_LOADONLY = 16384;

    public XCOFFReader(ClosingFileReader closingFileReader, long l, long l2) throws IOException {
        this._startOffset = l;
        this._size = l2;
        this._backing = closingFileReader;
        this.seekFileRelative(0L);
        short s = this._backing.readShort();
        if (479 != s && 495 != s && 503 != s) {
            throw new IllegalArgumentException();
        }
        this._is64Bit = 495 == s || 503 == s;
        int n = this._backing.readShort();
        this._timeAndDate = 1000L * (0xFFFFFFFFL & (long)this._backing.readInt());
        this._sybolTableOffset = this._is64Bit ? this._backing.readLong() : 0xFFFFFFFFL & (long)this._backing.readInt();
        this.seekFileRelative(16L);
        short s2 = this._backing.readShort();
        this._flags = this._backing.readShort();
        long l3 = 20 + s2;
        for (int i = 0; i < n; ++i) {
            this.seekFileRelative(l3);
            byte[] byArray = new byte[8];
            this._backing.read(byArray);
            String string = new String(byArray);
            this.seekFileRelative(l3 + (long)(this._is64Bit ? 24 : 16));
            long l4 = this._is64Bit ? this._backing.readLong() : (long)this._backing.readInt();
            long l5 = this._is64Bit ? this._backing.readLong() : (long)this._backing.readInt();
            l3 += (long)(this._is64Bit ? 72 : 40);
            if (!string.startsWith(".text")) continue;
            this._textSegmentOffset = l5 + this._startOffset;
            this._textSegmentSize = l4;
        }
    }

    public XCOFFReader(ClosingFileReader closingFileReader) throws IOException {
        this(closingFileReader, 0L, closingFileReader.length());
    }

    public long getTextSegmentOffset() {
        return this._textSegmentOffset;
    }

    private void seekFileRelative(long l) throws IOException {
        this._backing.seek(this._startOffset + l);
    }

    public long getTextSegmentSize() {
        return this._textSegmentSize;
    }

    private long _symbolTableOffset() throws IOException {
        return this._sybolTableOffset;
    }

    private int _numberOfSymbols() throws IOException {
        this.seekFileRelative(this._is64Bit ? 20L : 12L);
        return this._backing.readInt();
    }

    private String _stringFromArray(byte[] byArray, int n) {
        int n2;
        for (n2 = n; n2 < byArray.length && 0 != byArray[n2]; ++n2) {
        }
        return new String(byArray, n, n2 - n);
    }

    public ClosingFileReader underlyingFile() {
        return this._backing;
    }

    public long baseFileOffset() {
        return this._startOffset;
    }

    public long logicalSize() {
        return this._size;
    }

    public Properties moduleProperties() {
        Properties properties = new Properties();
        properties.put("Time and Date", new Date(this._timeAndDate).toString());
        String string = (0 != (this._flags & 1) ? "F_RELFLG " : "") + (0 != (this._flags & 2) ? "F_EXEC " : "") + (0 != (this._flags & 4) ? "F_LNNO " : "") + (0 != (this._flags & 0x200) ? "F_AR32W " : "") + (0 != (this._flags & 0x1000) ? "F_DYNLOAD " : "") + (0 != (this._flags & 0x2000) ? "F_SHROBJ " : "") + (0 != (this._flags & 0x4000) ? "F_LOADONLY " : "");
        properties.put("Flags", string);
        return properties;
    }

    public List buildSymbols(Builder builder, Object object, long l) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        try {
            long l2 = this._symbolTableOffset();
            int n = this._numberOfSymbols();
            if (0L != l2) {
                this.seekFileRelative(l2 + (long)(18 * n));
                int n2 = this._backing.readInt();
                if (4 != n2 && 0 != n2) {
                    byte[] byArray = new byte[n2 - 4];
                    this._backing.readFully(byArray);
                    this.seekFileRelative(l2);
                    byte[] byArray2 = new byte[18];
                    int n3 = 0;
                    for (int i = 0; i < n; ++i) {
                        this._backing.readFully(byArray2);
                        if (n3 > 0) {
                            --n3;
                            continue;
                        }
                        int n4 = 0;
                        String string = null;
                        if (this._is64Bit) {
                            n4 = (0xFF & byArray2[8]) << 24 | (0xFF & byArray2[9]) << 16 | (0xFF & byArray2[10]) << 8 | 0xFF & byArray2[11];
                        } else if (0 == byArray2[0] && 0 == byArray2[1] && 0 == byArray2[2] && 0 == byArray2[3]) {
                            n4 = (0xFF & byArray2[4]) << 24 | (0xFF & byArray2[5]) << 16 | (0xFF & byArray2[6]) << 8 | 0xFF & byArray2[7];
                        } else {
                            string = this._stringFromArray(byArray2, 0);
                        }
                        if (null == string && 0 == (byArray2[16] & 0x80) && 0 != n4 && n4 < n2 - 4) {
                            string = this._stringFromArray(byArray, n4 - 4);
                        } else if (0 == (byArray2[16] & 0x80) && n4 > n2 - 4) {
                            string = "(string out of table bounds)";
                        }
                        if (null == string) {
                            string = "";
                        }
                        long l3 = 0L;
                        l3 = this._is64Bit ? (long)((0xFF & byArray2[0]) << 56 | (0xFF & byArray2[1]) << 48 | (0xFF & byArray2[2]) << 40 | (0xFF & byArray2[3]) << 32 | (0xFF & byArray2[4]) << 24 | (0xFF & byArray2[5]) << 16 | (0xFF & byArray2[6]) << 8 | 0xFF & byArray2[7]) : (long)((0xFF & byArray2[8]) << 24 | (0xFF & byArray2[9]) << 16 | (0xFF & byArray2[10]) << 8 | 0xFF & byArray2[11]);
                        linkedList.add(builder.buildSymbol(object, string, l3 + l));
                        n3 = byArray2[17];
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return linkedList;
    }
}

