/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.addressspace;

import com.ibm.dtfj.addressspace.CommonAddressSpace;
import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public class LayeredAddressSpace
extends CommonAddressSpace {
    private Stack _memoryRanges = new Stack();
    private Stack _files = new Stack();
    private IAbstractAddressSpace _base;

    public LayeredAddressSpace(IAbstractAddressSpace iAbstractAddressSpace, boolean bl, boolean bl2) {
        super(LayeredAddressSpace._extractRanges(iAbstractAddressSpace.getMemoryRanges()), bl, bl2);
        this._base = iAbstractAddressSpace;
    }

    private static MemoryRange[] _extractRanges(Iterator iterator) {
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            vector.add(iterator.next());
        }
        return vector.toArray(new MemoryRange[vector.size()]);
    }

    public Iterator getMemoryRanges() {
        return super.getMemoryRanges();
    }

    public boolean isExecutable(int n, long l) throws MemoryAccessException {
        return false;
    }

    public boolean isReadOnly(int n, long l) throws MemoryAccessException {
        return false;
    }

    public boolean isShared(int n, long l) throws MemoryAccessException {
        return false;
    }

    public int getBytesAt(int n, long l, byte[] byArray) throws MemoryAccessException {
        Iterator iterator = this._memoryRanges.iterator();
        Iterator iterator2 = this._files.iterator();
        try {
            return this._base.getBytesAt(n, l, byArray);
        }
        catch (MemoryAccessException memoryAccessException) {
            while (iterator.hasNext()) {
                MemoryRange memoryRange = (MemoryRange)iterator.next();
                Object e = iterator2.next();
                if (!memoryRange.contains(l)) continue;
                ClosingFileReader closingFileReader = (ClosingFileReader)e;
                try {
                    long l2 = memoryRange.getFileOffset() + (l - memoryRange.getVirtualAddress());
                    closingFileReader.seek(l2);
                    closingFileReader.readFully(byArray);
                    return byArray.length;
                }
                catch (IOException iOException) {
                    throw new MemoryAccessException(n, l);
                }
            }
            throw new MemoryAccessException(n, l);
        }
    }

    public void mapRegion(long l, ClosingFileReader closingFileReader, long l2, long l3) {
        MemoryRange memoryRange = new MemoryRange(l, l2, l3);
        this._memoryRanges.push(memoryRange);
        this._files.push(closingFileReader);
    }
}

