/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PublicKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPublicKey;
import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateCrtKey;

final class Signature {
    private MessageDigest msgdig;
    private PKCS11Session session;
    private PKCS11Object keyObject;
    private boolean isSign;
    private int mechanism;
    private int modSize = 256;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.Signature";
    private Provider provider;

    protected Signature(int n, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Signature", (Object)new Integer(n));
        }
        this.mechanism = n;
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.provider = provider;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "Signature");
        }
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineInitSign", (Object)privateKey);
        }
        this.isSign = true;
        PrivateKey privateKey2 = privateKey;
        if (!(privateKey instanceof RSAPrivateKey) && !(privateKey instanceof DSAPrivateKey)) {
            if (privateKey instanceof java.security.interfaces.RSAPrivateKey || privateKey instanceof RSAPrivateCrtKey || privateKey instanceof java.security.interfaces.DSAPrivateKey) {
                KeyFactory keyFactory = null;
                String string = privateKey.getAlgorithm();
                try {
                    if (string.equalsIgnoreCase("DSA")) {
                        keyFactory = KeyFactory.getInstance("DSA", this.provider);
                        privateKey2 = (PKCS11PrivateKey)keyFactory.translateKey(privateKey);
                    }
                    keyFactory = KeyFactory.getInstance("RSA", this.provider);
                    privateKey2 = (PKCS11PrivateKey)keyFactory.translateKey(privateKey);
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInitSign_1", (Throwable)new InvalidKeyException("Cannot convert private key: " + privateKey + " with reason: " + exception.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInitSign");
                    }
                    throw new InvalidKeyException("Cannot convert private key: " + privateKey + " with reason: " + exception.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInitSign_2", (Throwable)new InvalidKeyException("not a PKCS11 DSA or PKCS11 RSA private key"));
                    debug.exit(16384L, (Object)className, "engineInitSign");
                }
                throw new InvalidKeyException("not a DSA or RSA private key: " + privateKey);
            }
        }
        if (privateKey2 instanceof RSAPrivateKey) {
            this.keyObject = ((RSAPrivateKey)privateKey2).getObject();
            this.modSize = ((RSAPrivateKey)privateKey2).getModulus().bitLength() / 8 + 10;
        }
        if (privateKey2 instanceof DSAPrivateKey) {
            this.keyObject = ((DSAPrivateKey)privateKey2).getObject();
        }
        this.session.signInit(this.mechanism, null, this.keyObject);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitSign");
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineInitVerify", (Object)publicKey);
        }
        this.isSign = false;
        PublicKey publicKey2 = publicKey;
        if (!(publicKey instanceof RSAPublicKey) && !(publicKey instanceof DSAPublicKey)) {
            if (publicKey instanceof java.security.interfaces.RSAPublicKey || publicKey instanceof java.security.interfaces.DSAPublicKey) {
                KeyFactory keyFactory = null;
                String string = publicKey.getAlgorithm();
                try {
                    if (string.equalsIgnoreCase("DSA")) {
                        keyFactory = KeyFactory.getInstance("DSA", this.provider);
                        publicKey2 = (PKCS11PublicKey)keyFactory.translateKey(publicKey);
                    }
                    keyFactory = KeyFactory.getInstance("RSA", this.provider);
                    publicKey2 = (PKCS11PublicKey)keyFactory.translateKey(publicKey);
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInitVerify_1", (Throwable)new InvalidKeyException("Cannot convert public key: " + publicKey + " with reason: " + exception.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInitVerify");
                    }
                    throw new InvalidKeyException("Cannot convert public key: " + publicKey + " with reason: " + exception.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInitVerify_2", (Throwable)new InvalidKeyException("not a DSA or RSA public key"));
                    debug.exit(16384L, (Object)className, "engineInitVerify");
                }
                throw new InvalidKeyException("not a DSA or RSA public key: " + publicKey);
            }
        }
        if (publicKey2 instanceof RSAPublicKey) {
            this.keyObject = ((RSAPublicKey)publicKey2).getObject();
        }
        if (publicKey2 instanceof DSAPublicKey) {
            this.keyObject = ((DSAPublicKey)publicKey2).getObject();
        }
        this.session.verifyInit(this.mechanism, null, this.keyObject);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitVerify");
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, new Integer(n), new Integer(n2)};
            debug.entry(16384L, (Object)className, "engineUpdate", objectArray);
        }
        if (this.isSign) {
            this.session.signUpdate(byArray, n, n2);
        } else {
            this.session.verifyUpdate(byArray, n, n2);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected byte[] engineSign() throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSign");
        }
        int n = 0;
        byte[] byArray = null;
        byte[] byArray2 = new byte[this.modSize];
        n = this.session.signFinal(byArray2, 0);
        byArray = new byte[n];
        System.arraycopy(byArray2, 0, byArray, 0, n);
        if (debug != null) {
            debug.text(16384L, (Object)className, "engineSign", "Sign() size = " + n);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            debug.text(16384L, (Object)className, "engineSign", "outdata = " + hexDumpEncoder.encode(byArray2));
            debug.text(16384L, (Object)className, "engineSign", "signature = " + hexDumpEncoder.encode(byArray));
            debug.exit(16384L, (Object)className, "engineSign");
        }
        return byArray;
    }

    protected byte[] engineSign(byte[] byArray, int n) throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSign", (Object)byArray, (Object)new Integer(n));
        }
        int n2 = 0;
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[this.modSize];
        n2 = this.session.sign(byArray, 0, n, byArray3, 0);
        byArray2 = new byte[n2];
        System.arraycopy(byArray3, 0, byArray2, 0, n2);
        if (debug != null) {
            debug.text(16384L, (Object)className, "engineSign", "Sign(data, len) size = " + n2);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            debug.text(16384L, (Object)className, "engineSign", "signature(data, len) = " + hexDumpEncoder.encode(byArray2));
            debug.exit(16384L, (Object)className, "engineSign");
        }
        return byArray2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected boolean engineVerify(byte[] var1_1) throws SignatureException {
        var2_2 = false;
        if (Signature.debug != null) {
            Signature.debug.entry(16384L, (Object)Signature.className, "engineVerify", (Object)var1_1);
        }
        if (Signature.debug != null) {
            Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature.length = " + var1_1.length);
            var3_3 /* !! */  = (byte[])new HexDumpEncoder();
            Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature = " + var3_3 /* !! */ .encode(var1_1));
        }
        var3_3 /* !! */  = new byte[40];
        if (this.mechanism == 18 && var1_1.length != 40) {
            var4_4 = var1_1[3];
            var5_6 = var1_1[var4_4 + 3 + 2];
            var6_7 = 4;
            var7_8 = var4_4 + 6;
            if (var5_6 > 20) {
                var5_6 = 20;
                var7_8 = var4_4 + 6 + 1;
            }
            if (var4_4 > 20) {
                var4_4 = 20;
                var6_7 = 5;
            }
            if (Signature.debug != null) {
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature len = " + var1_1[1]);
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature lenr = " + var4_4);
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature lens = " + var5_6);
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature startPosR = " + var6_7);
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature startPosS = " + var7_8);
            }
            System.arraycopy(var1_1, var6_7, var3_3 /* !! */ , 0 + (20 - var4_4), var4_4);
            System.arraycopy(var1_1, var7_8, var3_3 /* !! */ , 20 + (20 - var5_6), var5_6);
            try {
                if (Signature.debug != null) {
                    var8_9 = new HexDumpEncoder();
                    Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signingBytes = " + var8_9.encode(var3_3 /* !! */ ));
                }
                var2_2 = this.session.verifyFinal(var3_3 /* !! */ , 0, var3_3 /* !! */ .length);
                if (Signature.debug == null) ** GOTO lbl51
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature result = " + var2_2);
                var8_9 = new HexDumpEncoder();
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signingBytes = " + var8_9.encode(var3_3 /* !! */ ));
            }
            catch (PKCS11Exception var8_10) {
                if (Signature.debug != null) {
                    Signature.debug.exception(16384L, (Object)Signature.className, "engineVerify", (Throwable)var8_10);
                    Signature.debug.exit(16384L, (Object)Signature.className, "engineVerify");
                }
                throw new SignatureException("PKCS11 Exception : " + var8_10.getMessage());
            }
        } else {
            try {
                var2_2 = this.session.verifyFinal(var1_1, 0, var1_1.length);
            }
            catch (PKCS11Exception var4_5) {
                if (Signature.debug != null) {
                    Signature.debug.exception(16384L, (Object)Signature.className, "engineVerify", (Throwable)var4_5);
                    Signature.debug.exit(16384L, (Object)Signature.className, "engineVerify");
                }
                throw new SignatureException("PKCS11 Exception : " + var4_5.getMessage());
            }
        }
lbl51:
        // 3 sources

        if (Signature.debug != null) {
            Signature.debug.exit(16384L, (Object)Signature.className, "engineVerify");
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected boolean engineVerify(byte[] var1_1, byte[] var2_2, int var3_3) throws SignatureException {
        var4_4 = false;
        if (Signature.debug != null) {
            var5_5 /* !! */  = (byte[])new Object[]{var1_1, var2_2, new Integer(var3_3)};
            Signature.debug.entry(16384L, (Object)Signature.className, "engineVerify", (Object[])var5_5 /* !! */ );
        }
        var5_5 /* !! */  = new byte[40];
        if (Signature.debug != null) {
            Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature.length = " + var1_1.length);
            var6_6 = new HexDumpEncoder();
            Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature = " + var6_6.encode(var1_1));
        }
        if (this.mechanism == 18 && var1_1.length != 40) {
            var6_7 = var1_1[3];
            var7_9 = var1_1[var6_7 + 3 + 2];
            var8_10 = 4;
            var9_11 = var6_7 + 6;
            if (var7_9 > 20) {
                var7_9 = 20;
                var9_11 = var6_7 + 6 + 1;
            }
            if (var6_7 > 20) {
                var6_7 = 20;
                var8_10 = 5;
            }
            if (Signature.debug != null) {
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature len = " + var1_1[1]);
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature lenr = " + var6_7);
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature lens = " + var7_9);
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature startPosR = " + var8_10);
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature startPosS = " + var9_11);
            }
            System.arraycopy(var1_1, var8_10, var5_5 /* !! */ , 0 + (20 - var6_7), var6_7);
            System.arraycopy(var1_1, var9_11, var5_5 /* !! */ , 20 + (20 - var7_9), var7_9);
            try {
                if (Signature.debug != null) {
                    var10_12 = new HexDumpEncoder();
                    Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signingBytes = " + var10_12.encode(var5_5 /* !! */ ));
                }
                var4_4 = this.session.verify(var2_2, 0, var3_3, var5_5 /* !! */ , 0, var5_5 /* !! */ .length);
                if (Signature.debug == null) ** GOTO lbl52
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature result = " + var4_4);
                var10_12 = new HexDumpEncoder();
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signingBytes = " + var10_12.encode(var5_5 /* !! */ ));
            }
            catch (PKCS11Exception var10_13) {
                if (Signature.debug != null) {
                    Signature.debug.exception(16384L, (Object)Signature.className, "engineVerify", (Throwable)var10_13);
                    Signature.debug.exit(16384L, (Object)Signature.className, "engineVerify");
                }
                throw new SignatureException("PKCS11 Exception : " + var10_13.getMessage());
            }
        } else {
            try {
                var4_4 = this.session.verify(var2_2, 0, var3_3, var1_1, 0, var1_1.length);
            }
            catch (PKCS11Exception var6_8) {
                if (Signature.debug != null) {
                    Signature.debug.exception(16384L, (Object)Signature.className, "engineVerify", (Throwable)var6_8);
                    Signature.debug.exit(16384L, (Object)Signature.className, "engineVerify");
                }
                throw new SignatureException("PKCS11 Exception : " + var6_8.getMessage());
            }
        }
lbl52:
        // 3 sources

        if (Signature.debug != null) {
            Signature.debug.exit(16384L, (Object)Signature.className, "engineVerify");
        }
        return var4_4;
    }
}

