/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Hash;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class PKCS11SHA1withDSASingle
extends SignatureSpi {
    private Signature sig;
    private Hash sha;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private boolean reset = false;

    public PKCS11SHA1withDSASingle(Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.sig = new Signature(17, provider);
        this.sha = new Hash(544, ((IBMPKCS11Impl)provider).getSession());
    }

    public PKCS11SHA1withDSASingle() throws NoSuchAlgorithmException, NoSuchProviderException {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    protected void engineSetParameter(String string, Object object) {
    }

    protected Object engineGetParameter(String string) {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.privateKey = privateKey;
        if (this.reset) {
            this.sha.engineReset();
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.publicKey = publicKey;
        if (this.reset) {
            this.sha.engineReset();
        }
    }

    protected void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this.sha.engineUpdate(byArray, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.sha.engineUpdate(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.sha.engineDigest();
        try {
            this.sig.engineInitSign(this.privateKey);
        }
        catch (Exception exception) {
            throw new PKCS11Exception(exception.getMessage());
        }
        byte[] byArray2 = this.sig.engineSign(byArray, byArray.length);
        this.reset = true;
        try {
            byte[] byArray3 = new byte[20];
            byte[] byArray4 = new byte[20];
            System.arraycopy(byArray2, 0, byArray3, 0, 20);
            System.arraycopy(byArray2, 20, byArray4, 0, 20);
            DerOutputStream derOutputStream = new DerOutputStream(100);
            derOutputStream.putInteger(new BigInteger(1, byArray3));
            derOutputStream.putInteger(new BigInteger(1, byArray4));
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new SignatureException("error encoding signature");
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        Object object;
        byte[] byArray2 = new byte[40];
        try {
            object = new DerInputStream(byArray);
            DerValue[] derValueArray = object.getSequence(2);
            byte[] byArray3 = derValueArray[0].getInteger().toByteArray();
            byte[] byArray4 = derValueArray[1].getInteger().toByteArray();
            int n = byArray3.length;
            if (n > 20) {
                System.arraycopy(byArray3, n - 20, byArray2, 0, 20);
            } else {
                System.arraycopy(byArray3, 0, byArray2, 20 - n, n);
            }
            n = byArray4.length;
            if (n > 20) {
                System.arraycopy(byArray4, n - 20, byArray2, 20, 20);
            } else {
                System.arraycopy(byArray4, 0, byArray2, 40 - n, n);
            }
        }
        catch (IOException iOException) {
            throw new SignatureException("invalid encoding for signature :" + iOException);
        }
        object = this.sha.engineDigest();
        try {
            this.sig.engineInitVerify(this.publicKey);
        }
        catch (Exception exception) {
            throw new PKCS11Exception(exception.getMessage());
        }
        this.reset = true;
        return this.sig.engineVerify(byArray2, (byte[])object, ((DerInputStream)object).length);
    }
}

