/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Hash;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

final class GeneralSignatureSingleRSA
extends SignatureSpi {
    static final String MD2_RSA = "1.2.840.113549.2.2";
    static final String MD5_RSA = "1.2.840.113549.2.5";
    static final String SHA1_RSA = "1.3.14.3.2.26";
    static final String SHA256_RSA = "2.16.840.1.101.3.4.2.1";
    static final String SHA384_RSA = "2.16.840.1.101.3.4.2.2";
    static final String SHA512_RSA = "2.16.840.1.101.3.4.2.3";
    private Signature sig;
    private Hash hash;
    String oid;
    PrivateKey privateKey;
    PublicKey publicKey;
    private boolean reset = false;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA";

    public GeneralSignatureSingleRSA(Provider provider, String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "GeneralSignatureSingleRSA");
        }
        int n = 0;
        if (string.equalsIgnoreCase("MD2withRSA")) {
            n = 4;
            this.sig = new Signature(1, provider);
            this.hash = new Hash(512, ((IBMPKCS11Impl)provider).getSession());
            this.oid = MD2_RSA;
        } else if (string.equalsIgnoreCase("MD5withRSA")) {
            n = 5;
            this.sig = new Signature(1, provider);
            this.hash = new Hash(528, ((IBMPKCS11Impl)provider).getSession());
            this.oid = MD5_RSA;
        } else if (string.equalsIgnoreCase("SHA1withRSA")) {
            n = 6;
            this.sig = new Signature(1, provider);
            this.hash = new Hash(544, ((IBMPKCS11Impl)provider).getSession());
            this.oid = SHA1_RSA;
        } else if (string.equalsIgnoreCase("SHA256withRSA")) {
            n = 64;
            this.sig = new Signature(1, provider);
            this.hash = new Hash(592, ((IBMPKCS11Impl)provider).getSession());
            this.oid = SHA256_RSA;
        } else if (string.equalsIgnoreCase("SHA384withRSA")) {
            n = 65;
            this.sig = new Signature(1, provider);
            this.hash = new Hash(608, ((IBMPKCS11Impl)provider).getSession());
            this.oid = SHA384_RSA;
        } else if (string.equalsIgnoreCase("SHA512withRSA")) {
            n = 66;
            this.sig = new Signature(1, provider);
            this.hash = new Hash(624, ((IBMPKCS11Impl)provider).getSession());
            this.oid = SHA512_RSA;
        } else {
            throw new NoSuchAlgorithmException(string + " is not found");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "GeneralSignatureSingleRSA");
        }
    }

    protected void engineSetParameter(String string, Object object) {
    }

    protected Object engineGetParameter(String string) {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.privateKey = privateKey;
        if (this.reset) {
            this.hash.engineReset();
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.publicKey = publicKey;
        if (this.reset) {
            this.hash.engineReset();
        }
    }

    protected void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this.hash.engineUpdate(byArray, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.hash.engineUpdate(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        Object object;
        byte[] byArray = this.hash.engineDigest();
        DerOutputStream derOutputStream = null;
        try {
            derOutputStream = new DerOutputStream();
            object = new DerOutputStream();
            AlgorithmId algorithmId = AlgorithmId.getAlgorithmId((String)this.oid);
            algorithmId.encode(object);
            DerValue[] derValueArray = new DerValue[]{new DerValue(object.toByteArray()), new DerValue(4, byArray)};
            derOutputStream.putSequence(derValueArray);
        }
        catch (IOException iOException) {
            throw new SignatureException("error encoding signature");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException("error encoding signature");
        }
        object = derOutputStream.toByteArray();
        try {
            this.sig.engineInitSign(this.privateKey);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PKCS11Exception(exception.getMessage());
        }
        this.reset = true;
        return this.sig.engineSign((byte[])object, ((DerOutputStream)object).length);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        Object object;
        byte[] byArray2 = this.hash.engineDigest();
        DerOutputStream derOutputStream = null;
        try {
            derOutputStream = new DerOutputStream();
            object = new DerOutputStream();
            AlgorithmId algorithmId = AlgorithmId.getAlgorithmId((String)this.oid);
            algorithmId.encode(object);
            DerValue[] derValueArray = new DerValue[]{new DerValue(object.toByteArray()), new DerValue(4, byArray2)};
            derOutputStream.putSequence(derValueArray);
        }
        catch (IOException iOException) {
            throw new SignatureException("error encoding signature");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException("error encoding signature");
        }
        object = derOutputStream.toByteArray();
        try {
            this.sig.engineInitVerify(this.publicKey);
        }
        catch (Exception exception) {
            throw new PKCS11Exception(exception.getMessage());
        }
        this.reset = true;
        return this.sig.engineVerify(byArray, (byte[])object, ((DerOutputStream)object).length);
    }
}

