/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.GeneralKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.KeyMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilderImpl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11KeySpec;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class GeneralPKCS11KeyFactory
extends SecretKeyFactorySpi {
    private PKCS11Session session = null;
    private Config config = null;
    private KeyMechanismBuilder mechanismBuilder = null;
    private Provider provider = null;

    public GeneralPKCS11KeyFactory(Provider provider, String string) {
        IBMPKCS11Impl.verifyJceJar();
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.mechanismBuilder = MechanismBuilderImpl.createKeyMechanismBuilder(string);
        this.provider = provider;
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        GeneralKey generalKey = null;
        Integer n = this.mechanismBuilder.getKeyType();
        if (keySpec == null) {
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            try {
                Object object;
                PKCS11Object pKCS11Object = null;
                byte[] byArray = null;
                Boolean bl = Boolean.FALSE;
                Boolean bl2 = Boolean.FALSE;
                Boolean bl3 = Boolean.TRUE;
                Boolean bl4 = Boolean.TRUE;
                Boolean bl5 = Boolean.TRUE;
                byte[] byArray2 = null;
                int[] nArray = null;
                Object[] objectArray = null;
                if (keySpec instanceof SecretKeySpec) {
                    object = (SecretKeySpec)keySpec;
                    byArray2 = ((SecretKeySpec)object).getEncoded();
                } else if (keySpec instanceof DESKeySpec) {
                    object = (DESKeySpec)keySpec;
                    byArray2 = ((DESKeySpec)object).getKey();
                } else if (keySpec instanceof DESedeKeySpec) {
                    object = (DESedeKeySpec)keySpec;
                    byArray2 = ((DESedeKeySpec)object).getKey();
                } else {
                    throw new InvalidKeySpecException("Unknown Key specification");
                }
                byArray = this.genID();
                object = null;
                Set set = null;
                int n2 = 0;
                if (this.config != null) {
                    object = this.config.getAttributes("IMPORT", PKCS11Object.SECRET_KEY, n);
                    set = ((HashMap)object).keySet();
                    n2 = set.size();
                    nArray = new int[4 + n2];
                    objectArray = new Object[4 + n2];
                    nArray[0] = 0;
                    nArray[1] = 256;
                    nArray[2] = 258;
                    nArray[3] = 17;
                    objectArray[0] = PKCS11Object.SECRET_KEY;
                    objectArray[1] = n;
                    objectArray[2] = byArray;
                    objectArray[3] = byArray2;
                    Iterator iterator = set.iterator();
                    int n3 = 1;
                    while (iterator.hasNext()) {
                        Integer n4 = (Integer)iterator.next();
                        nArray[3 + n3] = n4;
                        objectArray[3 + n3] = ((HashMap)object).get(n4);
                        ++n3;
                    }
                } else {
                    int[] nArray2 = new int[]{0, 256, 258, 2, 1, 259, 260, 261, 262, 263, 17};
                    nArray = nArray2;
                    objectArray = new Object[]{PKCS11Object.SECRET_KEY, n, byArray, Boolean.TRUE, bl, bl2, bl3, new Boolean(bl3), bl4, new Boolean(bl4), byArray2};
                }
                pKCS11Object = this.session.createObject(nArray, objectArray);
                generalKey = new GeneralKey(this.session, pKCS11Object, this.mechanismBuilder.getAlgorithm());
            }
            catch (InvalidKeyException invalidKeyException) {}
        } else {
            PKCS11Object pKCS11Object = ((PKCS11KeySpec)keySpec).getObject();
            try {
                generalKey = new GeneralKey(this.session, pKCS11Object, this.mechanismBuilder.getAlgorithm());
            }
            catch (InvalidKeyException invalidKeyException) {
                // empty catch block
            }
        }
        return generalKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        try {
            String string = this.mechanismBuilder.getAlgorithm();
            if (secretKey != null && secretKey instanceof PKCS11SecretKey && secretKey.getAlgorithm().equalsIgnoreCase(string) && secretKey.getFormat().equalsIgnoreCase("PKCS#11")) {
                Class<?> clazz2 = Class.forName("javax.crypto.spec.SecretKeySpec");
                if (clazz != null && clazz2.isAssignableFrom(clazz)) {
                    if (((GeneralKey)secretKey).getSensitive().booleanValue()) {
                        throw new PKCS11Exception("Secret key value is not exportable");
                    }
                    return new SecretKeySpec(((GeneralKey)secretKey).getValue(), string);
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (secretKey != null && secretKey.getAlgorithm().equalsIgnoreCase(string) && secretKey.getFormat().equalsIgnoreCase("RAW")) {
                Class<?> clazz3 = Class.forName("javax.crypto.spec.SecretKeySpec");
                if (clazz != null && clazz3.isAssignableFrom(clazz)) {
                    return new SecretKeySpec(secretKey.getEncoded(), string);
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException("Unsupported key specification: " + classNotFoundException.getMessage());
        }
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        try {
            if (secretKey != null && secretKey.getAlgorithm().equalsIgnoreCase(this.mechanismBuilder.getAlgorithm())) {
                if (secretKey instanceof PKCS11SecretKey) {
                    return secretKey;
                }
                if (secretKey.getFormat().equalsIgnoreCase("RAW")) {
                    SecretKeySpec secretKeySpec = (SecretKeySpec)this.engineGetKeySpec(secretKey, (Class)SecretKeySpec.class);
                    return this.engineGenerateSecret(secretKeySpec);
                }
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }

    private byte[] genID() {
        Serializable serializable;
        byte[] byArray = new byte[33];
        byte[] byArray2 = new byte[24];
        byte[] byArray3 = null;
        int n = 0;
        try {
            serializable = SecureRandom.getInstance("IBMSecureRandom", this.provider);
            ((SecureRandom)serializable).nextBytes(byArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = new BigInteger(1, byArray2);
        try {
            byArray3 = ((BigInteger)serializable).toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Can not convert string");
        }
        n = ((BigInteger)serializable).toString().length();
        if (n > 24) {
            n = 24;
        }
        System.arraycopy(byArray3, 0, byArray, 9, n);
        byArray[0] = 73;
        byArray[1] = 66;
        byArray[2] = 77;
        byArray[3] = 80;
        byArray[4] = 75;
        byArray[5] = 67;
        byArray[6] = 83;
        byArray[7] = 49;
        byArray[8] = 49;
        return byArray;
    }

    private Object getAttrValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            object = null;
        }
        return object;
    }
}

