/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.CipherMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.ConstructKeys;
import com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilderImpl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Cipher;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public class GeneralPKCS11Cipher
extends CipherSpi {
    private byte[] iv = null;
    private PKCS11Cipher cipher = null;
    private CipherMechanismBuilder mechanismBuilder;
    private PKCS11Session session = null;
    private Provider provider = null;
    private static HashMap<String, Integer> BLOCK_SIZES = new HashMap();

    public GeneralPKCS11Cipher(Provider provider, String string) {
        IBMPKCS11Impl.verifyJceJar();
        if (!IBMPKCS11Impl.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBM JCE PKCS11 provider may have been tampered.");
        }
        this.provider = provider;
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.mechanismBuilder = MechanismBuilderImpl.createCipherMechanismBuilder(string);
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        this.mechanismBuilder.setMode(string);
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        this.mechanismBuilder.setPadding(string);
    }

    protected int engineGetBlockSize() {
        Integer n = BLOCK_SIZES.get(this.mechanismBuilder.getAlgorithm());
        if (n == null) {
            return 0;
        }
        return n;
    }

    protected int engineGetOutputSize(int n) {
        if (this.mechanismBuilder.isPadding()) {
            Integer n2 = BLOCK_SIZES.get(this.mechanismBuilder.getAlgorithm());
            int n3 = 0;
            if (n2 != null) {
                n3 = n2;
            }
            int n4 = n % n3;
            int n5 = n - n4;
            if (n4 != 0) {
                n5 += n3;
            }
            return n5;
        }
        return n;
    }

    protected byte[] engineGetIV() {
        return this.iv;
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        if (this.iv == null) {
            return null;
        }
        try {
            algorithmParameters = AlgorithmParameters.getInstance(this.mechanismBuilder.getAlgorithm(), this.provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("IBMPKCS11Impl called, but not configured");
        }
        catch (Exception exception) {
            throw new RuntimeException("IBMPKCS11Impl called, but not configured");
        }
        try {
            algorithmParameters.init(new IvParameterSpec(this.iv));
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException("IvParameterSpec not supported");
        }
        return algorithmParameters;
    }

    private PKCS11SecretKey translateToPKCS11SecretKey(Key key) throws InvalidKeyException {
        PKCS11SecretKey pKCS11SecretKey = null;
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        if (key instanceof PKCS11SecretKey) {
            pKCS11SecretKey = (PKCS11SecretKey)key;
        } else if (key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase(this.mechanismBuilder.getAlgorithm()) && key.getFormat().equalsIgnoreCase("RAW")) {
            try {
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.mechanismBuilder.getAlgorithm(), this.provider);
                pKCS11SecretKey = (PKCS11SecretKey)secretKeyFactory.translateKey((SecretKey)key);
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + exception.getMessage());
            }
        } else {
            throw new InvalidKeyException("Key given is not the correct key.");
        }
        return pKCS11SecretKey;
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!this.mechanismBuilder.isCompatibleOperationMode(n, null)) {
            throw new InvalidKeyException("Parameters missing. IV required.");
        }
        PKCS11SecretKey pKCS11SecretKey = this.translateToPKCS11SecretKey(key);
        if (this.mechanismBuilder.isIVRequired()) {
            this.iv = new byte[this.engineGetBlockSize()];
            secureRandom.nextBytes(this.iv);
        }
        this.cipher = new PKCS11Cipher(this.mechanismBuilder.getMechanism(), this.session);
        this.cipher.engineInit(n, pKCS11SecretKey.getObject(), this.iv, this.engineGetBlockSize());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!this.mechanismBuilder.isCompatibleOperationMode(n, algorithmParameterSpec)) {
            throw new InvalidAlgorithmParameterException("IV parameter missing");
        }
        PKCS11SecretKey pKCS11SecretKey = this.translateToPKCS11SecretKey(key);
        if (this.mechanismBuilder.isIVRequired()) {
            if (algorithmParameterSpec != null) {
                if (!(algorithmParameterSpec instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
                this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
            } else {
                this.iv = new byte[this.engineGetBlockSize()];
                secureRandom.nextBytes(this.iv);
            }
        }
        this.cipher = new PKCS11Cipher(this.mechanismBuilder.getMechanism(), this.session);
        this.cipher.engineInit(n, pKCS11SecretKey.getObject(), this.iv, this.engineGetBlockSize());
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                ivParameterSpec = algorithmParameters.getParameterSpec(IvParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
            }
        }
        this.engineInit(n, key, ivParameterSpec, secureRandom);
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        return this.cipher.engineUpdate(byArray, n, n2);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.cipher.engineUpdate(byArray, n, n2, byArray2, n3);
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.engineDoFinal(byArray, n, n2);
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        return this.cipher.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        SecretKeyFactory secretKeyFactory;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("SecretKey type expected.");
        }
        try {
            secretKeyFactory = SecretKeyFactory.getInstance(this.mechanismBuilder.getAlgorithm(), this.provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(noSuchAlgorithmException);
        }
        SecretKey secretKey = secretKeyFactory.translateKey((SecretKey)key);
        if (secretKey instanceof GeneralPKCS11Key) {
            int n = ((GeneralPKCS11Key)secretKey).getValueLen();
            if (n == 0) {
                byte[] byArray = null;
                byArray = secretKey.getEncoded();
                if (byArray != null) {
                    n = byArray.length;
                }
            }
            return n;
        }
        return secretKey.getEncoded().length;
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        Key key = null;
        int[] nArray = null;
        Object[] objectArray = null;
        Object[] objectArray2 = new Object[2];
        PKCS11Object pKCS11Object = null;
        switch (n) {
            case 3: {
                objectArray2 = ConstructKeys.constructSecretKeyAttrs(string);
                nArray = (int[])objectArray2[0];
                objectArray = (Object[])objectArray2[1];
                pKCS11Object = this.cipher.engineUnwrap(byArray, nArray, objectArray);
                key = ConstructKeys.constructSecretKey(pKCS11Object, string, this.provider);
                break;
            }
            case 2: {
                objectArray2 = ConstructKeys.constructPrivateKeyAttrs(string);
                nArray = (int[])objectArray2[0];
                objectArray = (Object[])objectArray2[1];
                pKCS11Object = this.cipher.engineUnwrap(byArray, nArray, objectArray);
                key = ConstructKeys.constructPrivateKey(pKCS11Object, string, this.provider);
                break;
            }
            case 1: {
                objectArray2 = ConstructKeys.constructPublicKeyAttrs(string);
                nArray = (int[])objectArray2[0];
                objectArray = (Object[])objectArray2[1];
                pKCS11Object = this.cipher.engineUnwrap(byArray, nArray, objectArray);
                key = ConstructKeys.constructPublicKey(pKCS11Object, string, this.provider);
            }
        }
        return key;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        int n = ((PKCS11Key)key).getObject().size() + 7;
        return this.cipher.engineWrap(((PKCS11Key)key).getObject(), n);
    }

    static {
        BLOCK_SIZES.put("AES", new Integer(16));
        BLOCK_SIZES.put("DES", new Integer(8));
        BLOCK_SIZES.put("DESede", new Integer(8));
    }
}

