/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DHPKCS11Parameters
extends AlgorithmParametersSpi {
    private Provider provider = null;
    private DHParameterSpec dhparamSpec = null;

    public DHPKCS11Parameters(Provider provider) {
        this.provider = provider;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.dhparamSpec = (DHParameterSpec)algorithmParameterSpec;
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        if (derValue.getTag() != 48) {
            throw new IOException("DH params parsing error");
        }
        derValue.getData().reset();
        BigInteger bigInteger = derValue.getData().getInteger();
        BigInteger bigInteger2 = derValue.getData().getInteger();
        int n = 0;
        n = derValue.getData().available() != 0 ? derValue.getData().getInteger().intValue() : bigInteger.bitLength() - 1;
        if (derValue.getData().available() != 0) {
            throw new IOException("DH encoded params have " + derValue.getData().available() + " extra bytes");
        }
        this.dhparamSpec = new DHParameterSpec(bigInteger, bigInteger2, n);
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        try {
            Class<T> clazz2 = Class.forName("javax.crypto.spec.DHParameterSpec");
            if (clazz2.isAssignableFrom(clazz)) {
                return (T)this.dhparamSpec;
            }
            throw new InvalidParameterSpecException("Inappropriate parameter Specification");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + classNotFoundException.getMessage());
        }
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.dhparamSpec.getP());
        derOutputStream2.putInteger(this.dhparamSpec.getG());
        if (this.dhparamSpec.getL() > 0) {
            derOutputStream2.putInteger(this.dhparamSpec.getL());
        }
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        return "\n\tp: " + this.dhparamSpec.getP().toString() + "\n\tg: " + this.dhparamSpec.getG().toString() + "\n\tl: " + Integer.toString(this.dhparamSpec.getL()) + "\n";
    }
}

