/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.DHPKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.DHPKCS11PublicKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.pkcs11.PKCS11Session;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public final class DHPKCS11KeyFactory
extends KeyFactorySpi {
    private PKCS11Session session = null;
    private Config config = null;

    public DHPKCS11KeyFactory(Provider provider) {
        IBMPKCS11Impl.verifyJceJar();
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DHPublicKeySpec) {
                DHPublicKeySpec dHPublicKeySpec = (DHPublicKeySpec)keySpec;
                return new DHPKCS11PublicKey(dHPublicKeySpec.getY(), dHPublicKeySpec.getP(), dHPublicKeySpec.getG(), this.session, this.config);
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new DHPKCS11PublicKey(((X509EncodedKeySpec)keySpec).getEncoded(), this.session, this.config);
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DHPrivateKeySpec) {
                DHPrivateKeySpec dHPrivateKeySpec = (DHPrivateKeySpec)keySpec;
                return new DHPKCS11PrivateKey(dHPrivateKeySpec.getX(), dHPrivateKeySpec.getP(), dHPrivateKeySpec.getG(), this.session, this.config);
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new DHPKCS11PrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded(), this.session, this.config);
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        try {
            if (key instanceof DHPublicKey) {
                Class<?> clazz2 = Class.forName("javax.crypto.spec.DHPublicKeySpec");
                Class<?> clazz3 = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (clazz2.isAssignableFrom(clazz)) {
                    DHPublicKey dHPublicKey = (DHPublicKey)key;
                    DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
                    return new DHPublicKeySpec(dHPublicKey.getY(), dHParameterSpec.getP(), dHParameterSpec.getG());
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof DHPrivateKey) {
                Class<?> clazz4 = Class.forName("javax.crypto.spec.DHPrivateKeySpec");
                Class<?> clazz5 = Class.forName("java.security.spec.PKCS8EncodedKeySpec");
                if (clazz4.isAssignableFrom(clazz)) {
                    DHPrivateKey dHPrivateKey = (DHPrivateKey)key;
                    DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
                    return new DHPrivateKeySpec(dHPrivateKey.getX(), dHParameterSpec.getP(), dHParameterSpec.getG());
                }
                if (clazz5.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key type");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException("Unsupported key specification: " + classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof DHPublicKey) {
                if (key instanceof DHPKCS11PublicKey) {
                    return key;
                }
                DHPublicKeySpec dHPublicKeySpec = (DHPublicKeySpec)this.engineGetKeySpec(key, DHPublicKeySpec.class);
                return this.engineGeneratePublic(dHPublicKeySpec);
            }
            if (key instanceof DHPrivateKey) {
                if (key instanceof DHPKCS11PrivateKey) {
                    return key;
                }
                DHPrivateKeySpec dHPrivateKeySpec = (DHPrivateKeySpec)this.engineGetKeySpec(key, DHPrivateKeySpec.class);
                return this.engineGeneratePrivate(dHPrivateKeySpec);
            }
            throw new InvalidKeyException("Wrong key type");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }
}

