/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.DHPKCS11KeyFactory;
import com.ibm.crypto.pkcs11impl.provider.DHPKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Iterator;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.SecretKeySpec;

public final class DHPKCS11KeyAgreement
extends KeyAgreementSpi {
    private PKCS11Session session = null;
    private Provider provider = null;
    private Config config = null;
    private BigInteger P = null;
    private BigInteger G = null;
    private BigInteger Y = null;
    private PKCS11Object p11ObjX = null;
    private int secretLen = 0;

    public DHPKCS11KeyAgreement(Provider provider, String string) {
        IBMPKCS11Impl.verifyJceJar();
        this.provider = provider;
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
    }

    public DHPKCS11KeyAgreement(Provider provider) {
        this(provider, null);
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("Only DH PrivateKeys expected.");
        }
        DHPKCS11KeyFactory dHPKCS11KeyFactory = new DHPKCS11KeyFactory(this.provider);
        DHPKCS11PrivateKey dHPKCS11PrivateKey = (DHPKCS11PrivateKey)dHPKCS11KeyFactory.engineTranslateKey(key);
        this.p11ObjX = dHPKCS11PrivateKey.getObject();
        this.P = dHPKCS11PrivateKey.getParams().getP();
        this.G = dHPKCS11PrivateKey.getParams().getG();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.engineInit(key, secureRandom);
    }

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (!(key instanceof DHPublicKey)) {
            throw new InvalidKeyException("Diffie-Hellman public key expected");
        }
        DHPublicKey dHPublicKey = (DHPublicKey)key;
        if (this.P == null || this.G == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (!bl) {
            // empty if block
        }
        BigInteger bigInteger = dHPublicKey.getParams().getP();
        BigInteger bigInteger2 = dHPublicKey.getParams().getG();
        if (bigInteger != null && !this.P.equals(bigInteger)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (bigInteger2 != null && !this.G.equals(bigInteger2)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        this.Y = dHPublicKey.getY();
        this.secretLen = this.P.bitLength() + 7 >> 3;
        return null;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        PKCS11Object pKCS11Object;
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(0, PKCS11Object.SECRET_KEY);
        hashMap.put(256, PKCS11Object.GENERIC_SECRET);
        hashMap.put(353, this.secretLen);
        if (this.config != null) {
            hashMap.putAll(this.config.getAttributes("GENERATE", PKCS11Object.SECRET_KEY, PKCS11Object.GENERIC_SECRET));
        }
        int[] nArray = new int[hashMap.size()];
        Object[] objectArray = new Object[hashMap.size()];
        Iterator iterator = hashMap.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            pKCS11Object = iterator.next();
            nArray[n] = (Integer)pKCS11Object.getKey();
            objectArray[n++] = pKCS11Object.getValue();
        }
        pKCS11Object = this.session.deriveKey(33, (Object)this.Y, this.p11ObjX, nArray, objectArray);
        byte[] byArray = pKCS11Object.getByteArrayAttributeValue(17);
        pKCS11Object.destroy();
        return byArray;
    }

    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        if (byArray == null) {
            throw new ShortBufferException("No buffer provided for shared secret");
        }
        byte[] byArray2 = this.engineGenerateSecret();
        if (byArray2.length << 3 != this.P.bitLength()) {
            if (byArray.length - n < byArray2.length - 1) {
                throw new ShortBufferException("Buffer too short for shared secret");
            }
            System.arraycopy(byArray2, 1, byArray, n, byArray2.length - 1);
            return byArray2.length - 1;
        }
        if (byArray.length - n < byArray2.length) {
            throw new ShortBufferException("Buffer too short to hold shared secret");
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        int n;
        if (string == null) {
            return null;
        }
        byte[] byArray = this.engineGenerateSecret();
        if (string.equalsIgnoreCase("DES")) {
            n = 8;
        } else if (string.equalsIgnoreCase("DESede")) {
            n = 24;
        } else if (string.equalsIgnoreCase("Blowfish")) {
            n = Math.min(56, byArray.length);
        } else if (string.equalsIgnoreCase("AES")) {
            n = byArray.length >= 32 ? 32 : 16;
        } else {
            throw new NoSuchAlgorithmException("Unknown algorithm " + string);
        }
        if (byArray.length < n) {
            throw new InvalidKeyException("Secret too short");
        }
        return new SecretKeySpec(byArray, 0, n, string);
    }
}

