/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.jaxp;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.xpath.jaxp.XPathImpl;
import org.apache.xpath.res.XPATHMessages;

public class XPathFactoryImpl
extends XPathFactory {
    public static final String FEATURE_NULL_FCN_PREFIX = "null_function_prefix";
    private boolean m_isSecureProcessing = false;
    private boolean m_allowNullFcnPrefix = false;
    private XPathVariableResolver m_variableResolver = null;
    private XPathFunctionResolver m_functionResolver = null;

    public boolean isObjectModelSupported(String objectModel) {
        if (objectModel == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_OBJECT_MODEL_NULL", null));
        }
        if (objectModel.length() == 0) {
            throw new IllegalArgumentException(XPATHMessages.createXPATHMessage("ER_OBJECT_MODEL_EMPTY", null));
        }
        return objectModel.equals("http://java.sun.com/jaxp/xpath/dom");
    }

    public void setFeature(String name, boolean value) throws XPathFactoryConfigurationException {
        if (name == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_SET_FEATURE_NULL_NAME", null));
        }
        if (name.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this.m_isSecureProcessing = value;
        } else if (name.equals(FEATURE_NULL_FCN_PREFIX)) {
            this.m_allowNullFcnPrefix = value;
        } else {
            throw new XPathFactoryConfigurationException(XPATHMessages.createXPATHMessage("ER_UNSUPPORTED_FEATURE", new Object[]{name}));
        }
    }

    public boolean isSecureProcessing() {
        return this.m_isSecureProcessing;
    }

    public boolean allowNullFcnPrefix() {
        return this.m_allowNullFcnPrefix;
    }

    public boolean getFeature(String name) throws XPathFactoryConfigurationException {
        if (name == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_GET_FEATURE_NULL_NAME", null));
        }
        if (name.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.m_isSecureProcessing;
        }
        if (name.equals(FEATURE_NULL_FCN_PREFIX)) {
            return this.m_allowNullFcnPrefix;
        }
        throw new XPathFactoryConfigurationException(XPATHMessages.createXPATHMessage("ER_UNSUPPORTED_FEATURE", new Object[]{name}));
    }

    public void setXPathVariableResolver(XPathVariableResolver resolver2) {
        if (resolver2 == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_NULL_XPATH_VARIABLE_RESOLVER", null));
        }
        this.m_variableResolver = resolver2;
    }

    public void setXPathFunctionResolver(XPathFunctionResolver resolver2) {
        if (resolver2 == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_NULL_XPATH_FUNCTION_RESOLVER", null));
        }
        this.m_functionResolver = resolver2;
    }

    public XPath newXPath() {
        XPathImpl xpath = new XPathImpl(this.m_functionResolver, this.m_variableResolver, this.m_isSecureProcessing, this.m_allowNullFcnPrefix);
        return xpath;
    }
}

