/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xslt4j.bcel.verifier;

import com.ibm.xslt4j.bcel.Repository;
import com.ibm.xslt4j.bcel.classfile.JavaClass;
import com.ibm.xslt4j.bcel.verifier.VerificationResult;
import com.ibm.xslt4j.bcel.verifier.VerifierFactory;
import com.ibm.xslt4j.bcel.verifier.statics.Pass1Verifier;
import com.ibm.xslt4j.bcel.verifier.statics.Pass2Verifier;
import com.ibm.xslt4j.bcel.verifier.statics.Pass3aVerifier;
import com.ibm.xslt4j.bcel.verifier.structurals.Pass3bVerifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Verifier {
    private final String classname;
    private Pass1Verifier p1v;
    private Pass2Verifier p2v;
    private HashMap p3avs = new HashMap();
    private HashMap p3bvs = new HashMap();

    public VerificationResult doPass1() {
        if (this.p1v == null) {
            this.p1v = new Pass1Verifier(this);
        }
        return this.p1v.verify();
    }

    public VerificationResult doPass2() {
        if (this.p2v == null) {
            this.p2v = new Pass2Verifier(this);
        }
        return this.p2v.verify();
    }

    public VerificationResult doPass3a(int method_no) {
        String key = Integer.toString(method_no);
        Pass3aVerifier p3av = (Pass3aVerifier)this.p3avs.get(key);
        if (this.p3avs.get(key) == null) {
            p3av = new Pass3aVerifier(this, method_no);
            this.p3avs.put(key, p3av);
        }
        return p3av.verify();
    }

    public VerificationResult doPass3b(int method_no) {
        String key = Integer.toString(method_no);
        Pass3bVerifier p3bv = (Pass3bVerifier)this.p3bvs.get(key);
        if (this.p3bvs.get(key) == null) {
            p3bv = new Pass3bVerifier(this, method_no);
            this.p3bvs.put(key, p3bv);
        }
        return p3bv.verify();
    }

    private Verifier() {
        this.classname = "";
    }

    Verifier(String fully_qualified_classname) {
        this.classname = fully_qualified_classname;
        this.flush();
    }

    public final String getClassName() {
        return this.classname;
    }

    public void flush() {
        this.p1v = null;
        this.p2v = null;
        this.p3avs.clear();
        this.p3bvs.clear();
    }

    public String[] getMessages() {
        int i;
        ArrayList<String> messages = new ArrayList<String>();
        if (this.p1v != null) {
            String[] p1m = this.p1v.getMessages();
            i = 0;
            while (i < p1m.length) {
                messages.add("Pass 1: " + p1m[i]);
                ++i;
            }
        }
        if (this.p2v != null) {
            String[] p2m = this.p2v.getMessages();
            i = 0;
            while (i < p2m.length) {
                messages.add("Pass 2: " + p2m[i]);
                ++i;
            }
        }
        Iterator p3as = this.p3avs.values().iterator();
        while (p3as.hasNext()) {
            Pass3aVerifier pv = (Pass3aVerifier)p3as.next();
            String[] p3am = pv.getMessages();
            int meth = pv.getMethodNo();
            int i2 = 0;
            while (i2 < p3am.length) {
                messages.add("Pass 3a, method " + meth + " ('" + Repository.lookupClass(this.classname).getMethods()[meth] + "'): " + p3am[i2]);
                ++i2;
            }
        }
        Iterator p3bs = this.p3bvs.values().iterator();
        while (p3bs.hasNext()) {
            Pass3bVerifier pv = (Pass3bVerifier)p3bs.next();
            String[] p3bm = pv.getMessages();
            int meth = pv.getMethodNo();
            int i3 = 0;
            while (i3 < p3bm.length) {
                messages.add("Pass 3b, method " + meth + " ('" + Repository.lookupClass(this.classname).getMethods()[meth] + "'): " + p3bm[i3]);
                ++i3;
            }
        }
        String[] ret = new String[messages.size()];
        int i4 = 0;
        while (i4 < messages.size()) {
            ret[i4] = (String)messages.get(i4);
            ++i4;
        }
        return ret;
    }

    public static void main(String[] args) {
        System.out.println("JustIce by Enver Haase, (C) 2001. http://bcel.sourceforge.net\n");
        int k = 0;
        while (k < args.length) {
            int dotclasspos;
            if (args[k].endsWith(".class") && (dotclasspos = args[k].lastIndexOf(".class")) != -1) {
                args[k] = args[k].substring(0, dotclasspos);
            }
            args[k] = args[k].replace('/', '.');
            System.out.println("Now verifiying: " + args[k] + "\n");
            Verifier v = VerifierFactory.getVerifier(args[k]);
            VerificationResult vr = v.doPass1();
            System.out.println("Pass 1:\n" + vr);
            vr = v.doPass2();
            System.out.println("Pass 2:\n" + vr);
            if (vr == VerificationResult.VR_OK) {
                JavaClass jc = Repository.lookupClass(args[k]);
                int i = 0;
                while (i < jc.getMethods().length) {
                    vr = v.doPass3a(i);
                    System.out.println("Pass 3a, method " + i + " ['" + jc.getMethods()[i] + "']:\n" + vr);
                    vr = v.doPass3b(i);
                    System.out.println("Pass 3b, method number " + i + " ['" + jc.getMethods()[i] + "']:\n" + vr);
                    ++i;
                }
            }
            System.out.println("Warnings:");
            String[] warnings = v.getMessages();
            if (warnings.length == 0) {
                System.out.println("<none>");
            }
            int j = 0;
            while (j < warnings.length) {
                System.out.println(warnings[j]);
                ++j;
            }
            System.out.println("\n");
            v.flush();
            Repository.clearCache();
            System.gc();
            ++k;
        }
    }
}

