/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xslt4j.bcel.classfile;

import com.ibm.xslt4j.bcel.classfile.Attribute;
import com.ibm.xslt4j.bcel.classfile.ConstantPool;
import com.ibm.xslt4j.bcel.classfile.InnerClass;
import com.ibm.xslt4j.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class InnerClasses
extends Attribute {
    private InnerClass[] inner_classes;
    private int number_of_classes;

    public InnerClasses(InnerClasses c) {
        this(c.getNameIndex(), c.getLength(), c.getInnerClasses(), c.getConstantPool());
    }

    public InnerClasses(int name_index, int length, InnerClass[] inner_classes, ConstantPool constant_pool) {
        super((byte)6, name_index, length, constant_pool);
        this.setInnerClasses(inner_classes);
    }

    InnerClasses(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (InnerClass[])null, constant_pool);
        this.number_of_classes = file.readUnsignedShort();
        this.inner_classes = new InnerClass[this.number_of_classes];
        int i = 0;
        while (i < this.number_of_classes) {
            this.inner_classes[i] = new InnerClass(file);
            ++i;
        }
    }

    public void accept(Visitor v) {
        v.visitInnerClasses(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.number_of_classes);
        int i = 0;
        while (i < this.number_of_classes) {
            this.inner_classes[i].dump(file);
            ++i;
        }
    }

    public final InnerClass[] getInnerClasses() {
        return this.inner_classes;
    }

    public final void setInnerClasses(InnerClass[] inner_classes) {
        this.inner_classes = inner_classes;
        this.number_of_classes = inner_classes == null ? 0 : inner_classes.length;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.number_of_classes) {
            buf.append(String.valueOf(this.inner_classes[i].toString(this.constant_pool)) + "\n");
            ++i;
        }
        return buf.toString();
    }

    public Attribute copy(ConstantPool constant_pool) {
        InnerClasses c = (InnerClasses)this.clone();
        c.inner_classes = new InnerClass[this.number_of_classes];
        int i = 0;
        while (i < this.number_of_classes) {
            c.inner_classes[i] = this.inner_classes[i].copy();
            ++i;
        }
        c.constant_pool = constant_pool;
        return c;
    }
}

