/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class URI {
    private String fScheme;
    private String fAuthority;
    private String fPath;
    private String fQuery;
    private String fFragment;
    private static final byte[] fgSchemeCharMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final byte[] fgURICharMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 3, 2, 1, 1, 1, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 0, 2, 0, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0, 2, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0};
    private static final byte[] fgHexCharMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    private URI() {
    }

    public URI(URI uRI) {
        this.fScheme = uRI.fScheme;
        this.fAuthority = uRI.fAuthority;
        this.fPath = uRI.fPath;
        this.fQuery = uRI.fQuery;
        this.fFragment = uRI.fFragment;
    }

    public static URI parse(String string) {
        if (string == null) {
            return null;
        }
        return URI.parseURI(string, true);
    }

    public static URI parse(URI uRI, String string) {
        if (uRI == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        URI uRI2 = URI.parseURI(string, false);
        if (uRI2 == null) {
            return null;
        }
        if (uRI2.fScheme == null) {
            return uRI2.resolveRelativeTo(uRI);
        }
        return uRI2;
    }

    public static URI parse(String string, String string2, String string3) {
        URI uRI = new URI();
        if ((uRI = uRI.parseScheme(string)) == null) {
            return null;
        }
        if ((uRI = uRI.parseAuthority(string2)) == null) {
            return null;
        }
        uRI = uRI.parsePath(string3);
        return uRI;
    }

    private static URI parseURI(String string, boolean bl) {
        String string2;
        String string3;
        int n;
        URI uRI = new URI();
        int n2 = string.length();
        int n3 = 47;
        int n4 = n = 0;
        while (n < n2) {
            n3 = string.charAt(n);
            if (n3 == 58) {
                if (n == 0) break;
                string3 = string.substring(n4, n);
                if ((uRI = uRI.parseScheme(string3)) == null) {
                    return null;
                }
                if (++n == n2) {
                    String string4 = "";
                    uRI = uRI.parsePath(string4);
                    return uRI;
                }
                n4 = n;
                n3 = string.charAt(n);
                break;
            }
            if (n3 == 47 || n3 == 63 || n3 == 35) {
                n = 0;
                n3 = string.charAt(n);
                break;
            }
            ++n;
        }
        if (bl && uRI.fScheme == null) {
            return null;
        }
        if (n + 1 < n2 && n3 == 47 && string.charAt(n + 1) == '/') {
            n4 = n += 2;
            while (n < n2) {
                n3 = string.charAt(n);
                if (n3 == 47 || n3 == 63 || n3 == 35) break;
                ++n;
            }
            if ((uRI = uRI.parseAuthority(string3 = string.substring(n4, n))) == null) {
                return null;
            }
            n4 = n;
        }
        while (n < n2) {
            n3 = string.charAt(n);
            if (n3 == 63 || n3 == 35) break;
            ++n;
        }
        if ((uRI = uRI.parsePath(string2 = string.substring(n4, n))) == null) {
            return null;
        }
        if (n3 == 63) {
            n4 = ++n;
            while (n < n2) {
                n3 = string.charAt(n);
                if (n3 == 35) break;
                ++n;
            }
            string3 = string.substring(n4, n);
            uRI = uRI.parseQuery(string3);
            if (uRI == null) {
                return null;
            }
        }
        if (n3 == 35) {
            n4 = ++n;
            while (n < n2) {
                n3 = string.charAt(n);
                if (n3 == 35) break;
                ++n;
            }
            string3 = string.substring(n4, n);
            uRI = uRI.parseFragment(string3);
            if (uRI == null) {
                return null;
            }
        }
        return uRI;
    }

    private URI resolveRelativeTo(URI uRI) {
        int n;
        char c;
        this.fScheme = uRI.fScheme;
        if (this.fAuthority != null) {
            return this;
        }
        this.fAuthority = uRI.fAuthority;
        int n2 = this.fPath.length();
        if (n2 == 0 && this.fQuery == null) {
            uRI.fQuery = null;
            if (this.fFragment != null) {
                uRI.fFragment = this.fFragment;
            }
            return uRI;
        }
        if (n2 > 0 && this.fPath.charAt(0) == '/') {
            return this;
        }
        String string = uRI.fPath;
        int n3 = string.lastIndexOf(47) + 1;
        if (n3 > 0) {
            string = string.substring(0, n3);
        }
        int n4 = string.length() + n2;
        char[] cArray = new char[n4];
        string.getChars(0, n4 - n2, cArray, 0);
        this.fPath.getChars(0, n2, cArray, n4 - n2);
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            c = cArray[n6++];
            cArray[n5++] = c;
            if (c != '/' || n6 + 1 >= n4 || cArray[n6] != '.' || cArray[n6 + 1] != '/') continue;
            n6 += 2;
        }
        if (n5 > 1 && cArray[n5 - 1] == '.' && cArray[n5 - 2] == '/') {
            --n5;
        }
        n4 = n5;
        n5 = 0;
        n6 = 0;
        while (n6 < n4) {
            c = cArray[n6++];
            cArray[n5++] = c;
            if (c != '/' || n5 == 1 || n6 + 2 >= n4 || cArray[n6] != '.' || cArray[n6 + 1] != '.' || cArray[n6 + 2] != '/' || (n = n5 - 4) >= 0 && cArray[n] == '/' && cArray[n + 1] == '.' && cArray[n + 2] == '.') continue;
            n6 += 2;
            while (--n5 > 0 && cArray[n5 - 1] != '/') {
            }
            if (n5 <= 0 || cArray[n5 - 1] != '/') continue;
            --n5;
        }
        n4 = n5;
        n = n5 - 3;
        if (n >= 0 && cArray[n] == '/' && cArray[n + 1] == '.' && cArray[n + 2] == '.' && ((n -= 3) < 0 || cArray[n] != '/' || cArray[n + 1] != '.' || cArray[n + 2] != '.')) {
            n5 -= 3;
            while (n5 > 0 && cArray[n5 - 1] != '/') {
                --n5;
            }
        }
        n4 = n5;
        this.fPath = new String(cArray, 0, n4);
        return this;
    }

    private URI parseScheme(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return null;
        }
        char c = string.charAt(0);
        if (c >= '\u0080' || fgSchemeCharMap[c] != 1) {
            return null;
        }
        int n2 = 1;
        while (n2 < n) {
            c = string.charAt(n2);
            if (c >= '\u0080' || fgSchemeCharMap[c] == 0) {
                return null;
            }
            ++n2;
        }
        this.fScheme = string.toLowerCase();
        return this;
    }

    private URI parseAuthority(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c >= '\u0080') {
                return null;
            }
            byte by = fgURICharMap[c];
            switch (by) {
                default: {
                    return null;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (c != '/' && c != '?') break;
                    return null;
                }
                case 3: {
                    if (n2 + 2 >= n) {
                        return null;
                    }
                    if ((c = string.charAt(++n2)) >= '\u0080' || fgHexCharMap[c] == 0) {
                        return null;
                    }
                    if ((c = string.charAt(++n2)) < '\u0080' && fgHexCharMap[c] != 0) break;
                    return null;
                }
            }
            ++n2;
        }
        this.fAuthority = string;
        return this;
    }

    private URI parsePath(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c >= '\u0080') {
                return null;
            }
            byte by = fgURICharMap[c];
            switch (by) {
                default: {
                    return null;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (c != '?') break;
                    return null;
                }
                case 3: {
                    if (n2 + 2 >= n) {
                        return null;
                    }
                    if ((c = string.charAt(++n2)) >= '\u0080' || fgHexCharMap[c] == 0) {
                        return null;
                    }
                    if ((c = string.charAt(++n2)) < '\u0080' && fgHexCharMap[c] != 0) break;
                    return null;
                }
            }
            ++n2;
        }
        this.fPath = string;
        return this;
    }

    private URI parseQuery(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c >= '\u0080') {
                return null;
            }
            byte by = fgURICharMap[c];
            switch (by) {
                default: {
                    return null;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (n2 + 2 >= n) {
                        return null;
                    }
                    if ((c = string.charAt(++n2)) >= '\u0080' || fgHexCharMap[c] == 0) {
                        return null;
                    }
                    if ((c = string.charAt(++n2)) < '\u0080' && fgHexCharMap[c] != 0) break;
                    return null;
                }
            }
            ++n2;
        }
        this.fQuery = string;
        return this;
    }

    private URI parseFragment(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c >= '\u0080') {
                return null;
            }
            byte by = fgURICharMap[c];
            switch (by) {
                default: {
                    return null;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (n2 + 2 >= n) {
                        return null;
                    }
                    if ((c = string.charAt(++n2)) >= '\u0080' || fgHexCharMap[c] == 0) {
                        return null;
                    }
                    if ((c = string.charAt(++n2)) < '\u0080' && fgHexCharMap[c] != 0) break;
                    return null;
                }
            }
            ++n2;
        }
        this.fFragment = string;
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.fScheme);
        stringBuffer.append(':');
        if (this.fAuthority != null) {
            stringBuffer.append('/');
            stringBuffer.append('/');
            stringBuffer.append(this.fAuthority);
        }
        stringBuffer.append(this.fPath);
        if (this.fQuery != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.fQuery);
        }
        if (this.fFragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.fFragment);
        }
        String string = stringBuffer.toString();
        return string;
    }

    public static InputStream openStream(String string) throws IOException {
        return new URL(string).openStream();
    }
}

