/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util;

public final class IntegerHashtable {
    private static final int HASHTABLE_SIZE = 128;
    private static final int INITIAL_BUCKET_COUNT = 2;
    private static final int HEADER_SIZE = 1;
    private int[][] table = new int[128][];
    private int keyCount;

    public int size() {
        return this.keyCount;
    }

    public int get(int n) {
        if (this.keyCount == 0) {
            return -1;
        }
        int n2 = n % 128;
        int[] nArray = this.table[n2];
        if (nArray != null) {
            int n3 = 1 + (nArray[0] << 1);
            int n4 = 1;
            while (n4 < n3) {
                if (n == nArray[n4]) {
                    return nArray[n4 + 1];
                }
                n4 += 2;
            }
        }
        return -1;
    }

    public int put(int n, int n2) {
        int n3 = n % 128;
        int[] nArray = this.table[n3];
        if (nArray != null) {
            int n4 = 1 + (nArray[0] << 1);
            int n5 = 1;
            while (n5 < n4) {
                if (n == nArray[n5]) {
                    int n6 = nArray[n5 + 1];
                    nArray[n5 + 1] = n2;
                    return n6;
                }
                n5 += 2;
            }
            nArray[0] = nArray[0] + 1;
            if (n4 >= nArray.length) {
                int n7 = (nArray.length << 1) - 1;
                int[] nArray2 = new int[n7];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray = nArray2;
                this.table[n3] = nArray;
            }
            nArray[n4] = n;
            nArray[n4 + 1] = n2;
        } else {
            nArray = new int[5];
            nArray[0] = 1;
            nArray[1] = n;
            nArray[2] = n2;
            this.table[n3] = nArray;
        }
        ++this.keyCount;
        return -1;
    }

    public void getKeys(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (this.keyCount > n && n2 < 128) {
            int[] nArray2 = this.table[n2];
            if (nArray2 != null) {
                int n3 = 1 + (nArray2[0] << 1);
                int n4 = 1;
                while (n4 < n3) {
                    nArray[n++] = nArray2[n4];
                    n4 += 2;
                }
            }
            ++n2;
        }
    }

    public void clear(boolean bl) {
        int n = 0;
        while (this.keyCount > 0 && n < 128) {
            int[] nArray = this.table[n];
            if (nArray != null) {
                this.keyCount -= nArray[0];
                if (bl) {
                    nArray[0] = 0;
                } else {
                    this.table[n] = null;
                }
            }
            ++n;
        }
    }
}

