/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.cache;

import com.sun.deploy.util.Trace;
import com.sun.javaws.cache.CacheImageLoaderCallback;
import com.sun.javaws.cache.CacheUtilities;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.IconDesc;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class CacheImageLoader
implements Runnable {
    private static CacheImageLoader _instance = null;
    private final Object _imageLoadingLock = new Object();
    private boolean _running = false;
    private ArrayList _toLoad = new ArrayList();

    private CacheImageLoader() {
    }

    public static CacheImageLoader getInstance() {
        if (_instance == null) {
            _instance = new CacheImageLoader();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadImage(IconDesc iconDesc, CacheImageLoaderCallback cacheImageLoaderCallback) {
        boolean bl = false;
        Object object = this._imageLoadingLock;
        synchronized (object) {
            if (!this._running) {
                this._running = true;
                bl = true;
            }
            this._toLoad.add(new LoadEntry(iconDesc, cacheImageLoaderCallback));
        }
        if (bl) {
            new Thread(this).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadImage(URL uRL, CacheImageLoaderCallback cacheImageLoaderCallback) {
        boolean bl = false;
        Object object = this._imageLoadingLock;
        synchronized (object) {
            if (!this._running) {
                this._running = true;
                bl = true;
            }
            this._toLoad.add(new LoadEntry(uRL, cacheImageLoaderCallback));
        }
        if (bl) {
            new Thread(this).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = false;
        while (!bl) {
            LoadEntry loadEntry = null;
            Object object = this._imageLoadingLock;
            synchronized (object) {
                if (this._toLoad.size() > 0) {
                    loadEntry = (LoadEntry)this._toLoad.remove(0);
                } else {
                    bl = true;
                    this._running = false;
                }
            }
            if (bl) continue;
            try {
                object = null;
                Image image = null;
                File file = null;
                URL uRL = loadEntry._url;
                if (uRL == null && (object = DownloadProtocol.getCachedVersion(loadEntry._id.getLocation(), loadEntry._id.getVersion(), 2)) != null) {
                    try {
                        file = ((DiskCacheEntry)object).getFile();
                        uRL = file.toURL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (uRL != null) {
                    image = CacheUtilities.getSharedInstance().loadImage(uRL);
                }
                if (image != null) {
                    CacheImageLoader.publish(loadEntry, image, file, false);
                }
                if (loadEntry._id == null) continue;
                new DelayedImageLoader(loadEntry, image, (DiskCacheEntry)object).start();
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException((Exception)malformedURLException);
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    private static void publish(final LoadEntry loadEntry, final Image image, final File file, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (bl) {
                    loadEntry._cb.finalImageAvailable(loadEntry._id, image, file);
                } else {
                    loadEntry._cb.imageAvailable(loadEntry._id, image, file);
                }
            }
        });
    }

    private class DelayedImageLoader
    extends Thread {
        private LoadEntry _entry;
        private Image _image;
        private DiskCacheEntry _dce;

        public DelayedImageLoader(LoadEntry loadEntry, Image image, DiskCacheEntry diskCacheEntry) {
            this._entry = loadEntry;
            this._image = image;
            this._dce = diskCacheEntry;
        }

        public void run() {
            try {
                File file = null;
                if (DownloadProtocol.isUpdateAvailable(this._entry._id.getLocation(), this._entry._id.getVersion(), 2)) {
                    this._dce = DownloadProtocol.getResource(this._entry._id.getLocation(), this._entry._id.getVersion(), 2, false, null);
                    if (this._dce != null) {
                        file = this._dce.getFile();
                    }
                    if (file != null) {
                        this._image = CacheUtilities.getSharedInstance().loadImage(file.getPath());
                    }
                    CacheImageLoader.publish(this._entry, this._image, file, false);
                } else if (this._dce != null) {
                    file = this._dce.getFile();
                }
                CacheImageLoader.publish(this._entry, this._image, file, true);
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException((Exception)malformedURLException);
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
            catch (JNLPException jNLPException) {
                Trace.ignoredException((Exception)jNLPException);
            }
        }
    }

    private class LoadEntry {
        public IconDesc _id;
        public URL _url;
        public CacheImageLoaderCallback _cb;

        public LoadEntry(IconDesc iconDesc, CacheImageLoaderCallback cacheImageLoaderCallback) {
            this._id = iconDesc;
            this._cb = cacheImageLoaderCallback;
            this._url = null;
        }

        public LoadEntry(URL uRL, CacheImageLoaderCallback cacheImageLoaderCallback) {
            this._url = uRL;
            this._cb = cacheImageLoaderCallback;
            this._id = null;
        }
    }
}

