/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Globals;
import com.sun.javaws.util.GeneralUtil;
import java.io.File;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class JnlpxArgs {
    private static final String ARG_JVM = "jnlpx.jvm";
    private static final String ARG_SPLASHPORT = "jnlpx.splashport";
    private static final String ARG_REMOVE = "jnlpx.remove";
    private static final String ARG_OFFLINE = "jnlpx.offline";
    private static final String ARG_HEAPSIZE = "jnlpx.heapsize";
    private static final String ARG_VMARGS = "jnlpx.vmargs";
    private static final String ARG_HOME = "jnlpx.home";
    private static File _currentJVMCommand = null;
    private static final String JAVAWS_JAR = Config.isDebugMode() ? "javaws_g.jar" : "javaws.jar";
    private static final String DEPLOY_JAR = Config.isDebugMode() ? "deploy_g.jar" : "deploy.jar";

    public static int getSplashPort() {
        try {
            return Integer.parseInt(System.getProperty(ARG_SPLASHPORT, "-1"));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static String getVMArgs() {
        return System.getProperty(ARG_VMARGS);
    }

    static File getJVMCommand() {
        if (_currentJVMCommand == null) {
            String string = System.getProperty(ARG_JVM, "").trim();
            if (string.startsWith("X")) {
                string = JREInfo.getDefaultJavaPath();
            }
            if (string.startsWith("\"")) {
                string = string.substring(1);
            }
            if (string.endsWith("\"")) {
                string = string.substring(0, string.length() - 1);
            }
            _currentJVMCommand = new File(string);
        }
        return _currentJVMCommand;
    }

    public static boolean shouldRemoveArgumentFile() {
        return JnlpxArgs.getBooleanProperty(ARG_REMOVE);
    }

    public static void setShouldRemoveArgumentFile(String string) {
        System.setProperty(ARG_REMOVE, string);
    }

    public static boolean isOffline() {
        return JnlpxArgs.getBooleanProperty(ARG_OFFLINE);
    }

    public static void SetIsOffline() {
        System.setProperty(ARG_OFFLINE, "true");
    }

    public static String getHeapSize() {
        return System.getProperty(ARG_HEAPSIZE);
    }

    public static long getInitialHeapSize() {
        String string = JnlpxArgs.getHeapSize();
        if (string == null) {
            return -1L;
        }
        String string2 = string.substring(string.lastIndexOf(61) + 1);
        String string3 = string2.substring(0, string2.lastIndexOf(44));
        return GeneralUtil.heapValToLong(string3);
    }

    public static long getMaxHeapSize() {
        String string = JnlpxArgs.getHeapSize();
        if (string == null) {
            return -1L;
        }
        String string2 = string.substring(string.lastIndexOf(61) + 1);
        String string3 = string2.substring(string2.lastIndexOf(44) + 1, string2.length());
        return GeneralUtil.heapValToLong(string3);
    }

    public static boolean isCurrentRunningJREHeap(long l, long l2) {
        long l3 = JnlpxArgs.getInitialHeapSize();
        long l4 = JnlpxArgs.getMaxHeapSize();
        Trace.println((String)("isCurrentRunningJREHeap: passed args: " + l + ", " + l2), (TraceLevel)TraceLevel.BASIC);
        Trace.println((String)("JnlpxArgs is " + l3 + ", " + l4), (TraceLevel)TraceLevel.BASIC);
        return l3 == l && l4 == l2;
    }

    public static boolean isAuxArgsMatch(Properties properties, String string) {
        String string2;
        String[] stringArray = Config.getSecureProperties();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            string2 = stringArray[i];
            if (!properties.containsKey(string2) || (object = properties.get(string2)) == null || object.equals(System.getProperty(string2))) continue;
            return false;
        }
        if (string != null && JnlpxArgs.getVMArgs() == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (!Config.isSecureVmArg((String)string2)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean heapSizesValid(long l, long l2) {
        return l != -1L || l2 != -1L;
    }

    public static String[] getArgumentList(String string, long l, long l2, Properties properties, String string2) {
        String string3 = "-Djnlpx.heapsize=NULL,NULL";
        String string4 = "";
        String string5 = "";
        if (JnlpxArgs.heapSizesValid(l, l2)) {
            string3 = "-Djnlpx.heapsize=" + l + "," + l2;
            if (l > 0L) {
                string4 = "-Xms" + l;
            }
            if (l2 > 0L) {
                string5 = "-Xmx" + l2;
            }
        }
        String string6 = JnlpxArgs.getDesiredVMArgs(JnlpxArgs.getVMArgs(), string2);
        String[] stringArray = new String[]{"-Xbootclasspath/a:" + Config.getJavaHome() + File.separator + "lib" + File.separator + JAVAWS_JAR + File.pathSeparator + Config.getJavaHome() + File.separator + "lib" + File.separator + DEPLOY_JAR, "-classpath", File.pathSeparator + Config.getJavaHome() + File.separator + "lib" + File.separator + DEPLOY_JAR, string4, string5, string6 != null ? "-Djnlpx.vmargs=" + string6 : "", "-Djnlpx.jvm=" + string, "-Djnlpx.splashport=" + JnlpxArgs.getSplashPort(), "-Djnlpx.home=" + Config.getJavaHome() + File.separator + "bin", "-Djnlpx.remove=" + (JnlpxArgs.shouldRemoveArgumentFile() ? "true" : "false"), "-Djnlpx.offline=" + (JnlpxArgs.isOffline() ? "true" : "false"), string3, "-Djava.security.policy=" + JnlpxArgs.getPolicyURLString(), "-DtrustProxy=true", "-Xverify:remote", JnlpxArgs.useJCOV(), JnlpxArgs.useBootClassPath(), JnlpxArgs.useJpiProfile(), JnlpxArgs.useDebugMode(), JnlpxArgs.useDebugVMMode(), "com.sun.javaws.Main", JnlpxArgs.setTCKHarnessOption(), JnlpxArgs.useLogToHost()};
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("")) continue;
            ++n;
        }
        String[] stringArray2 = JnlpxArgs.getVMArgList(properties, string2);
        int n2 = stringArray2.length;
        String[] stringArray3 = new String[n + n2];
        int n3 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            stringArray3[n3] = stringArray2[n3];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("")) continue;
            stringArray3[n3++] = stringArray[i];
        }
        return stringArray3;
    }

    static String getPolicyURLString() {
        String string;
        String string2 = string = Config.getJavaHome() + File.separator + "lib" + File.separator + "security" + File.separator + "javaws.policy";
        try {
            URL uRL = new URL("file", "", string);
            string2 = uRL.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private static String getDesiredVMArgs(String string, String string2) {
        if (string == null && string2 != null) {
            String string3 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\n\r\f\"");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (!Config.isSecureVmArg((String)string4)) continue;
                if (string3.length() == 0) {
                    string3 = string4;
                    continue;
                }
                string3 = string3 + " " + string4;
            }
            if (string3.length() > 0) {
                return string3;
            }
        }
        return string;
    }

    private static String[] getVMArgList(Properties properties, String string) {
        Object object;
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        string2 = JnlpxArgs.getVMArgs();
        if (string2 != null) {
            object = new StringTokenizer(string2, " \t\n\r\f\"");
            while (((StringTokenizer)object).hasMoreTokens()) {
                vector.add(((StringTokenizer)object).nextToken());
            }
        }
        if (string != null) {
            object = new StringTokenizer(string, " \t\n\r\f\"");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                if (!Config.isSecureVmArg((String)string3) || vector.contains(string3)) continue;
                vector.add(string3);
            }
        }
        object = Config.getSecureProperties();
        for (int i = 0; i < ((Object)object).length; ++i) {
            String string4;
            Object object2 = object[i];
            if (!properties.containsKey(object2) || vector.contains(string4 = "-D" + (String)object2 + "=" + properties.get(object2))) continue;
            vector.add(string4);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = new String((String)vector.elementAt(i));
        }
        return stringArray;
    }

    public static String useLogToHost() {
        if (Globals.LogToHost != null) {
            return "-XX:LogToHost=" + Globals.LogToHost;
        }
        return "";
    }

    public static String setTCKHarnessOption() {
        if (Globals.TCKHarnessRun) {
            return "-XX:TCKHarnessRun=true";
        }
        return "";
    }

    public static String useBootClassPath() {
        if (Globals.BootClassPath.equals("NONE")) {
            return "";
        }
        return "-Xbootclasspath" + Globals.BootClassPath;
    }

    public static String useJpiProfile() {
        String string = System.getProperty("javaplugin.user.profile");
        if (string != null) {
            return "-Djavaplugin.user.profile=" + string;
        }
        return "";
    }

    public static String useJCOV() {
        if (Globals.JCOV.equals("NONE")) {
            return "";
        }
        return "-Xrunjcov:file=" + Globals.JCOV;
    }

    public static String useDebugMode() {
        if (Config.isDebugMode()) {
            return "-Ddeploy.debugMode=true";
        }
        return "";
    }

    public static String useDebugVMMode() {
        if (Config.isDebugVMMode()) {
            return "-Ddeploy.useDebugJavaVM=true";
        }
        return "";
    }

    public static void removeArgumentFile(String[] stringArray) {
        if (JnlpxArgs.shouldRemoveArgumentFile() && stringArray != null && stringArray.length > 0) {
            new File(stringArray[0]).delete();
        }
    }

    static void verify() {
        Trace.println((String)"Java part started", (TraceLevel)TraceLevel.BASIC);
        Trace.println((String)("jnlpx.jvm: " + JnlpxArgs.getJVMCommand()), (TraceLevel)TraceLevel.BASIC);
        Trace.println((String)("jnlpx.splashport: " + JnlpxArgs.getSplashPort()), (TraceLevel)TraceLevel.BASIC);
        Trace.println((String)("jnlpx.remove: " + JnlpxArgs.shouldRemoveArgumentFile()), (TraceLevel)TraceLevel.BASIC);
        Trace.println((String)("jnlpx.heapsize: " + JnlpxArgs.getHeapSize()), (TraceLevel)TraceLevel.BASIC);
    }

    private static boolean getBooleanProperty(String string) {
        String string2 = System.getProperty(string, "false");
        return string2 != null && string2.equals("true");
    }
}

