/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class SourceCmd
implements Command {
    SourceCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        String fileName = null;
        boolean url = false;
        if (argv.length == 2) {
            fileName = argv[1].toString();
        } else if (argv.length == 3 && argv[1].toString().equals("-url")) {
            url = true;
            fileName = argv[2].toString();
        }
        if (fileName == null) {
            throw new TclNumArgsException(interp, 1, argv, "?-url? fileName");
        }
        try {
            if (url) {
                if (fileName.startsWith("resource:/")) {
                    interp.evalResource(fileName.substring(9));
                } else {
                    interp.evalURL(null, fileName);
                }
            } else {
                interp.evalFile(fileName);
            }
        }
        catch (TclException e) {
            int code = e.getCompletionCode();
            if (code == 2) {
                int realCode = interp.updateReturnInfo();
                if (realCode != 0) {
                    e.setCompletionCode(realCode);
                    throw e;
                }
            }
            if (code == 1) {
                interp.addErrorInfo("\n    (file line " + interp.errorLine + ")");
                throw e;
            }
            throw e;
        }
    }
}

