/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

final class QSort {
    static final int ASCII = 0;
    static final int INTEGER = 1;
    static final int REAL = 2;
    static final int COMMAND = 3;
    static final int DICTIONARY = 4;
    private int sortMode;
    private int sortIndex;
    private boolean sortIncreasing;
    private String sortCommand;
    private Interp sortInterp;

    QSort() {
    }

    private final void quickSort(TclObject[] a, int lo0, int hi0) throws TclException {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            TclObject mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && this.compare(a[lo], mid) < 0) {
                    ++lo;
                }
                while (hi > lo0 && this.compare(a[hi], mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                QSort.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
    }

    private static final void swap(TclObject[] a, int i, int j) {
        TclObject T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    final void sort(Interp interp, TclObject[] a, int mode, int index, boolean increasing, String cmd) throws TclException {
        this.sortInterp = interp;
        this.sortMode = mode;
        this.sortIndex = index;
        this.sortIncreasing = increasing;
        this.sortCommand = cmd;
        this.quickSort(a, 0, a.length - 1);
    }

    private final int compare(TclObject obj1, TclObject obj2) throws TclException {
        int code = 0;
        if (this.sortIndex != -1) {
            int index = this.sortIndex < -1 ? TclList.getLength(this.sortInterp, obj1) - 1 : this.sortIndex;
            TclObject obj = TclList.index(this.sortInterp, obj1, index);
            if (obj == null) {
                throw new TclException(this.sortInterp, "element " + index + " missing from sublist \"" + obj1 + "\"");
            }
            obj1 = obj;
            index = this.sortIndex < -1 ? TclList.getLength(this.sortInterp, obj2) - 1 : this.sortIndex;
            obj = TclList.index(this.sortInterp, obj2, index);
            if (obj == null) {
                throw new TclException(this.sortInterp, "element " + index + " missing from sublist \"" + obj2 + "\"");
            }
            obj2 = obj;
        }
        switch (this.sortMode) {
            case 0: {
                code = obj1.toString().compareTo(obj2.toString());
                break;
            }
            case 4: {
                code = this.doDictionary(obj1.toString(), obj2.toString());
                break;
            }
            case 1: {
                try {
                    int int1 = TclInteger.get(this.sortInterp, obj1);
                    int int2 = TclInteger.get(this.sortInterp, obj2);
                    if (int1 > int2) {
                        code = 1;
                        break;
                    }
                    if (int2 <= int1) break;
                    code = -1;
                    break;
                }
                catch (TclException e1) {
                    this.sortInterp.addErrorInfo("\n    (converting list element from string to integer)");
                    throw e1;
                }
            }
            case 2: {
                try {
                    double f1 = TclDouble.get(this.sortInterp, obj1);
                    double f2 = TclDouble.get(this.sortInterp, obj2);
                    if (f1 > f2) {
                        code = 1;
                        break;
                    }
                    if (!(f2 > f1)) break;
                    code = -1;
                    break;
                }
                catch (TclException e2) {
                    this.sortInterp.addErrorInfo("\n    (converting list element from string to real)");
                    throw e2;
                }
            }
            case 3: {
                StringBuffer sbuf = new StringBuffer(this.sortCommand);
                Util.appendElement(this.sortInterp, sbuf, obj1.toString());
                Util.appendElement(this.sortInterp, sbuf, obj2.toString());
                try {
                    this.sortInterp.eval(sbuf.toString(), 0);
                }
                catch (TclException e3) {
                    this.sortInterp.addErrorInfo("\n    (user-defined comparison command)");
                    throw e3;
                }
                try {
                    code = TclInteger.get(this.sortInterp, this.sortInterp.getResult());
                    break;
                }
                catch (TclException e) {
                    this.sortInterp.resetResult();
                    TclException e4 = new TclException(this.sortInterp, "comparison command returned non-numeric result");
                    throw e4;
                }
            }
            default: {
                throw new TclRuntimeError("Unknown sortMode " + this.sortMode);
            }
        }
        if (this.sortIncreasing) {
            return code;
        }
        return -code;
    }

    private final int doDictionary(String str1, String str2) {
        int diff = 0;
        int secondaryDiff = 0;
        boolean cont = true;
        int i1 = 0;
        int i2 = 0;
        int len1 = str1.length();
        int len2 = str2.length();
        block0: while (cont && i1 < len1 && i2 < len2) {
            if (Character.isDigit(str2.charAt(i2)) && Character.isDigit(str1.charAt(i1))) {
                int zeros = 0;
                while (i2 < len2 - 1 && str2.charAt(i2) == '0') {
                    ++i2;
                    --zeros;
                }
                while (i1 < len1 - 1 && str1.charAt(i1) == '0') {
                    ++i1;
                    ++zeros;
                }
                if (secondaryDiff == 0) {
                    secondaryDiff = zeros;
                }
                diff = 0;
                do {
                    if (i1 >= len1 || i2 >= len2) {
                        cont = false;
                        continue block0;
                    }
                    if (diff == 0) {
                        diff = str1.charAt(i1) - str2.charAt(i2);
                    }
                    if (++i1 >= len1 || ++i2 >= len2) {
                        cont = false;
                        continue block0;
                    }
                    if (Character.isDigit(str2.charAt(i2))) continue;
                    if (Character.isDigit(str1.charAt(i1))) {
                        return 1;
                    }
                    if (diff == 0) continue block0;
                    return diff;
                } while (Character.isDigit(str1.charAt(i1)));
                return -1;
            }
            diff = str1.charAt(i1) - str2.charAt(i2);
            if (diff != 0) {
                if (Character.isUpperCase(str1.charAt(i1)) && Character.isLowerCase(str2.charAt(i2))) {
                    diff = Character.toLowerCase(str1.charAt(i1)) - str2.charAt(i2);
                    if (diff != 0) {
                        return diff;
                    }
                    if (secondaryDiff == 0) {
                        secondaryDiff = -1;
                    }
                } else if (Character.isUpperCase(str2.charAt(i2)) && Character.isLowerCase(str1.charAt(i1))) {
                    diff = str1.charAt(i1) - Character.toLowerCase(str2.charAt(i2));
                    if (diff != 0) {
                        return diff;
                    }
                    if (secondaryDiff == 0) {
                        secondaryDiff = 1;
                    }
                } else {
                    return diff;
                }
            }
            ++i1;
            ++i2;
        }
        if (i1 >= len1 && i2 < len2) {
            if (!Character.isDigit(str2.charAt(i2))) {
                return 1;
            }
            return -1;
        }
        if (i2 >= len2 && i1 < len1) {
            if (!Character.isDigit(str1.charAt(i1))) {
                return -1;
            }
            return 1;
        }
        if (diff == 0) {
            diff = secondaryDiff;
        }
        return diff;
    }
}

