/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.model.internal.validation.ATypeVRule;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBType;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.ITypeConstants;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public abstract class ABeanClassVRule
extends ATypeVRule
implements IEJBType {
    protected static final long[] BASE_TYPES = new long[]{ITypeConstants.JAVA_LANG_OBJECT};
    protected static final int MESSAGE_REMOTE_EXCEPTION_SEVERITY = 2;

    public long[] getBaseTypes() {
        return BASE_TYPES;
    }

    public Object getTarget(Object parent, Object clazz) {
        if (parent == null) {
            return null;
        }
        return ((EnterpriseBean)parent).getEjbClass();
    }

    public long getDefaultMethodType() {
        return HELPER;
    }

    public void validate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws ValidationCancelledException, InvalidInputException, ValidationException {
        IMessage message;
        if (!this.followAbstractRules(clazz)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2014", 2, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!this.followPublicRules(clazz)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2022", 2, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!this.followFinalRules(clazz)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2015", 2, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateAppendixB(vc, bean, clazz);
    }

    public static final List getRemoteHomeMethodsExtended(List[] methodsExtendedList) {
        return methodsExtendedList[0];
    }

    public static final List getLocalHomeMethodsExtended(List[] methodsExtendedList) {
        return methodsExtendedList[1];
    }

    public static final List getRemoteComponentMethodsExtended(List[] methodsExtendedList) {
        return methodsExtendedList[2];
    }

    public static final List getLocalComponentMethodsExtended(List[] methodsExtendedList) {
        return methodsExtendedList[3];
    }

    public static final List getBeanClassMethodsExtended(List[] methodsExtendedList) {
        return methodsExtendedList[4];
    }

    public final List[] getMethodsExtended(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) {
        List[] result = new List[5];
        JavaClass remoteHome = bean.getHomeInterface();
        result[0] = remoteHome != null ? remoteHome.getMethodsExtended() : null;
        JavaClass localHome = bean.getLocalHomeInterface();
        result[1] = localHome != null ? localHome.getMethodsExtended() : null;
        JavaClass remoteComponent = bean.getRemoteInterface();
        result[2] = remoteComponent != null ? remoteComponent.getMethodsExtended() : null;
        JavaClass localComponent = bean.getLocalInterface();
        result[3] = localComponent != null ? localComponent.getMethodsExtended() : null;
        JavaClass beanClass = bean.getEjbClass();
        result[4] = beanClass != null ? beanClass.getMethodsExtended() : null;
        return result;
    }

    public final List[] getFieldsExtended(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) {
        return null;
    }

    protected abstract boolean shouldBeFinal(JavaClass var1);

    protected abstract boolean shouldBePublic(JavaClass var1);

    protected abstract boolean shouldBeAbstract(JavaClass var1);

    protected abstract boolean shouldValidateTransientField();

    protected abstract JavaHelpers getEjbCreateReturnType(EnterpriseBean var1, Method var2) throws InvalidInputException;

    protected abstract String getEjbCreateReturnTypeName(EnterpriseBean var1, Method var2) throws InvalidInputException;

    public abstract String getMatchingHomeMethodName(IEJBValidationContext var1, EnterpriseBean var2, JavaClass var3, Method var4, List[] var5);

    public String getMatchingEjbHomeMethodName(IEJBValidationContext vc, Method method2) {
        String methodName = method2.getName();
        StringBuffer buffer = new StringBuffer(Character.toLowerCase(methodName.charAt(0)));
        buffer.append(method2.getName().substring(8));
        return buffer.toString();
    }

    public String getMatchingEjbCreateMethodName(IEJBValidationContext vc, Method method2) {
        StringBuffer buffer = new StringBuffer("c");
        buffer.append(method2.getName().substring(4));
        return buffer.toString();
    }

    public String getMatchingEjbPostCreateMethodName(IEJBValidationContext vc, Method method2) {
        StringBuffer buffer = new StringBuffer("c");
        buffer.append(method2.getName().substring(8));
        return buffer.toString();
    }

    public String getMatchingEjbFindMethodName(IEJBValidationContext vc, Method method2) {
        StringBuffer buffer = new StringBuffer("f");
        buffer.append(method2.getName().substring(4));
        return buffer.toString();
    }

    public String getMatchingBusinessMethodName(IEJBValidationContext vc, Method method2) {
        return method2.getName();
    }

    public String getNoMatchingMethodName(IEJBValidationContext vc, Method method2) {
        return null;
    }

    public final boolean followFinalRules(JavaClass clazz) {
        if (this.shouldBeFinal(clazz)) {
            return clazz.isFinal();
        }
        return !clazz.isFinal();
    }

    public final boolean followPublicRules(JavaClass clazz) {
        if (this.shouldBePublic(clazz)) {
            return clazz.isPublic();
        }
        return !clazz.isPublic();
    }

    public final boolean followAbstractRules(JavaClass clazz) {
        if (this.shouldBeAbstract(clazz)) {
            return clazz.isAbstract();
        }
        return !clazz.isAbstract();
    }

    public void validateEjbCreateMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) throws ValidationCancelledException, InvalidInputException, ValidationException {
        JavaHelpers retType;
        IMessage message;
        if (!ValidationRuleUtility.isPublic(method2)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2421", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method2.isFinal()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2422", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method2.isStatic()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2423", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        if ((retType = this.getEjbCreateReturnType(bean, method2)) == null || !ValidationRuleUtility.isAssignableFrom(method2.getReturnType(), retType)) {
            String retTypeName = retType == null ? this.getEjbCreateReturnTypeName(bean, method2) : retType.getJavaName();
            IMessage message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2424", 2, bean, clazz, method2, new String[]{retTypeName}, (IValidationRule)this);
            vc.addMessage(message2);
        }
        this.validateRMI_IIOPTypeRules(vc, bean, clazz, method2, methodsExtendedLists, true);
        if (this.validateEjbCreateMethodExceptions() && !this.followRemoteExceptionRules(bean, method2)) {
            IMessage message3 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2503.ejbCreate", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message3);
        }
    }

    public boolean validateEjbCreateMethodExceptions() {
        return true;
    }

    public void validateEjbPostCreateMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws ValidationCancelledException, InvalidInputException, ValidationException {
        IMessage message;
        if (!ValidationRuleUtility.isPublic(method2)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2426", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method2.isFinal()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2427", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method2.isStatic()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2428", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!method2.isVoid()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2505.ejbPostCreate", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!this.followRemoteExceptionRules(bean, method2)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2503.ejbPostCreate", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public final void validateEjbHomeMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) throws ValidationCancelledException, InvalidInputException, ValidationException {
        IMessage message;
        if (!ValidationRuleUtility.isPublic(method2)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2431", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method2.isStatic()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2439", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateRMI_IIOPTypeRules(vc, bean, clazz, method2, methodsExtendedLists, true);
        if (!this.followRemoteExceptionRules(bean, method2)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2503.ejbHome", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(Character.toLowerCase(method2.getName().charAt(7)));
        buffer.append(method2.getName().substring(8));
        String methodToMatchName = buffer.toString();
        Method matchingRemoteHomeMethod = ValidationRuleUtility.getMethod(method2, methodToMatchName, ABeanClassVRule.getRemoteHomeMethodsExtended(methodsExtendedLists));
        if (matchingRemoteHomeMethod != null) {
            return;
        }
        Method matchingLocalHomeMethod = ValidationRuleUtility.getMethod(method2, methodToMatchName, ABeanClassVRule.getLocalHomeMethodsExtended(methodsExtendedLists));
        if (matchingLocalHomeMethod != null) {
            return;
        }
        IMessage message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2430", 4, bean, clazz, method2, new String[]{methodToMatchName}, (IValidationRule)this);
        vc.addMessage(message2);
    }

    public final void validateBusinessMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) throws ValidationCancelledException, InvalidInputException, ValidationException {
        IMessage message;
        if (method2.getName().startsWith("ejb")) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2411", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!ValidationRuleUtility.isPublic(method2)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2441", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method2.isFinal()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2442", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method2.isStatic()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2443", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateRMI_IIOPTypeRules(vc, bean, clazz, method2, methodsExtendedLists, true);
        if (!this.followRemoteExceptionRules(bean, method2)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2503.bus", this.getMessageRemoteExceptionSeverity(), bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateMatchingComponentMethod(vc, bean, clazz, method2, methodsExtendedLists);
    }

    public void validateEjbRemoveMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws ValidationCancelledException, InvalidInputException, ValidationException {
        IMessage message;
        if (!ValidationRuleUtility.isPublic(method2)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2492", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method2.isFinal()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2493", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method2.isStatic()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2494", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!method2.isVoid()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2505.ejbRemove", 2, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field, List[] fieldExtendedLists) throws ValidationCancelledException, InvalidInputException, ValidationException {
        if (this.shouldValidateTransientField()) {
            this.validateTransientField(vc, bean, clazz, field);
        }
    }

    public void validateTransientField(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field) throws ValidationCancelledException, InvalidInputException, ValidationException {
    }

    public long getFieldType(EnterpriseBean bean, JavaClass clazz, Field field) {
        if (field == null) {
            return EXCLUDED_FIELD;
        }
        if (field.getName().equals("serialVersionUID")) {
            return SERIALVERSIONUID;
        }
        return OTHER_FIELD;
    }

    public void validateMatchingMethodExceptions(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2, JavaClass matchingClazz, Method matchingMethod) {
        Set exceptions2 = ValidationRuleUtility.getNotSubsetSubtypeExceptions(bean, matchingMethod, method2);
        Iterator eiterator = exceptions2.iterator();
        while (eiterator.hasNext()) {
            JavaClass exception = (JavaClass)eiterator.next();
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2456", 2, bean, clazz, method2, new String[]{exception.getJavaName(), matchingClazz.getJavaName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public final void validateMatchingHomeMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
        Method localMethod;
        Method remoteMethod = ValidationRuleUtility.getMethod(method2, this.getMatchingHomeMethodName(vc, bean, clazz, method2, methodsExtendedLists), ABeanClassVRule.getRemoteHomeMethodsExtended(methodsExtendedLists));
        if (remoteMethod != null) {
            this.validateMatchingMethodExceptions(vc, bean, clazz, method2, bean.getHomeInterface(), remoteMethod);
        }
        if ((localMethod = ValidationRuleUtility.getMethod(method2, this.getMatchingHomeMethodName(vc, bean, clazz, method2, methodsExtendedLists), ABeanClassVRule.getLocalHomeMethodsExtended(methodsExtendedLists))) != null) {
            this.validateMatchingMethodExceptions(vc, bean, clazz, method2, bean.getLocalHomeInterface(), localMethod);
        }
    }

    public final void validateMatchingComponentMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
        Method localMethod;
        Method remoteMethod = ValidationRuleUtility.getMethod(method2, method2.getName(), ABeanClassVRule.getRemoteComponentMethodsExtended(methodsExtendedLists));
        if (remoteMethod != null) {
            this.validateMatchingMethodExceptions(vc, bean, clazz, method2, bean.getRemoteInterface(), remoteMethod);
        }
        if ((localMethod = ValidationRuleUtility.getMethod(method2, method2.getName(), ABeanClassVRule.getLocalComponentMethodsExtended(methodsExtendedLists))) != null) {
            this.validateMatchingMethodExceptions(vc, bean, clazz, method2, bean.getLocalInterface(), localMethod);
        }
    }

    protected void validateAppendixB(IEJBValidationContext vc, EnterpriseBean bean, JavaClass thisEjbObject) {
        if (bean == null) {
            return;
        }
        EnterpriseBean supertype = this.getSuperType(bean);
        JavaClass parentEjbObject = null;
        if (supertype != null) {
            parentEjbObject = supertype.getEjbClass();
            try {
                ValidationRuleUtility.isValidType(thisEjbObject);
                ValidationRuleUtility.isValidType(parentEjbObject);
                if (!ValidationRuleUtility.isAssignableFrom(thisEjbObject, parentEjbObject)) {
                    String[] msgParm = new String[]{thisEjbObject.getQualifiedName(), parentEjbObject.getQualifiedName()};
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2103", 1, bean, thisEjbObject, msgParm, (IValidationRule)this);
                    vc.addMessage(message);
                }
            }
            catch (InvalidInputException e) {
                String[] msgParm = new String[]{e.getJavaClass().getQualifiedName(), bean.getName()};
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2849", 2, bean, msgParm, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }

    public final boolean followRemoteExceptionRules(EnterpriseBean bean, Method method2) throws InvalidInputException, ValidationCancelledException {
        return ValidationRuleUtility.doesNotThrowRemoteException(bean, method2);
    }
}

