/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.core.internal.plugin;

import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.core.internal.plugin.Assert;
import org.eclipse.jst.j2ee.internal.EjbModuleExtensionHelper;
import org.eclipse.jst.j2ee.internal.IEJBModelExtenderProvider;
import org.eclipse.wst.common.frameworks.internal.enablement.Identifiable;
import org.eclipse.wst.common.frameworks.internal.enablement.IdentifiableComparator;

public class EclipseEJBModelExtenderProvider
extends RegistryReader
implements IEJBModelExtenderProvider {
    private SortedSet extensionHelpers;
    private static EclipseEJBModelExtenderProvider INSTANCE = null;

    protected EclipseEJBModelExtenderProvider() {
        super("org.eclipse.jst.j2ee.core", "ejbModelExtender");
    }

    public static EclipseEJBModelExtenderProvider getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EclipseEJBModelExtenderProvider();
            INSTANCE.readRegistry();
        }
        return INSTANCE;
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals("ejbModelExtender")) {
            return false;
        }
        this.addModuleExtension(new Descriptor(element));
        return true;
    }

    private void addModuleExtension(Descriptor descriptor) {
        this.getExtensionHelpers().add(descriptor);
    }

    public EjbModuleExtensionHelper getEJBModuleExtension(Object context) {
        if (this.getExtensionHelpers().isEmpty()) {
            return null;
        }
        Descriptor descriptor = (Descriptor)this.getExtensionHelpers().first();
        if (descriptor != null) {
            return descriptor.getInstance();
        }
        return null;
    }

    public boolean hasEJBModuleExtension(Object context) {
        return false;
    }

    protected SortedSet getExtensionHelpers() {
        if (this.extensionHelpers == null) {
            this.extensionHelpers = new TreeSet(IdentifiableComparator.getInstance());
        }
        return this.extensionHelpers;
    }

    public static class Descriptor
    implements Identifiable {
        public static final String EJB_MODEL_EXTENDER = "ejbModelExtender";
        public static final String ATT_ID = "id";
        public static final String ATT_EJB_EXTENSION_CLASS = "extensionClass";
        private static int loadOrderCounter = 0;
        private final String id;
        private final int loadOrder;
        private IConfigurationElement element;
        private EjbModuleExtensionHelper instance;

        public Descriptor(IConfigurationElement element) {
            Assert.isLegal(EJB_MODEL_EXTENDER.equals(element.getName()), "Invalid IConfigurationElement used to create EclipseEJBModelExtenderProvider.Descriptor.");
            this.element = element;
            this.id = this.element.getAttribute(ATT_ID);
            this.loadOrder = loadOrderCounter++;
        }

        public String getID() {
            return this.id;
        }

        public int getLoadOrder() {
            return this.loadOrder;
        }

        public EjbModuleExtensionHelper getInstance() {
            try {
                if (this.instance == null) {
                    this.instance = (EjbModuleExtensionHelper)this.element.createExecutableExtension(ATT_EJB_EXTENSION_CLASS);
                }
            }
            catch (CoreException e) {
                Logger.getLogger().logError(e);
            }
            return this.instance;
        }
    }
}

