/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

public class ArchiveOptions
implements Cloneable {
    public static final int SAX = 1;
    public static final int DOM = 2;
    public static final int DEFAULT = 3;
    private int rendererType = 3;
    public static final int LOAD_MODE_COMPAT = 0;
    public static final int LOAD_MODE_SPEC = 1;
    private int classLoadingMode = 0;
    private LoadStrategy loadStrategy;
    private boolean useJavaReflection = true;
    private boolean isReadOnly;
    private boolean saveLibrariesAsFiles = true;
    private boolean saveOnlyDirtyMofResources = true;
    private boolean discriminateNestedArchives = false;
    private Map readOnlyFlags;
    private ProtectionDomain protectionDomain;

    public Object clone() {
        return this.cloneWith(null);
    }

    public ArchiveOptions cloneWith(LoadStrategy aLoadStrategy) {
        try {
            ArchiveOptions result = (ArchiveOptions)super.clone();
            result.setLoadStrategy(aLoadStrategy);
            result.readOnlyFlags = null;
            return result;
        }
        catch (CloneNotSupportedException ignore) {
            return null;
        }
    }

    public ArchiveOptions cloneWith(LoadStrategy aLoadStrategy, String uri) {
        ArchiveOptions result = this.cloneWith(aLoadStrategy);
        result.setIsReadOnly(this.isReadOnly(uri));
        return result;
    }

    public LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean saveOnlyDirtyMofResources() {
        return this.saveOnlyDirtyMofResources;
    }

    public void setIsReadOnly(boolean newIsReadOnly) {
        this.isReadOnly = newIsReadOnly;
    }

    public void setIsReadOnly(boolean readOnly, String uri) {
        if (this.readOnlyFlags == null) {
            this.readOnlyFlags = new HashMap();
        }
        this.readOnlyFlags.put(uri, new Boolean(readOnly));
    }

    public boolean isReadOnly(String uri) {
        Boolean bool;
        if (this.readOnlyFlags != null && (bool = (Boolean)this.readOnlyFlags.get(uri)) != null) {
            return bool;
        }
        return this.isReadOnly;
    }

    public void setLoadStrategy(LoadStrategy newLoadStrategy) {
        this.loadStrategy = newLoadStrategy;
        this.loadStrategy.setReadOnly(this.isReadOnly());
        this.loadStrategy.setRendererType(this.getRendererType());
    }

    public void setSaveOnlyDirtyMofResources(boolean newSaveOnlyDirtyMofResources) {
        this.saveOnlyDirtyMofResources = newSaveOnlyDirtyMofResources;
    }

    public void setUseJavaReflection(boolean newUseJavaReflection) {
        this.useJavaReflection = newUseJavaReflection;
    }

    public boolean useJavaReflection() {
        return this.useJavaReflection;
    }

    public boolean isSaveLibrariesAsFiles() {
        return this.saveLibrariesAsFiles;
    }

    public void setSaveLibrariesAsFiles(boolean saveLibrariesAsFiles) {
        this.saveLibrariesAsFiles = saveLibrariesAsFiles;
    }

    public boolean shouldDiscriminateNestedArchives() {
        return this.discriminateNestedArchives;
    }

    public void setDiscriminateNestedArchives(boolean discriminateNestedArchives) {
        this.discriminateNestedArchives = discriminateNestedArchives;
    }

    public int getRendererType() {
        return this.rendererType;
    }

    public void setRendererType(int rendererType) {
        this.rendererType = rendererType;
    }

    public int getClassLoadingMode() {
        return this.classLoadingMode;
    }

    public void setClassLoadingMode(int classLoadingMode) {
        this.classLoadingMode = classLoadingMode;
    }

    public void setProtectionDomain(ProtectionDomain protectionDomain) {
        this.protectionDomain = protectionDomain;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }
}

