/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util;

import java.util.EventObject;
import org.eclipse.jem.util.NotPresentPerformanceMonitor;

public abstract class PerformanceMonitorUtil {
    private PerformanceListener[] listeners;
    private static PerformanceMonitorUtil sharedMonitor;

    public static PerformanceMonitorUtil getMonitor() {
        if (sharedMonitor == null) {
            try {
                Class.forName("org.eclipse.perfmsr.core.PerfMsrCorePlugin");
                Class<?> presentClass = Class.forName("org.eclipse.jem.util.PresentPerformanceMonitor");
                sharedMonitor = (PerformanceMonitorUtil)presentClass.newInstance();
                if (!sharedMonitor.isValid()) {
                    sharedMonitor = null;
                }
            }
            catch (RuntimeException runtimeException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            if (sharedMonitor == null) {
                sharedMonitor = new NotPresentPerformanceMonitor();
            }
        }
        return sharedMonitor;
    }

    protected boolean isValid() {
        return true;
    }

    public abstract void setVar(String var1);

    public final void snapshot(int step) {
        this.doSnapshot(step);
        if (this.listeners != null) {
            this.notifySnapshot(new PerformanceEvent(this, step));
        }
    }

    private void notifySnapshot(PerformanceEvent event2) {
        PerformanceListener[] list = this.listeners;
        int i = 0;
        while (i < list.length) {
            list[i].snapshot(event2);
            ++i;
        }
    }

    protected abstract void doSnapshot(int var1);

    public void snapshot(int step, int types2) {
        this.doSnapshot(step, types2);
        if (this.listeners != null) {
            this.notifySnapshot(new PerformanceEvent(this, step, types2));
        }
    }

    protected abstract void doSnapshot(int var1, int var2);

    public void addPerformanceListener(PerformanceListener listener) {
        if (this.findListener(listener) != -1) {
            return;
        }
        PerformanceListener[] newList = new PerformanceListener[this.listeners != null ? this.listeners.length + 1 : 1];
        if (this.listeners != null) {
            System.arraycopy(this.listeners, 0, newList, 0, this.listeners.length);
        }
        newList[newList.length - 1] = listener;
        this.listeners = newList;
    }

    private int findListener(PerformanceListener listener) {
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.length) {
                if (this.listeners[i] == listener) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void removePerformanceListener(PerformanceListener listener) {
        int index = this.findListener(listener);
        if (index != -1) {
            if (this.listeners.length == 1) {
                this.listeners = null;
                return;
            }
            PerformanceListener[] newList = new PerformanceListener[this.listeners.length - 1];
            System.arraycopy(this.listeners, 0, newList, 0, index);
            System.arraycopy(this.listeners, index + 1, newList, index, newList.length - index);
            this.listeners = newList;
        }
    }

    public boolean upload(String description) {
        return false;
    }

    public static class PerformanceEvent
    extends EventObject {
        private static final long serialVersionUID = -4680071462750180339L;
        public final boolean snapshowWithTypes;
        public final int step;
        public final int types;

        PerformanceEvent(Object source, int step) {
            super(source);
            this.snapshowWithTypes = false;
            this.step = step;
            this.types = 0;
        }

        PerformanceEvent(Object source, int step, int types2) {
            super(source);
            this.snapshowWithTypes = true;
            this.step = step;
            this.types = types2;
        }
    }

    public static interface PerformanceListener {
        public void snapshot(PerformanceEvent var1);
    }

    public static interface Types {
        public static final int OperatingSystemCounters = 1;
        public static final int GlobalSystemCounters = 2;
        public static final int JavaHeapSize = 4;
        public static final int JavaHeapUsed = 8;
        public static final int PluginInfo = 16;
        public static final int All = 65535;
    }
}

