/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.util.emf.workbench;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ResourceHandler;
import org.eclipse.jem.util.emf.workbench.ResourceSetWorkbenchSynchronizer;
import org.eclipse.jem.util.emf.workbench.nature.EMFNature;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;

public class ProjectResourceSetImpl
extends ResourceSetImpl
implements ProjectResourceSet {
    private boolean isReleasing = false;
    private IProject project;
    protected List resourceHandlers = new ArrayList();
    protected ResourceSetWorkbenchSynchronizer synchronizer;

    protected ProjectResourceSetImpl() {
        this.setURIResourceMap(new HashMap(10));
        this.getLoadOptions().put("USE_PARSER_POOL", EMFNature.SHARED_PARSER_POOL);
    }

    public ProjectResourceSetImpl(IProject aProject) {
        this();
        this.setProject(aProject);
        this.initializeSharedCacheListener();
    }

    protected void initializeSharedCacheListener() {
        JEMUtilPlugin.getSharedCache().beginListening(this);
    }

    protected boolean isReleasing() {
        return this.isReleasing;
    }

    protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
        Resource res = super.delegatedGetResource(uri, loadOnDemand);
        if (res == null) {
            res = this.getResourceFromHandlers(uri);
        }
        return res;
    }

    public Resource createResource(URI uri) {
        Resource result;
        if (this.isReleasing) {
            return null;
        }
        boolean isMapped = !((URIConverterImpl.URIMap)this.getURIConverter().getURIMap()).getURI(uri).equals(uri);
        URI converted = uri;
        if (!isMapped) {
            converted = this.getURIConverter().normalize(uri);
        }
        if ((result = this.createResourceFromHandlers(converted)) == null) {
            result = super.createResource(converted);
        }
        return result;
    }

    protected void demandLoad(Resource resource) throws IOException {
        if (!this.isReleasing) {
            super.demandLoad(resource);
        }
    }

    protected Resource createResourceFromHandlers(URI uri) {
        Resource resource = null;
        ResourceHandler handler = null;
        int i = 0;
        while (i < this.resourceHandlers.size()) {
            handler = (ResourceHandler)this.resourceHandlers.get(i);
            resource = handler.createResource(this, uri);
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    protected Resource getResourceFromHandlers(URI uri) {
        if (this.isReleasing) {
            return null;
        }
        int i = 0;
        while (i < this.resourceHandlers.size()) {
            Resource resource = ((ResourceHandler)this.resourceHandlers.get(i)).getResource(this, uri);
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    public void release() {
        if (this.eNotificationRequired()) {
            this.eNotify(new NotificationImpl(14, null, null, -1, false){

                public int getFeatureID(Class expectedClass) {
                    return 1000;
                }

                public Object getNotifier() {
                    return ProjectResourceSetImpl.this;
                }
            });
        }
        this.setIsReleasing(true);
        if (this.synchronizer != null) {
            this.synchronizer.dispose();
        }
        this.synchronizer = null;
        this.removeAndUnloadAllResources();
        this.resourceHandlers = null;
        this.eAdapters().clear();
        this.setProject(null);
        JEMUtilPlugin.getSharedCache().stopListening(this);
    }

    protected void removeAndUnloadAllResources() {
        boolean caughtException = false;
        if (this.getResources().isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList(this.getResources());
        this.getResources().clear();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Resource res = (Resource)list.get(i);
            try {
                res.unload();
            }
            catch (RuntimeException ex) {
                Logger.getLogger().logError(ex);
                caughtException = true;
            }
            ++i;
        }
        if (caughtException) {
            throw new RuntimeException("Exception(s) unloading resources - check log files");
        }
    }

    protected void setIsReleasing(boolean aBoolean) {
        this.isReleasing = aBoolean;
    }

    public IProject getProject() {
        return this.project;
    }

    protected void setProject(IProject project) {
        this.project = project;
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        if (this.isReleasing) {
            return null;
        }
        Resource resource = this.getResource(uri.trimFragment(), loadOnDemand);
        EObject result = null;
        if (resource != null && resource.isLoaded()) {
            result = resource.getEObject(uri.fragment());
        }
        if (result == null) {
            result = this.getEObjectFromHandlers(uri, loadOnDemand);
        }
        return result;
    }

    protected EObject getEObjectFromHandlers(URI uri, boolean loadOnDemand) {
        EObject obj = null;
        ResourceHandler handler = null;
        int i = 0;
        while (i < this.resourceHandlers.size()) {
            handler = (ResourceHandler)this.resourceHandlers.get(i);
            obj = handler.getEObjectFailed(this, uri, loadOnDemand);
            if (obj != null) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    public boolean add(ResourceHandler resourceHandler) {
        return this.resourceHandlers.add(resourceHandler);
    }

    public void addFirst(ResourceHandler resourceHandler) {
        this.resourceHandlers.add(0, resourceHandler);
    }

    public boolean remove(ResourceHandler resourceHandler) {
        return this.resourceHandlers.remove(resourceHandler);
    }

    public ResourceSetWorkbenchSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public void setSynchronizer(ResourceSetWorkbenchSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public void setResourceFactoryRegistry(Resource.Factory.Registry factoryReg) {
        if (this.resourceFactoryRegistry != null && factoryReg != null) {
            this.preserveEntries(factoryReg.getExtensionToFactoryMap(), this.resourceFactoryRegistry.getExtensionToFactoryMap());
            this.preserveEntries(factoryReg.getProtocolToFactoryMap(), this.resourceFactoryRegistry.getProtocolToFactoryMap());
        }
        super.setResourceFactoryRegistry(factoryReg);
    }

    protected void preserveEntries(Map map1, Map map2) {
        if (map2.isEmpty()) {
            return;
        }
        Iterator it = map2.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (map1.containsKey(entry.getKey())) continue;
            map1.put(entry.getKey(), entry.getValue());
        }
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        if (this.isReleasing) {
            return null;
        }
        return super.getResource(uri, loadOnDemand);
    }

    public void resetNormalizedURICache() {
        if (this.getURIResourceMap() != null) {
            this.getURIResourceMap().clear();
        }
    }
}

