/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server.http;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.mail.MessagingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.ServerUtils;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.util.IOUtils;
import org.apache.soap.util.MethodUtils;

public class ServerHTTPUtils {
    private static final String SERVICE_MANAGER_ID = "serviceManager";
    private static final String SCRIPT_CLASS = "com.ibm.bsf.BSFManager";
    private static final String SCRIPT_INVOKER = "org.apache.soap.server.InvokeBSF";
    private static final String SERVLET_CLASSLOADER = "servletClassLoader";
    static /* synthetic */ Class class$org$apache$soap$server$DeploymentDescriptor;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceManager getServiceManagerFromContext(ServletContext servletContext, String string) {
        Object object;
        if (servletContext != null) {
            ServletContext servletContext2 = servletContext;
            synchronized (servletContext2) {
                object = servletContext.getAttribute(SERVICE_MANAGER_ID);
                if (object == null) {
                    object = new ServiceManager(servletContext, string);
                    servletContext.setAttribute(SERVICE_MANAGER_ID, object);
                }
            }
        } else {
            object = new ServiceManager(null, string);
        }
        return object;
    }

    public static ServiceManager getServiceManagerFromContext(ServletContext servletContext) {
        return ServerHTTPUtils.getServiceManagerFromContext(servletContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getServletClassLoaderFromContext(ServletContext servletContext) {
        if (servletContext != null) {
            Object object;
            ServletContext servletContext2 = servletContext;
            synchronized (servletContext2) {
                object = servletContext.getAttribute(SERVLET_CLASSLOADER);
            }
            return (ClassLoader)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setServletClassLoaderIntoContext(ServletContext servletContext, ClassLoader classLoader) {
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            servletContext.setAttribute(SERVLET_CLASSLOADER, classLoader);
        }
    }

    public static File getFileFromNameAndContext(String string, ServletContext servletContext) {
        String string2;
        File file = new File(string);
        if (!file.isAbsolute() && servletContext != null && (string2 = servletContext.getRealPath(string)) != null) {
            file = new File(string2);
        }
        return file;
    }

    public static Envelope readEnvelopeFromRequest(DocumentBuilder documentBuilder, String string, int n, InputStream inputStream, EnvelopeEditor envelopeEditor, HttpServletResponse httpServletResponse, SOAPContext sOAPContext) throws SOAPException, IOException {
        try {
            return ServerUtils.readEnvelopeFromInputStream(documentBuilder, inputStream, n, string, envelopeEditor, sOAPContext);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string2 = illegalArgumentException.getMessage();
            httpServletResponse.sendError(400, "Error unmarshalling envelope: " + string2);
            return null;
        }
        catch (MessagingException messagingException) {
            httpServletResponse.sendError(400, "Error unmarshalling envelope: " + messagingException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getTargetObject(ServiceManager serviceManager, DeploymentDescriptor deploymentDescriptor, String string, HttpServlet httpServlet, HttpSession httpSession, SOAPContext sOAPContext, ServletContext servletContext) throws SOAPException {
        Object object;
        Object object2;
        int n = deploymentDescriptor.getScope();
        byte by = deploymentDescriptor.getProviderType();
        Object object3 = null;
        String string2 = by == 0 || by == 3 ? deploymentDescriptor.getProviderClass() : SCRIPT_CLASS;
        Object object4 = null;
        if (n == 0) {
            object4 = httpServlet;
        } else if (n == 1) {
            object4 = httpSession;
        } else if (n == 2) {
            object4 = servletContext;
        } else {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Service uses deprecated object scope 'page': inform provider of error");
        }
        boolean bl = false;
        if (string.equals("urn:xml-soap-service-management-service")) {
            object3 = serviceManager;
        } else {
            if (object4 == null) {
                object4 = string2;
            }
            object2 = object4;
            synchronized (object2) {
                object3 = object4 == httpSession ? httpSession.getValue(string) : (object4 == servletContext ? servletContext.getAttribute(string) : null);
                if (object3 == null) {
                    try {
                        object = sOAPContext.loadClass(string2);
                        object3 = deploymentDescriptor.getIsStatic() ? object : ((Class)object).newInstance();
                        bl = true;
                        if (object4 == httpSession) {
                            httpSession.putValue(string, object3);
                        } else if (object4 == servletContext) {
                            servletContext.setAttribute(string, object3);
                        }
                    }
                    catch (Exception exception) {
                        String string3 = by == 0 || by == 3 ? "Unable to resolve target object: " + exception.getMessage() : "Unable to load BSF: script services not available without BSF: " + exception.getMessage();
                        throw new SOAPException(Constants.FAULT_CODE_SERVER_BAD_TARGET_OBJECT_URI, string3, exception);
                    }
                }
            }
        }
        if (by != 0 && by != 3 && bl) {
            Class[] classArray;
            object2 = null;
            try {
                object2 = sOAPContext.loadClass(SCRIPT_INVOKER);
            }
            catch (Exception exception) {
                String string4 = "Unable to load BSF invoker (org.apache.soap.server.InvokeBSF): script services not available without BSF: " + exception.getMessage();
                throw new SOAPException(Constants.FAULT_CODE_SERVER, string4, exception);
            }
            object = deploymentDescriptor.getScriptFilenameOrString();
            if (by == 1) {
                classArray = servletContext.getRealPath((String)object);
                try {
                    object = IOUtils.getStringFromReader(new FileReader((String)classArray));
                }
                catch (Exception exception) {
                    String string5 = "Unable to load script file (" + (String)classArray + ")" + ": " + exception.getMessage();
                    throw new SOAPException(Constants.FAULT_CODE_SERVER, string5, exception);
                }
            }
            classArray = new Class[]{class$org$apache$soap$server$DeploymentDescriptor == null ? (class$org$apache$soap$server$DeploymentDescriptor = ServerHTTPUtils.class$("org.apache.soap.server.DeploymentDescriptor")) : class$org$apache$soap$server$DeploymentDescriptor, class$java$lang$Object == null ? (class$java$lang$Object = ServerHTTPUtils.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$String == null ? (class$java$lang$String = ServerHTTPUtils.class$("java.lang.String")) : class$java$lang$String};
            try {
                Method method2 = MethodUtils.getMethod((Class)object2, "init", classArray, true);
                method2.invoke(null, deploymentDescriptor, object3, object);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SOAPException) {
                    throw (SOAPException)throwable;
                }
                String string6 = "Unable to invoke init method of script invoker: " + throwable;
                throw new SOAPException(Constants.FAULT_CODE_SERVER, string6, throwable);
            }
            catch (Exception exception) {
                String string7 = "Unable to invoke init method of script invoker: " + exception;
                throw new SOAPException(Constants.FAULT_CODE_SERVER, string7, exception);
            }
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SOAPMappingRegistry getSMRFromContext(ServletContext servletContext) {
        SOAPMappingRegistry sOAPMappingRegistry = null;
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            sOAPMappingRegistry = (SOAPMappingRegistry)servletContext.getAttribute("__cached_servlet_SMR__");
            if (sOAPMappingRegistry == null) {
                sOAPMappingRegistry = new SOAPMappingRegistry();
                servletContext.setAttribute("__cached_servlet_SMR__", sOAPMappingRegistry);
            }
        }
        return sOAPMappingRegistry;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

