/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URLEncoder;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.mime.ByteArrayDataSource;
import org.apache.soap.util.mime.MimeUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MimePartSerializer
implements Serializer,
Deserializer {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$activation$DataHandler;

    public void marshall(String string, Class clazz, Object object, Object object2, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry, SOAPContext sOAPContext) throws IllegalArgumentException, IOException {
        nSStack.pushScope();
        if (!(object == null || object instanceof InputStream || object instanceof DataSource || object instanceof MimeBodyPart || object instanceof DataHandler)) {
            throw new IllegalArgumentException("Tried to pass a '" + object.getClass().toString() + "' to MimePartSerializer");
        }
        if (object == null) {
            SoapEncUtils.generateNullStructure(string, class$java$lang$Object == null ? (class$java$lang$Object = MimePartSerializer.class$("java.lang.Object")) : class$java$lang$Object, null, writer, nSStack, xMLJavaMappingRegistry);
        } else {
            DataSource dataSource = null;
            DataHandler dataHandler = null;
            MimeBodyPart mimeBodyPart = null;
            if (object instanceof InputStream) {
                dataSource = new ByteArrayDataSource((InputStream)object, "application/octet-stream");
            } else if (object instanceof DataSource) {
                dataSource = (DataSource)object;
            }
            if (dataSource != null) {
                dataHandler = new DataHandler(dataSource);
            } else if (object instanceof DataHandler) {
                dataHandler = (DataHandler)object;
            }
            if (dataHandler != null) {
                mimeBodyPart = new MimeBodyPart();
                try {
                    mimeBodyPart.setDataHandler(dataHandler);
                }
                catch (MessagingException messagingException) {
                    throw new IllegalArgumentException("Invalid InputStream/DataSource/DataHandler: " + messagingException);
                }
            } else if (object instanceof MimeBodyPart) {
                mimeBodyPart = (MimeBodyPart)object;
            }
            String string2 = null;
            try {
                string2 = mimeBodyPart.getContentID();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            if (string2 == null) {
                string2 = MimeUtils.getUniqueValue();
                try {
                    mimeBodyPart.setHeader("Content-ID", '<' + string2 + '>');
                }
                catch (MessagingException messagingException) {
                    throw new IllegalArgumentException("Could not set Content-ID: " + messagingException);
                }
            }
            try {
                sOAPContext.addBodyPart(mimeBodyPart);
            }
            catch (MessagingException messagingException) {
                throw new IllegalArgumentException("Could not add attachment: " + messagingException);
            }
            writer.write('<' + object2.toString());
            writer.write(" href =\"cid:" + URLEncoder.encode(string2) + '\"');
            writer.write("/>");
        }
        nSStack.popScope();
    }

    public Bean unmarshall(String string, QName qName, Node node, XMLJavaMappingRegistry xMLJavaMappingRegistry, SOAPContext sOAPContext) throws IllegalArgumentException {
        Element element = (Element)node;
        DataHandler dataHandler = null;
        if (!SoapEncUtils.isNull(element)) {
            String string2 = element.getAttribute("href");
            try {
                MimeBodyPart mimeBodyPart = null;
                try {
                    mimeBodyPart = sOAPContext.findBodyPart(string2);
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (mimeBodyPart == null) {
                    throw new IllegalArgumentException("Attachment tag \"" + element.getTagName() + "\" refers to a Mime attachment with label \"" + string2 + "\" which could not be found.");
                }
                dataHandler = mimeBodyPart.getDataHandler();
            }
            catch (MessagingException messagingException) {
                throw new IllegalArgumentException("Failed to read attachment for tag \"" + element.getTagName() + "\" with label \"" + string2 + "\": " + messagingException);
            }
        }
        return new Bean(class$javax$activation$DataHandler == null ? (class$javax$activation$DataHandler = MimePartSerializer.class$("javax.activation.DataHandler")) : class$javax$activation$DataHandler, dataHandler);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

