/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.pop3;

import com.sun.mail.pop3.DefaultFolder;
import com.sun.mail.pop3.POP3Folder;
import com.sun.mail.pop3.Protocol;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;

public class POP3Store
extends Store {
    private String name;
    private Protocol port;
    private POP3Folder portOwner;
    private String host;
    private int portNum;
    private String user;
    private String passwd;
    boolean rsetBeforeQuit;
    Constructor messageConstructor;

    public POP3Store(Session session, URLName url) {
        block8: {
            String s;
            super(session, url);
            this.name = "pop3";
            this.port = null;
            this.portOwner = null;
            this.host = null;
            this.portNum = -1;
            this.user = null;
            this.passwd = null;
            this.rsetBeforeQuit = false;
            this.messageConstructor = null;
            if (url != null) {
                this.name = url.getProtocol();
            }
            if ((s = session.getProperty("mail." + this.name + ".rsetbeforequit")) != null && s.equalsIgnoreCase("true")) {
                this.rsetBeforeQuit = true;
            }
            if ((s = session.getProperty("mail." + this.name + ".message.class")) != null) {
                if (session.getDebug()) {
                    session.getDebugOut().println("DEBUG: POP3 message class: " + s);
                }
                try {
                    ClassLoader cl = this.getClass().getClassLoader();
                    Class<?> messageClass = null;
                    try {
                        messageClass = cl.loadClass(s);
                    }
                    catch (ClassNotFoundException ex1) {
                        messageClass = Class.forName(s);
                    }
                    Class[] c = new Class[]{Folder.class, Integer.TYPE};
                    this.messageConstructor = messageClass.getConstructor(c);
                }
                catch (Exception ex) {
                    if (!session.getDebug()) break block8;
                    session.getDebugOut().println("DEBUG: failed to load POP3 message class: " + ex);
                }
            }
        }
    }

    protected synchronized boolean protocolConnect(String host, int portNum, String user, String passwd) throws MessagingException {
        String portstring;
        if (host == null || passwd == null || user == null) {
            return false;
        }
        if (portNum == -1 && (portstring = this.session.getProperty("mail." + this.name + ".port")) != null) {
            portNum = Integer.parseInt(portstring);
        }
        this.host = host;
        this.portNum = portNum;
        this.user = user;
        this.passwd = passwd;
        try {
            this.port = this.getPort(null);
        }
        catch (EOFException eex) {
            throw new AuthenticationFailedException(eex.getMessage());
        }
        catch (IOException ioex) {
            throw new MessagingException("Connect failed", ioex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        POP3Store pOP3Store = this;
        synchronized (pOP3Store) {
            try {
                if (this.port == null) {
                    this.port = this.getPort(null);
                } else {
                    this.port.noop();
                }
                return true;
            }
            catch (IOException ioex) {
                try {
                    super.close();
                }
                catch (MessagingException messagingException) {}
                finally {
                    return false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Protocol getPort(POP3Folder owner) throws IOException {
        if (this.port != null && this.portOwner == null) {
            this.portOwner = owner;
            return this.port;
        }
        Protocol p = new Protocol(this.host, this.portNum, this.session.getDebug(), this.session.getDebugOut(), this.session.getProperties(), "mail." + this.name);
        String msg = null;
        msg = p.login(this.user, this.passwd);
        if (msg != null) {
            try {
                p.quit();
            }
            catch (IOException ioex) {}
            finally {
                throw new EOFException(msg);
            }
        }
        if (this.portOwner == null) {
            this.portOwner = owner;
        }
        return p;
    }

    synchronized void closePort(POP3Folder owner) {
        if (this.portOwner == owner) {
            this.port = null;
            this.portOwner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws MessagingException {
        try {
            if (this.port != null) {
                this.port.quit();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.port = null;
            super.close();
        }
    }

    public Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return new DefaultFolder(this);
    }

    public Folder getFolder(String name) throws MessagingException {
        this.checkConnected();
        return new POP3Folder(this, name);
    }

    public Folder getFolder(URLName url) throws MessagingException {
        this.checkConnected();
        return new POP3Folder(this, url.getFile());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.port != null) {
            this.close();
        }
    }

    private void checkConnected() throws MessagingException {
        if (!super.isConnected()) {
            throw new MessagingException("Not connected");
        }
    }
}

