/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.transport;

import com.ibm.trl.util.Logger;
import com.ibm.trl.util.xml.XPathProcessor;
import com.ibm.xml.soap.transport.EditorComponent;
import com.ibm.xml.soap.transport.ErrorHandlerImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractSOAPHandler
implements EditorComponent {
    private static final String URL_PREFIX_FOR_FILE_PATH = "file:///";
    private static final String CURRENT_DIRECTORY = ".";
    private static final String[] TRUE_VALUES = new String[]{"yes", "on", "true"};
    static final String CONFIG_FILE = "filename";
    protected String home = ".";
    protected final DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();

    protected AbstractSOAPHandler() {
        this.builderFactory.setNamespaceAware(true);
    }

    public void init(Properties properties) throws SOAPException {
        String string = properties.getProperty(CONFIG_FILE);
        if (string == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Property 'filename' must be specified");
        }
        Logger.normal(this.getClass().getName() + ": Configuration file path: " + string, 3);
        this.home = properties.getProperty("EnvelopeEditorHome");
        this.home = this.home == null ? CURRENT_DIRECTORY : this.home;
        this.initialize(new InputSource(URL_PREFIX_FOR_FILE_PATH + new File(this.home, string).getAbsolutePath()));
    }

    public abstract void initialize(InputSource var1) throws SOAPException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document loadDocument(InputSource inputSource, boolean bl) throws SOAPException {
        try {
            DocumentBuilder documentBuilder;
            DocumentBuilderFactory documentBuilderFactory = this.builderFactory;
            synchronized (documentBuilderFactory) {
                this.builderFactory.setValidating(bl);
                documentBuilder = this.builderFactory.newDocumentBuilder();
            }
            ErrorHandlerImpl errorHandlerImpl = new ErrorHandlerImpl();
            documentBuilder.setErrorHandler(errorHandlerImpl);
            documentBuilder.setEntityResolver(new JarEntityResolver());
            Document document = documentBuilder.parse(inputSource);
            if (errorHandlerImpl.getErrorCount() > 0) {
                throw new SAXException("Parsing error(s) occured: " + errorHandlerImpl.getErrorCount());
            }
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "JAXP error: Coundn't create a document builder due to parser configuration error", parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "IO error occured while reading an XML file", iOException);
        }
        catch (SAXException sAXException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Parsing error occured while reading an XML file", sAXException);
        }
    }

    public static NodeList processXPath(Node node, String string) throws SOAPException {
        try {
            return XPathProcessor.process(node, string);
        }
        catch (SAXException sAXException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Invalid XPath expression: " + string, sAXException);
        }
    }

    public static boolean evalFlag(Document document, String string) throws SOAPException {
        Node node = AbstractSOAPHandler.processXPath(document, string + "/@flag").item(0);
        if (node == null) {
            return false;
        }
        return AbstractSOAPHandler.isTrue(node.getNodeValue());
    }

    public static boolean isTrue(String string) {
        string = string.trim();
        for (int i = 0; i < TRUE_VALUES.length; ++i) {
            if (!TRUE_VALUES[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static class JarEntityResolver
    implements EntityResolver {
        public InputSource resolveEntity(String string, String string2) {
            String string3 = null;
            if (string2 == null) {
                return null;
            }
            try {
                int n = string2.lastIndexOf(47);
                string3 = n < 0 ? string2 : string2.substring(n + 1);
                ClassLoader classLoader = this.getClass().getClassLoader();
                InputStream inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string3) : classLoader.getResourceAsStream(string3);
                if (inputStream == null) {
                    return null;
                }
                return new InputSource(inputStream);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

