/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.token.LoginProcessor;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.TokenPropagationCallbackHandler;
import com.ibm.wsspi.wssecurity.auth.token.LTPAToken;
import com.ibm.wsspi.wssecurity.auth.token.LTPATokenWrapper;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LTPATokenConsumer
implements TokenConsumerComponent {
    private static final TraceComponent tc = Tr.register((Class)LTPATokenConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LTPATokenConsumer.class.getName();
    private boolean _initialized = false;
    static /* synthetic */ Class array$B;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node node, Map map) throws SoapSecurityException {
        QName qName;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)node) + "], " + "Map context)"));
        }
        Object[] objectArray = (Object[])map.remove("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenConsumerConfig [" + objectArray + "]."));
        }
        if ((qName = objectArray.getType()) == null) {
            qName = Constants.LTPA_TOKEN;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No token value type defined in the Token Consumer configuration, defualt [" + Constants.LTPA_TOKEN.toString() + "] is used."));
            }
        } else if (!qName.equals(Constants.LTPA_TOKEN) && !qName.equals(Constants.LTPA_TOKEN_PROPAGATION)) {
            String string = Constants.LTPA_TOKEN.toString() + ", " + Constants.LTPA_TOKEN_PROPAGATION.toString();
            throw SoapSecurityException.format("security.wssecurity.WSEC0162E", new String[]{qName.toString(), clsName, string});
        }
        if (node.getNodeType() == 1) {
            Object object;
            Object[] objectArray2;
            Object object2;
            Element element = (Element)node;
            String string = null;
            String string2 = IdUtil.getInstance().getIdAttributeName(element);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The identifier attribute of the target element is [" + string2 + "]."));
            }
            if (string2 != null) {
                string = element.getAttribute(string2);
            }
            byte[] byArray = Base64.decode((String)DOMUtil.getStringValue((Node)node));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Base64-decoded binary credential [" + byArray + "]"));
            }
            if (byArray == null || byArray.length == 0) {
                throw SoapSecurityException.format("security.wssecurity.WSEC0163E");
            }
            QName qName2 = DOMUtil.getQName((Element)element, (String)element.getAttribute("ValueType"));
            boolean bl = false;
            if (qName2 == null) {
                throw SoapSecurityException.format("security.wssecurity.WSEC0164E", new String[]{qName.toString()});
            }
            if (!Constants.LTPA_TOKEN.equals(qName2)) {
                if (Constants.LTPA_TOKEN_PROPAGATION.equals(qName2)) {
                    bl = true;
                } else {
                    String string3 = Constants.LTPA_TOKEN.toString() + ", " + Constants.LTPA_TOKEN_PROPAGATION.toString();
                    throw SoapSecurityException.format("security.wssecurity.WSEC0165E", new String[]{qName.toString(), clsName, string3});
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("token propagation is " + bl));
            }
            LTPAToken lTPAToken = null;
            if (bl) {
                int n;
                WSCredentialTokenMapperInterface wSCredentialTokenMapperInterface;
                ArrayList arrayList;
                SecurityCache securityCache;
                block70: {
                    object2 = null;
                    objectArray2 = null;
                    object = null;
                    securityCache = null;
                    arrayList = null;
                    wSCredentialTokenMapperInterface = null;
                    wSCredentialTokenMapperInterface = _wsCredToken._wsCredTokenMapper;
                    securityCache = _authCacheClass._authCache;
                    try {
                        arrayList = WSOpaqueTokenHelper.getInstance().createTokenHolderListFromOpaqueToken(byArray);
                        objectArray2 = this.getSubjectFromTokenHolderCacheKey(null, arrayList);
                    }
                    catch (WSSecurityException wSSecurityException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Caught WSSecurityException trying to get cached Subject: " + wSSecurityException));
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block70;
                        Tr.debug((TraceComponent)tc, (String)("Caught Exception trying to get cached Subject: " + exception));
                    }
                }
                if (objectArray2 != null) {
                    object2 = (Subject)objectArray2[0];
                    object = (String)objectArray2[1];
                }
                WSCredential wSCredential = null;
                WSPrincipal wSPrincipal = null;
                if (object2 != null) {
                    wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)object2);
                    wSPrincipal = SubjectHelper.getPrincipalFromSubject((Subject)object2);
                    if (wSCredential != null) {
                        boolean bl2 = wSCredential.isDestroyed();
                        n = 0;
                        try {
                            n = wSCredential.isForwardable();
                        }
                        catch (Exception exception) {
                            bl2 = true;
                        }
                        boolean bl3 = false;
                        if (securityCache != null && wSCredentialTokenMapperInterface != null) {
                            bl3 = wSCredentialTokenMapperInterface.checkCushionValidityOfAllTokens((Subject)object2, securityCache.getCushion());
                        }
                        if (tc.isDebugEnabled()) {
                            if (n != 0) {
                                Tr.debug((TraceComponent)tc, (String)("credential is forwardable, subject valid = " + bl3));
                            } else {
                                Tr.debug((TraceComponent)tc, (String)"non-forwardable Subject");
                            }
                        }
                        if (bl2 || n != 0 && !bl3) {
                            object2 = null;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Credential has expired or is destroyed, logging in again.");
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Cached subject is valid.");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"No WSCredential in Subject, logging in again.");
                        }
                        object2 = null;
                    }
                }
                if (object2 == null) {
                    Object object3;
                    wSCredential = null;
                    wSPrincipal = null;
                    String string4 = objectArray.getJAASConfig();
                    if (string4 == null || string4.length() == 0) {
                        string4 = "system.WSS_INBOUND";
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Using JAAS config: " + string4));
                    }
                    n = 0;
                    if (arrayList != null) {
                        n = arrayList.size();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("tokenList size = " + n));
                    }
                    byte[] byArray2 = null;
                    for (int i = 0; i < n; ++i) {
                        object3 = arrayList.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("tokenList object [" + i + "] = " + object3.getClass().getName()));
                        }
                        if (!(object3 instanceof TokenHolder)) continue;
                        TokenHolder tokenHolder = (TokenHolder)object3;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("th[" + i + "].name = " + tokenHolder.getName()));
                            Tr.debug((TraceComponent)tc, (String)("th[" + i + "].version = " + tokenHolder.getVersion()));
                        }
                        if (!"com.ibm.ws.security.token.AuthorizationTokenImpl".equals(tokenHolder.getName())) continue;
                        byArray2 = tokenHolder.getBytes();
                        if (!tc.isDebugEnabled()) continue;
                        if (byArray2 != null && byArray2.length > 0) {
                            Tr.debug((TraceComponent)tc, (String)"Got cred bytes from authz TokenHolder");
                            continue;
                        }
                        Tr.debug((TraceComponent)tc, (String)"Cred bytes from authz TokenHolder was null or zero-length");
                    }
                    LoginContext loginContext = null;
                    try {
                        object3 = new TokenPropagationCallbackHandler(map, arrayList, byArray2);
                        loginContext = new LoginContext(string4, (CallbackHandler)object3);
                        loginContext.login();
                    }
                    catch (LoginException loginException) {
                        Tr.processException((Throwable)loginException, (String)(LTPATokenConsumer.class.getName() + ".invoke()"), (String)"347", (Object)this);
                        throw new SoapSecurityException("Error logging in: " + loginException.getClass().getName() + ": " + loginException.getMessage());
                    }
                    object2 = object3 = loginContext.getSubject();
                    if (object == null || ((String)object).length() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"No cache key string found in token list; will not cache new subject.");
                        }
                    } else if (securityCache != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Caching new subject with cache key string: " + (String)object));
                        }
                        securityCache.insert((Subject)object3, new Object[]{object});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Not caching new subject because Securitycache instance is null.");
                    }
                    wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)object3);
                    wSPrincipal = SubjectHelper.getPrincipalFromSubject((Subject)object3);
                }
                final LTPAToken lTPAToken2 = lTPAToken = new LTPATokenWrapper(string, null, wSCredential, wSPrincipal);
                Object[] objectArray3 = objectArray;
                AccessController.doPrivileged(new PrivilegedAction((TokenConsumerConfig)objectArray3){
                    private final /* synthetic */ TokenConsumerConfig val$configPriv;
                    {
                        this.val$configPriv = tokenConsumerConfig;
                    }

                    public Object run() {
                        lTPAToken2.setUsedTokenConsumer(this.val$configPriv);
                        return null;
                    }
                });
                LTPATokenConsumer.setTokenToSubject(map, lTPAToken);
                if (object2 != null) {
                    LoginProcessor.addToSubject(map, (Subject)object2);
                }
            } else {
                Object object4;
                Object object5;
                Object object6;
                lTPAToken = new LTPAToken(string, null);
                object2 = lTPAToken;
                objectArray2 = objectArray;
                AccessController.doPrivileged(new PrivilegedAction((LTPAToken)object2, (TokenConsumerConfig)objectArray2){
                    private final /* synthetic */ LTPAToken val$tokenPrivSetUsedTokenConsumer;
                    private final /* synthetic */ TokenConsumerConfig val$configPriv;
                    {
                        this.val$tokenPrivSetUsedTokenConsumer = lTPAToken;
                        this.val$configPriv = tokenConsumerConfig;
                    }

                    public Object run() {
                        this.val$tokenPrivSetUsedTokenConsumer.setUsedTokenConsumer(this.val$configPriv);
                        return null;
                    }
                });
                LTPATokenConsumer.setTokenToSubject(map, lTPAToken);
                object = lTPAToken;
                byte[] byArray3 = byArray;
                AccessController.doPrivileged(new PrivilegedAction((LTPAToken)object, byArray3){
                    private final /* synthetic */ LTPAToken val$tokenSetBytesPriv;
                    private final /* synthetic */ byte[] val$credPriv;
                    {
                        this.val$tokenSetBytesPriv = lTPAToken;
                        this.val$credPriv = byArray;
                    }

                    public Object run() {
                        this.val$tokenSetBytesPriv.setBytes(this.val$credPriv);
                        return null;
                    }
                });
                WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
                Set set = wSSConsumerConfig.getCallers();
                boolean bl4 = false;
                if (set != null) {
                    object6 = set.iterator();
                    while (object6.hasNext()) {
                        object5 = (WSSConsumerConfig.CallerConfig)object6.next();
                        object4 = object5.getTokenType();
                        if (!((QName)object4).equals(qName2)) continue;
                        bl4 = true;
                        break;
                    }
                }
                if (!bl4) {
                    object6 = null;
                    try {
                        object5 = getLTPAMethod._validateLTPATokenMethod;
                        object4 = getLTPAMethod._ltpaServerObject;
                        if (object5 != null && object4 != null) {
                            object6 = ((Method)object5).invoke(object4, new Object[]{byArray});
                        }
                    }
                    catch (Exception exception) {
                        throw new SoapSecurityException("security.wssecurityLTPA Token validation failed");
                    }
                    if (object6 == null) {
                        throw new SoapSecurityException("security.wssecurityLTPA Token validation failed");
                    }
                }
            }
            object2 = objectArray.getJAASConfig();
            if (object2 != null && !bl && tc.isDebugEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.LTPATokenConsumer.s01", (Object)object2);
            }
            if (objectArray.getTrustedIDEvaluator() != null) {
                boolean bl5 = objectArray.getTrustedIDEvaluator().evaluate("***");
                object = lTPAToken;
                if (!bl5) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.UsernameTokenConsumer.s02", (Object)new Object[]{string});
                }
                AccessController.doPrivileged(new PrivilegedAction((LTPAToken)object, bl5){
                    private final /* synthetic */ LTPAToken val$tokenPriv;
                    private final /* synthetic */ boolean val$trusted;
                    {
                        this.val$tokenPriv = lTPAToken;
                        this.val$trusted = bl;
                    }

                    public Object run() {
                        this.val$tokenPriv.setTrusted(this.val$trusted);
                        return null;
                    }
                });
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Acquired token is [" + lTPAToken + "]."));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WARNING: Unsupported node type: " + node.getNodeName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Node target,Map context)");
        }
    }

    private static void setTokenToSubject(Map map, LTPAToken lTPAToken) {
        TokenManager.setToken(map, lTPAToken);
    }

    private Object[] getSubjectFromTokenHolderCacheKey(byte[] byArray, List list) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubjectFromTokenHolderCacheKey", (Object)new Object[]{byArray, list});
        }
        Subject subject = null;
        String string = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                boolean bl;
                Object object;
                TokenHolder tokenHolder = (TokenHolder)list.get(i);
                if (!tokenHolder.getName().equals("com.ibm.wsspi.security.cred.cacheKey")) continue;
                byte[] byArray2 = tokenHolder.getBytes();
                if (byArray2 != null) {
                    string = StringBytesConversion.getConvertedString(byArray2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found cache key from token holder list: " + string));
                    }
                    object = _authCacheClass._authCache;
                    subject = object.getSubject(string);
                }
                if (subject == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found Subject using cacheKey from prop token.");
                }
                if (byArray == null) continue;
                object = SubjectHelper.getWSCredentialFromSubject(subject);
                SingleSignonToken singleSignonToken = SubjectHelper.getDefaultSSOTokenFromSubject(subject);
                boolean bl2 = bl = object != null && Arrays.equals(byArray, object.getCredentialToken()) || singleSignonToken != null && Arrays.equals(byArray, singleSignonToken.getBytes());
                if (bl) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Subject found from cacheKey does not have matching LTPA token.");
                }
                subject = null;
            }
        }
        Object[] objectArray = null;
        if (subject != null || string != null) {
            objectArray = new Object[]{subject, string};
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubjectFromTokenHolderCacheKey", objectArray);
        }
        return objectArray;
    }

    private static class _authCacheClass {
        static SecurityCache _authCache = null;
        private static final String FACTORY_CLASS = "com.ibm.ws.security.auth.AuthCache";

        private _authCacheClass() {
        }

        private static Method getAuthCacheGetInstanceMethod() {
            Method method2 = null;
            Class clazz = _authCacheClass.getAuthCacheClass();
            if (clazz != null) {
                try {
                    method2 = clazz.getMethod("getInstance", null);
                }
                catch (Exception exception) {
                    Tr.processException((Throwable)exception, (String)(clsName + ".getAuthCacheGetInstanceMethod"), (String)"703");
                    throw new UndeclaredThrowableException(exception);
                }
            }
            return method2;
        }

        private static Class getAuthCacheClass() {
            Class<?> clazz = null;
            Class<?> clazz2 = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz2 = classLoader != null ? classLoader.loadClass(FACTORY_CLASS) : Class.forName(FACTORY_CLASS);
                clazz = clazz2;
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, (String)(clsName + ".getAuthCacheClass"), (String)"730");
                throw new UndeclaredThrowableException(exception);
            }
            return clazz;
        }

        static {
            try {
                Method method2 = _authCacheClass.getAuthCacheGetInstanceMethod();
                if (method2 != null) {
                    _authCache = (SecurityCache)method2.invoke(null, null);
                    if (tc.isDebugEnabled()) {
                        if (_authCache == null) {
                            Tr.debug((TraceComponent)tc, (String)"AuthCache.getInstance method returned null.");
                        } else {
                            Tr.debug((TraceComponent)tc, (String)"AuthCache.getInstance method returned an AuthCache instance.");
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to get AuthCache.getInstance method.");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, clsName + "init", "687");
            }
        }
    }

    private static class _wsCredToken {
        static WSCredentialTokenMapperInterface _wsCredTokenMapper = null;

        private _wsCredToken() {
        }

        static {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object obj = clazz.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Got instance of WSCredTokenMapper.");
                }
                _wsCredTokenMapper = (WSCredentialTokenMapperInterface)obj;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, clsName + "init", "663");
            }
        }
    }

    private static class getLTPAMethod {
        private static final String LTPA_SERVER_OBJECT_CLASS = "com.ibm.ws.security.ltpa.LTPAServerObject";
        private static Class _ltpaServerObjectClass = null;
        private static Method _validateLTPATokenMethod = null;
        private static Method _getLTPAServerMethod = null;
        private static Object _ltpaServerObject = null;

        private getLTPAMethod() {
        }

        static {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (_ltpaServerObjectClass == null) {
                        Class<?> clazz = null;
                        try {
                            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                            clazz = classLoader != null ? classLoader.loadClass(getLTPAMethod.LTPA_SERVER_OBJECT_CLASS) : Class.forName(getLTPAMethod.LTPA_SERVER_OBJECT_CLASS);
                            _ltpaServerObjectClass = clazz;
                        }
                        catch (Exception exception) {
                            throw new UndeclaredThrowableException(exception);
                        }
                    }
                    if (_getLTPAServerMethod == null && _ltpaServerObjectClass != null) {
                        try {
                            _getLTPAServerMethod = _ltpaServerObjectClass.getMethod("getLTPAServer", new Class[0]);
                            if (_getLTPAServerMethod != null) {
                                _ltpaServerObject = _getLTPAServerMethod.invoke(null, new Object[0]);
                            }
                        }
                        catch (Exception exception) {
                            throw new UndeclaredThrowableException(exception);
                        }
                    }
                    if (_validateLTPATokenMethod == null && _ltpaServerObjectClass != null) {
                        try {
                            _validateLTPATokenMethod = _ltpaServerObjectClass.getMethod("validateToken", array$B == null ? (array$B = LTPATokenConsumer.class$("[B")) : array$B);
                        }
                        catch (Exception exception) {
                            throw new UndeclaredThrowableException(exception);
                        }
                    }
                    return null;
                }
            });
        }
    }
}

